/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.calcmember;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.entity.result.OlapResCreateMeasureBlankStatementDataSet;
import crazydev.iccube.olap.eval.create.OlapCreateStatementInstr;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapCreateMeasureEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapCreateMeasureStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementWithCubeSelectExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapCreateMeasureStatementInstr
extends OlapCreateStatementInstr<OlapCreateMeasureStatementExecutionContext> {
    private final OlapInstrLocationRange idRange;
    @Nullable
    private final String cubeName;
    private final String measureName;
    private final OlapInstr formula;
    private final OlapCellProperties properties;

    public OlapCreateMeasureStatementInstr(OlapInstrLocationRange idRange, OlapInstrLocationRange range, @Nullable String cubeName, String measureName, OlapInstr formula, OlapCellProperties properties) {
        super(range);
        this.idRange = idRange;
        this.cubeName = cubeName;
        this.measureName = measureName;
        this.formula = formula;
        this.formula.setParent(this);
        this.properties = properties;
    }

    @Override
    public String typeForError() {
        return "CREATE MEASURE";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.formula.accept(v);
        }
    }

    @Override
    protected OlapCreateMeasureStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapCreateMeasureStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapCreateMeasureStatementExecutionContext context) {
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        OlapSchema schema = context.getSchema();
        if (!perms.isBuilderEnabled()) {
            throw new OlapEvaluationException(context, OlapErrorCode.NOT_AUTHORIZED, new Serializable[]{"app.builder"});
        }
        if (context.isPrepareExecutionMode()) {
            return new OlapResCreateMeasureBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        OlapNameContext nameContext = context.getNameContext();
        OlapCube cube = context.lookupCubeEx(nameContext, this.cubeName);
        if (cube == null) {
            return (OlapEntity)OlapInstr.onInstrExecutionError(context, OlapErrorCode.CALC_MEASURE_MISSING_CUBE, new Serializable[]{this.measureName});
        }
        OlapMdxStatementWithCubeSelectExecutionContext contextWithCube = new OlapMdxStatementWithCubeSelectExecutionContext(context.getRequestContext(), context.getRequestProperties(), context.getAnnotations(), context.getInstrExecListener(), schema, cube, false);
        OlapCreateMeasureEvaluationContext evalContext = new OlapCreateMeasureEvaluationContext(contextWithCube);
        OlapHierarchy defaultTimeHierarchy = evalContext.getDefaultTimeHierarchy();
        OlapUserMeasureMember measure = this.createUserMeasure(evalContext, defaultTimeHierarchy, cube, false, this.measureName, this.formula, this.properties);
        this.registerMeasure(context, cube, measure);
        this.onScriptStatementApplied(context, schema, true);
        return new OlapResCreateMeasureBlankStatementDataSet(schema.getName(), "?", measure.getUniqueName(nameContext));
    }

    private void registerMeasure(OlapCreateMeasureStatementExecutionContext context, OlapCube cube, OlapUserMeasureMember calcMember) {
        OlapNameContext nameContext = context.getNameContext();
        IOlapSchemaPermission schemaPermissions = context.getSchemaPermissions();
        IOlapCubePermission cubePermissions = schemaPermissions.getCubePermissions(cube);
        OlapCubeCalculatedMemberManager manager = cube.getCalcMemberManager();
        manager.addUserMeasureIfNotContained(this.idRange, cubePermissions, nameContext, calcMember);
    }

    @Override
    public String toStringForDebugger() {
        return "CREATE MEASURE : " + (String)(this.cubeName != null ? this.cubeName + "." : "") + this.measureName;
    }
}

