/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.calcmember;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.olap.compiler.ast.MdxEntityCompiler;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapSchemaCreateCalcMemberCube;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapSchemaCalculatedMemberManager;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.OlapCreateCalcMemberEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapCreateCalcMemberStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementWithCubeSelectExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.io.Serializable;

public class OlapCreateCalcMemberStatementInstrHelper {
    private final OlapCreateCalcMemberStatementExecutionContext context;
    private final OlapNameContext nameContext;
    private final OlapInstrLocationRange idRange;
    private final MdxIdentifierExpression parsedId;
    private final OlapEntityIdentifier id;
    private final OlapInstr formula;
    private final OlapCellProperties properties;
    private OlapCube cube;
    private OlapCube calcMemberCube;

    public OlapCreateCalcMemberStatementInstrHelper(OlapCreateCalcMemberStatementExecutionContext context, OlapNameContext nameContext, OlapInstrLocationRange idRange, MdxIdentifierExpression parsedId, OlapEntityIdentifier id, OlapInstr formula, OlapCellProperties properties) {
        this.context = context;
        this.nameContext = nameContext;
        this.idRange = idRange;
        this.parsedId = parsedId;
        this.id = id;
        this.formula = formula;
        this.properties = properties;
    }

    public OlapMember createCalcMember(boolean isGlobalSession) {
        boolean isNameWithCube;
        OlapEntityIdentifier idWithoutCubePart;
        OlapSchema schema = this.context.getSchema();
        String firstPart = this.id.getFirstPartAsName();
        this.cube = this.context.lookupCube(this.nameContext, firstPart);
        if (this.cube != null) {
            if (this.id.getPartCount() == 1) {
                return (OlapMember)OlapInstr.onInstrExecutionError(this.context, OlapErrorCode.CALC_MEASURE_MISSING_NAME, new Serializable[]{this.id.asString()});
            }
            idWithoutCubePart = this.id.subIdentifier(1);
            isNameWithCube = true;
        } else {
            idWithoutCubePart = this.id;
            isNameWithCube = false;
        }
        if ((OlapCaseInsensitiveName.equals(idWithoutCubePart.getFirstPartAsName(), "Measures") || idWithoutCubePart.getPartCount() == 1) && this.cube == null) {
            if (schema.getCubeCount() == 1) {
                this.cube = schema.getFirstCube();
            } else {
                return (OlapMember)OlapInstr.onInstrExecutionError(this.context, OlapErrorCode.CALC_MEASURE_MISSING_CUBE, new Serializable[]{this.id.asString()});
            }
        }
        OlapEntityIdentifier anchorId = idWithoutCubePart.getPartCount() == 1 ? MdxEntityCompiler.createOlapMeasuresIdentifier() : idWithoutCubePart.subIdentifier(0, idWithoutCubePart.getPartCount() - 1);
        String name = this.id.getLastPartAsName();
        String definedUniqueName = this.context.definedCalcMemberUniqueName(this.parsedId, isNameWithCube);
        this.calcMemberCube = this.cube != null ? this.cube : new OlapSchemaCreateCalcMemberCube(this.context.getSchema());
        OlapMdxStatementWithCubeSelectExecutionContext calcMemberStatementContext = new OlapMdxStatementWithCubeSelectExecutionContext(this.context.getRequestContext(), this.context.getRequestProperties(), this.context.getAnnotations(), this.context.getInstrExecListener(), schema, this.calcMemberCube, true);
        OlapCreateCalcMemberEvaluationContext calcMemberEvalContext = new OlapCreateCalcMemberEvaluationContext(calcMemberStatementContext, isGlobalSession);
        OlapCalculatedMember calcMember = OlapInstr.createCalcMember(calcMemberEvalContext, false, -1L, this.idRange, anchorId, name, this.formula, this.properties, definedUniqueName);
        return calcMember;
    }

    public void registerCalcMember(OlapMember calcMember) {
        IOlapSchemaPermission schemaPermissions = this.context.getSchemaPermissions();
        OlapSchema schema = this.context.getSchema();
        OlapNameContext nameContext = this.context.getNameContext();
        if (this.cube == null || !calcMember.isMeasure()) {
            OlapSchemaCalculatedMemberManager calcMemberManager = schema.getCalcMemberManager();
            calcMemberManager.addIfNotContained(this.idRange, schemaPermissions, nameContext, calcMember);
        } else {
            IOlapCubePermission cubePermissions = schemaPermissions.getCubePermissions(this.cube);
            OlapCubeCalculatedMemberManager calcMemberManager = this.calcMemberCube.getCalcMemberManager();
            calcMemberManager.addIfNotContained(this.idRange, cubePermissions, nameContext, calcMember);
        }
    }

    public void registerSessionCalcMember(OlapCreateCalcMemberStatementExecutionContext context, OlapMember calcMember) {
        context.addSessionCalcMemberIfNotContained(this.idRange, this.nameContext, calcMember);
    }
}

