/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.calcmember;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.entity.result.OlapResCreateCalcMemberBlankStatementDataSet;
import crazydev.iccube.olap.eval.calcmember.OlapCreateCalcMemberStatementInstrHelper;
import crazydev.iccube.olap.eval.create.OlapCreateStatementInstr;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapCreateCalcMemberStatementExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapCreateCalcMemberStatementInstr
extends OlapCreateStatementInstr<OlapCreateCalcMemberStatementExecutionContext> {
    private final OlapInstrLocationRange idRange;
    private final MdxIdentifierExpression parsedId;
    private final OlapEntityIdentifier id;
    private final boolean sessionScoped;
    private final OlapInstr formula;
    private final OlapCellProperties properties;

    public OlapCreateCalcMemberStatementInstr(OlapInstrLocationRange idRange, OlapInstrLocationRange range, MdxIdentifierExpression parsedId, OlapEntityIdentifier id, boolean sessionScoped, OlapInstr formula, OlapCellProperties properties) {
        super(range);
        this.idRange = idRange;
        this.parsedId = parsedId;
        this.id = id;
        this.sessionScoped = sessionScoped;
        this.formula = formula;
        this.formula.setParent(this);
        this.properties = properties;
    }

    @Override
    public String typeForError() {
        return "CREATE CALCULATED MEMBER";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.formula.accept(v);
        }
    }

    @Override
    protected OlapCreateCalcMemberStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapCreateCalcMemberStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapCreateCalcMemberStatementExecutionContext context) {
        if (!this.sessionScoped) {
            return this.executeForGlobalScope(context);
        }
        return this.executeForSessionScope(context);
    }

    private OlapEntity executeForGlobalScope(OlapCreateCalcMemberStatementExecutionContext context) {
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        if (!perms.isBuilderEnabled()) {
            throw new OlapEvaluationException(context, OlapErrorCode.NOT_AUTHORIZED, new Serializable[]{"app.builder"});
        }
        OlapSchema schema = context.getSchema();
        if (context.isPrepareExecutionMode()) {
            return new OlapResCreateCalcMemberBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        OlapNameContext nameContext = context.getNameContext();
        OlapCreateCalcMemberStatementInstrHelper helper = new OlapCreateCalcMemberStatementInstrHelper(context, nameContext, this.idRange, this.parsedId, this.id, this.formula, this.properties);
        OlapMember calcMember = helper.createCalcMember(true);
        helper.registerCalcMember(calcMember);
        this.onScriptStatementApplied(context, schema, true);
        return new OlapResCreateCalcMemberBlankStatementDataSet(schema.getName(), "?", calcMember.getUniqueName(nameContext));
    }

    private OlapEntity executeForSessionScope(OlapCreateCalcMemberStatementExecutionContext context) {
        if (context.isSessionLess()) {
            throw new OlapEvaluationException(context, OlapErrorCode.MDX_SESSION_MISMATCH, new Serializable[]{"calculated-member"});
        }
        OlapSchema schema = context.getSchema();
        if (context.isPrepareExecutionMode()) {
            return new OlapResCreateCalcMemberBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        OlapNameContext nameContext = context.getNameContext();
        OlapCreateCalcMemberStatementInstrHelper helper = new OlapCreateCalcMemberStatementInstrHelper(context, nameContext, this.idRange, this.parsedId, this.id, this.formula, this.properties);
        OlapMember calcMember = helper.createCalcMember(false);
        helper.registerSessionCalcMember(context, calcMember);
        this.onScriptStatementApplied(context, schema, false);
        return new OlapResCreateCalcMemberBlankStatementDataSet(schema.getName(), "?", calcMember.getUniqueName(nameContext));
    }

    public OlapEntityIdentifier getId() {
        return this.id;
    }

    @Override
    public String toStringForDebugger() {
        return "CREATE CALCULATED MEMBER : " + this.id.asString();
    }
}

