/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.statement;

import crazydev.iccube.authorizationx.permissions.schema.OlapRoleDefaultCalcMembers;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleDefaultMembers;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.cache.statement.OlapStatementCacheManager;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupSurrogate;
import org.jetbrains.annotations.Nullable;

public class OlapStatementDefaultsCacheManager {
    private final OlapStatementCacheManager owner;

    public OlapStatementDefaultsCacheManager(OlapStatementCacheManager owner) {
        this.owner = owner;
    }

    public OlapRoleDefaultCalcMembers getDefaultAsCalcMembersFromPermissions() {
        OlapMdxStatementExecutionContext sContext = this.owner.getStatementExecutionContext();
        IOlapSchemaPermission permissions = sContext.getSchemaPermissions();
        OlapCube cube = sContext.getNullableCube();
        if (cube == null) {
            return OlapRoleDefaultCalcMembers.NONE;
        }
        OlapRoleDefaultCalcMembers defaults = permissions.getDefaultAsCalcMembers(cube);
        return defaults;
    }

    public OlapRoleDefaultMembers getDefaultsFromPermissions(@Nullable OlapFactMeasureGroupSurrogate measureGroup) {
        OlapMdxStatementExecutionContext sContext = this.owner.getStatementExecutionContext();
        IOlapSchemaPermission permissions = sContext.getSchemaPermissions();
        OlapCube cube = sContext.getNullableCube();
        if (cube == null) {
            return OlapRoleDefaultMembers.NONE;
        }
        OlapRoleDefaultMembers defaults = permissions.getDefaults(cube, measureGroup);
        return defaults;
    }
}

