/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.statement;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleDefaultCalcMembers;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleDefaultMembers;
import crazydev.iccube.common.OlapIdentity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.cache.statement.OlapMemberFilterCacheManager;
import crazydev.iccube.olap.eval.cache.statement.OlapStatementDefaultsCacheManager;
import crazydev.iccube.olap.eval.cache.statement.OlapTupleFilterCacheManager;
import crazydev.iccube.olap.eval.filter.dimension.OlapChainMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapChainTupleFilter;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.facts.IOlapFactMeasureGroupManagerForEval;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupSurrogate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapStatementCacheManager {
    private final OlapMdxStatementExecutionContext statementExecutionContext;
    private final OlapTupleDimensionalityCache tupleDimensionalityCache;
    private final Map<ChainMemberFilterKey, OlapMemberFilterCacheManager> memberFilterCacheManagers = new HashMap<ChainMemberFilterKey, OlapMemberFilterCacheManager>();
    private final Object noMemberFilterCacheManagerLOCK = new Object();
    private final Map<ChainTupleFilterKey, OlapTupleFilterCacheManager> tupleFilterCacheManagers = new HashMap<ChainTupleFilterKey, OlapTupleFilterCacheManager>();
    private final Object noTupleFilterCacheManagerLOCK = new Object();
    private final Map<Object, Object> userDefinedObjects = new HashMap<Object, Object>();
    private final OlapStatementDefaultsCacheManager defaultsCacheManager;
    private OlapMemberFilterCacheManager noMemberFilterCacheManager;
    private OlapTupleFilterCacheManager noTupleFilterCacheManager;

    public OlapStatementCacheManager(OlapMdxStatementExecutionContext statementExecutionContext) {
        this.statementExecutionContext = statementExecutionContext;
        this.tupleDimensionalityCache = new OlapTupleDimensionalityCache();
        this.defaultsCacheManager = new OlapStatementDefaultsCacheManager(this);
    }

    public OlapMdxStatementExecutionContext getStatementExecutionContext() {
        return this.statementExecutionContext;
    }

    public OlapTupleDimensionalityCache getTupleDimensionalityCache() {
        return this.tupleDimensionalityCache;
    }

    public OlapMemberFilterCacheManager getOrCreateMemberFilterCacheManager(OlapEvaluationContext context) {
        if (this.statementExecutionContext != context.getStatementExecutionContext()) {
            throw new CdProgrammingException("internal error : unexpected statement context!");
        }
        OlapChainMemberFilter filter = context.createChainMemberFilter();
        if (filter == null) {
            return this.getOrCreateMemberFilterCacheManager();
        }
        return this.getOrCreateMemberFilterCacheManager(filter);
    }

    public OlapTupleFilterCacheManager getOrCreateTupleFilterCacheManager(OlapEvaluationContext context) {
        if (this.statementExecutionContext != context.getStatementExecutionContext()) {
            throw new CdProgrammingException("internal error : unexpected statement context!");
        }
        OlapChainTupleFilter filter = context.createChainTupleFilter();
        if (filter == null) {
            return this.getOrCreateTupleFilterCacheManager();
        }
        return this.getOrCreateTupleFilterCacheManager(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapMemberFilterCacheManager getOrCreateMemberFilterCacheManager() {
        Object object = this.noMemberFilterCacheManagerLOCK;
        synchronized (object) {
            if (this.noMemberFilterCacheManager == null) {
                this.noMemberFilterCacheManager = new OlapMemberFilterCacheManager(this, null);
            }
            return this.noMemberFilterCacheManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapMemberFilterCacheManager getOrCreateMemberFilterCacheManager(OlapChainMemberFilter filter) {
        ChainMemberFilterKey key = new ChainMemberFilterKey(filter);
        Map<ChainMemberFilterKey, OlapMemberFilterCacheManager> map = this.memberFilterCacheManagers;
        synchronized (map) {
            OlapMemberFilterCacheManager cacheManager = this.memberFilterCacheManagers.get(key);
            if (cacheManager == null) {
                cacheManager = new OlapMemberFilterCacheManager(this, filter);
                this.memberFilterCacheManagers.put(key, cacheManager);
            }
            return cacheManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapTupleFilterCacheManager getOrCreateTupleFilterCacheManager() {
        Object object = this.noTupleFilterCacheManagerLOCK;
        synchronized (object) {
            if (this.noTupleFilterCacheManager == null) {
                this.noTupleFilterCacheManager = new OlapTupleFilterCacheManager(this, null);
            }
            return this.noTupleFilterCacheManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapTupleFilterCacheManager getOrCreateTupleFilterCacheManager(OlapChainTupleFilter filter) {
        ChainTupleFilterKey key = new ChainTupleFilterKey(filter);
        Map<ChainTupleFilterKey, OlapTupleFilterCacheManager> map = this.tupleFilterCacheManagers;
        synchronized (map) {
            OlapTupleFilterCacheManager cacheManager = this.tupleFilterCacheManagers.get(key);
            if (cacheManager == null) {
                cacheManager = new OlapTupleFilterCacheManager(this, filter);
                this.tupleFilterCacheManagers.put(key, cacheManager);
            }
            return cacheManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getCachedObject(Object key) {
        Map<Object, Object> map = this.userDefinedObjects;
        synchronized (map) {
            return this.userDefinedObjects.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCachedObject(Object key, Object formatter) {
        Map<Object, Object> map = this.userDefinedObjects;
        synchronized (map) {
            this.userDefinedObjects.put(key, formatter);
        }
    }

    public OlapRoleDefaultCalcMembers getDefaultAsCalcMembersFromPermissions() {
        OlapRoleDefaultCalcMembers defaults = this.defaultsCacheManager.getDefaultAsCalcMembersFromPermissions();
        return defaults;
    }

    public OlapRoleDefaultMembers getDefaultsFromPermissions(@Nullable IOlapFactMeasureGroupManagerForEval measureGroup) {
        OlapFactMeasureGroupSurrogate surrogate = measureGroup != null ? measureGroup.asSurrogate() : null;
        OlapRoleDefaultMembers defaults = this.defaultsCacheManager.getDefaultsFromPermissions(surrogate);
        return defaults;
    }

    static class ChainMemberFilterKey {
        final OlapIdentity[] identities;

        public ChainMemberFilterKey(OlapChainMemberFilter filter) {
            this.identities = new OlapIdentity[filter.size()];
            for (int idx = 0; idx < this.identities.length; ++idx) {
                this.identities[idx] = filter.get(idx);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChainMemberFilterKey key = (ChainMemberFilterKey)o;
            return Arrays.equals(this.identities, key.identities);
        }

        public int hashCode() {
            return Arrays.hashCode(this.identities);
        }
    }

    static class ChainTupleFilterKey {
        final OlapIdentity[] identities;

        public ChainTupleFilterKey(OlapChainTupleFilter filter) {
            this.identities = new OlapIdentity[filter.size()];
            for (int idx = 0; idx < this.identities.length; ++idx) {
                this.identities[idx] = filter.get(idx);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChainTupleFilterKey key = (ChainTupleFilterKey)o;
            return Arrays.equals(this.identities, key.identities);
        }

        public int hashCode() {
            return Arrays.hashCode(this.identities);
        }
    }
}

