/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.result.store;

import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import org.jetbrains.annotations.Nullable;

public abstract class OlapResultStoreReference {
    @Nullable
    private final OlapResultStoreInformation info;
    private OlapResultStoreReferenceKey resultKey;
    private int decompressedSize;
    private int size;
    private int[] chunks;

    public OlapResultStoreReference(@Nullable OlapResultStoreInformation info, OlapResultStoreReferenceKey resultKey, int decompressedSize, int size, int[] chunks) {
        this.info = info;
        this.resultKey = resultKey;
        this.decompressedSize = decompressedSize;
        this.size = size;
        this.chunks = chunks;
    }

    @Nullable
    public OlapResultStoreInformation getInfo() {
        return this.info;
    }

    public OlapResultStoreReferenceKey getResultKey() {
        return this.resultKey;
    }

    public abstract long sizeOf();

    public int getDecompressedSize() {
        return this.decompressedSize;
    }

    public int getSize() {
        return this.size;
    }

    public int[] getChunks() {
        return this.chunks;
    }

    public void recordRemoval() {
        this.size = -1;
        this.decompressedSize = -1;
        this.chunks = null;
        this.resultKey = null;
    }

    public boolean removed() {
        return this.chunks == null;
    }
}

