/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.result.store;

import crazydev.common.collection.CdStrPair;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.tests.CdTestUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapResultStoreInformation {
    private static long SHALLOW_SIZE_OF = -1L;
    public final String locale;
    public final String roleName;
    public final String schemaName;
    public final String schemaId;
    public final long schemaRefreshTimestamp;
    public final String schemaRefreshTime;
    public final String schemaPermsId;
    public final String mdxHash;
    public final long requestExecTimestamp;
    public final long requestId;
    public final String requestExecTime;
    private final long sizeOf;

    public OlapResultStoreInformation(String locale, String roleName, String schemaName, String schemaId, Date schemaRefreshTime, String schemaPermsId, String mdxHash, long requestId) {
        this.locale = locale;
        this.roleName = roleName;
        this.schemaName = schemaName;
        this.schemaId = schemaId;
        this.schemaRefreshTimestamp = schemaRefreshTime.getTime();
        this.schemaRefreshTime = CdTimeUtils.formatServerTimeForRequest((Date)schemaRefreshTime);
        this.schemaPermsId = schemaPermsId;
        this.mdxHash = mdxHash;
        this.requestId = requestId;
        Date now = new Date();
        this.requestExecTimestamp = now.getTime();
        this.requestExecTime = CdTimeUtils.formatServerTimeForRequest((Date)now);
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += CdRamUsageEstimator.sizeOf((String)this.locale);
        size += CdRamUsageEstimator.sizeOf((String)this.roleName);
        size += CdRamUsageEstimator.sizeOf((String)this.schemaName);
        size += CdRamUsageEstimator.sizeOf((String)this.schemaId);
        size += CdRamUsageEstimator.sizeOf((String)this.schemaRefreshTime);
        size += CdRamUsageEstimator.sizeOf((String)this.schemaPermsId);
        size += CdRamUsageEstimator.sizeOf((String)this.mdxHash);
        this.sizeOf = size += CdRamUsageEstimator.sizeOf((String)this.requestExecTime);
    }

    public long sizeOf() {
        return this.sizeOf;
    }

    public String schemaInfo() {
        return this.schemaName + "(" + this.schemaId + ")";
    }

    public String schemaRefresh() {
        return this.schemaRefreshTime + "(" + this.requestExecTimestamp + ")";
    }

    public void log(Logger logger, String prefix, Object result) {
        logger.info((Object)(prefix + " ------------------------------------------------------------------------------------ "));
        logger.info((Object)(prefix + "              locale: " + this.locale));
        logger.info((Object)(prefix + "           role name: " + this.roleName));
        logger.info((Object)(prefix + "         schema name: " + this.schemaInfo()));
        logger.info((Object)(prefix + " schema refresh time: " + this.schemaRefreshTime + " (" + this.schemaRefreshTimestamp + ")"));
        logger.info((Object)(prefix + "        schema perms: " + this.schemaPermsId));
        logger.info((Object)(prefix + "            mdx hash: " + this.mdxHash));
        String extraInfo = "";
        if (result instanceof OlapResStatementDataSet) {
            OlapResStatementDataSet res = (OlapResStatementDataSet)result;
            extraInfo = res.logInfo();
        }
        OlapLoggers.MDX_EVALUATION_INFO.debug((Object)("MDX request:" + this.requestId + " locale:" + this.locale + " role:" + this.roleName + " schema:" + this.schemaName + " schemaId:" + this.schemaId + " schemaRefreshTime:" + this.schemaRefreshTime + " schemaPerms:" + this.schemaPermsId + " mdxHash:" + this.mdxHash + extraInfo));
    }

    public void log(Logger logger, String prefix, @Nullable OlapResultStoreInformation current) {
        if (current == null) {
            return;
        }
        logger.info((Object)(prefix + " ------------------------------------------------------------------------------------ "));
        logger.info((Object)(prefix + "              locale: " + this.locale + " vs " + current.locale));
        logger.info((Object)(prefix + "           role name: " + this.roleName + " vs " + current.roleName));
        logger.info((Object)(prefix + "         schema name: " + this.schemaInfo() + " vs " + current.schemaInfo()));
        logger.info((Object)(prefix + " schema refresh time: " + this.schemaRefresh() + " vs " + current.schemaRefresh()));
        logger.info((Object)(prefix + "        schema perms: " + this.schemaPermsId + " vs " + current.schemaPermsId));
        logger.info((Object)(prefix + "            mdx hash: " + this.mdxHash + " vs " + current.mdxHash));
    }

    public void assertConsistency(Logger logger, String prefix, @Nullable OlapResultStoreInformation current) {
        if (current == null) {
            return;
        }
        if (!this.locale.equals(current.locale)) {
            this.assertOnError(logger, prefix, "locale", this.locale, current.locale);
        } else if (!this.roleName.equals(current.roleName)) {
            this.assertOnError(logger, prefix, "roleName", this.roleName, current.roleName);
        } else if (!this.schemaName.equals(current.schemaName)) {
            this.assertOnError(logger, prefix, "schemaName", this.schemaName, current.schemaName);
        } else if (!this.schemaId.equals(current.schemaId)) {
            this.assertOnError(logger, prefix, "schemaId", this.schemaId, current.schemaId);
        } else if (this.schemaRefreshTimestamp != current.schemaRefreshTimestamp) {
            this.assertOnError(logger, prefix, "schemaRefreshTimestamp", this.schemaRefreshTimestamp, current.schemaRefreshTimestamp);
        } else if (!this.schemaPermsId.equals(current.schemaPermsId)) {
            this.assertOnError(logger, prefix, "schemaPermsId", this.schemaPermsId, current.schemaPermsId);
        } else if (!this.mdxHash.equals(current.mdxHash)) {
            this.assertOnError(logger, prefix, "mdxHash", this.mdxHash, current.mdxHash);
        }
    }

    private void assertOnError(Logger logger, String prefix, String field, Object actual, Object expected) {
        String message = prefix + " cache consistency error for [" + field + "] [actual:" + String.valueOf(actual) + "] [expected:" + String.valueOf(expected) + "]";
        logger.error((Object)message);
        if (CdTestUtils.MDX_RESULT_CACHE_ASSERT_CONSISTENCY_ON_ERROR) {
            throw new RuntimeException(message);
        }
    }

    public List<CdStrPair> createQueryProperties(@Nullable List<CdStrPair> properties) {
        if (properties == null) {
            properties = new ArrayList<CdStrPair>();
        }
        properties.add(new CdStrPair("cache_requestId", String.valueOf(this.requestId)));
        properties.add(new CdStrPair("cache_requestExecTimestamp", String.valueOf(this.requestExecTimestamp)));
        properties.add(new CdStrPair("cache_requestExecTime", this.requestExecTime));
        properties.add(new CdStrPair("cache_locale", this.locale));
        properties.add(new CdStrPair("cache_roleName", this.roleName));
        properties.add(new CdStrPair("cache_schemaName", this.schemaName));
        properties.add(new CdStrPair("cache_schemaId", this.schemaId));
        properties.add(new CdStrPair("cache_schemaRefreshTimestamp", String.valueOf(this.schemaRefreshTimestamp)));
        properties.add(new CdStrPair("cache_schemaRefreshTime", this.schemaRefreshTime));
        properties.add(new CdStrPair("cache_schemaPerms", this.schemaPermsId));
        properties.add(new CdStrPair("cache_mdxHash", this.mdxHash));
        return properties;
    }

    public void setResponseHeaders(HttpServletResponse response) {
        response.setHeader("ic3-exec-from-cache", "true");
        response.setHeader("ic3-exec-locale", this.locale);
        response.setHeader("ic3-exec-roleName", this.roleName);
        response.setHeader("ic3-exec-schemaName", this.schemaName);
        response.setHeader("ic3-exec-schemaId", this.schemaId);
        response.setHeader("ic3-exec-schemaRefreshTime", this.schemaRefreshTime);
        response.setHeader("ic3-exec-schemaPerms", this.schemaPermsId);
        response.setHeader("ic3-exec-mdxHash", this.mdxHash);
    }
}

