/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.result.store;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.olap.eval.cache.result.lz4.OlapLZ4Helper;
import crazydev.iccube.olap.eval.cache.result.lz4.OlapLZ4Result;
import crazydev.iccube.olap.eval.cache.result.store.IOlapResultStoreEvictionPolicy;
import crazydev.iccube.olap.eval.cache.result.store.IOlapResultStoreListener;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultDefaultStoreEvictionPolicy;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreDeSerializer;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReference;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreSerializer;
import crazydev.iccube.olap.facts.column.list.IOlapFactByteList;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;

public abstract class OlapResultStore {
    public static final int DEFAULT_BUFFER_BITS = 20;
    public static final int DEFAULT_CHUNK_BITS = 10;
    @Nullable
    private final IOlapResultStoreListener listener;
    private final boolean compressionEnabled;
    private final int maxCompressedSize;
    private final IOlapFactByteList store;
    private final int chunkBits;
    private final int chunkSize;
    private final int totalAvailableChunkCount;
    private final LinkedList<Integer> availableChunks;
    private final IOlapResultStoreEvictionPolicy evictionPolicy;
    private long totalActualCompressedSize;
    private long totalActualDeCompressedSize;
    private long indexSizeOf;
    private int itemCount;
    private int evictedItemCount;

    protected OlapResultStore(@Nullable IOlapResultStoreListener listener, CdVFileSystem vfs, @Nullable File tmpDirectory, boolean compressionEnabled, int bufferCount, int bufferBits, int chunkBits) {
        this.listener = listener;
        this.compressionEnabled = compressionEnabled;
        this.store = this.createList(vfs, tmpDirectory, bufferBits);
        this.store.createZeroBuffers(bufferCount);
        this.evictionPolicy = new OlapResultDefaultStoreEvictionPolicy();
        this.chunkBits = chunkBits;
        this.chunkSize = 1 << chunkBits;
        this.availableChunks = new LinkedList();
        int size = this.store.size();
        for (int offset = 0; offset < size; offset += this.chunkSize) {
            this.availableChunks.add(offset);
        }
        this.totalAvailableChunkCount = this.availableChunks.size();
        this.itemCount = 0;
        this.evictedItemCount = 0;
        this.maxCompressedSize = size;
        this.totalActualCompressedSize = 0L;
        this.totalActualDeCompressedSize = 0L;
        this.indexSizeOf = 0L;
    }

    public boolean isMemory() {
        return false;
    }

    public boolean isMmap() {
        return false;
    }

    protected abstract IOlapFactByteList createList(CdVFileSystem var1, @Nullable File var2, int var3);

    @Nullable
    public OlapResultStoreReference addResult(OlapResultStoreReferenceKey resultKey, OlapResultStoreSerializer resultSerializer) {
        OlapLZ4Result lz4Result;
        if (resultSerializer.isLZ4()) {
            try {
                lz4Result = OlapLZ4Helper.compress(this.compressionEnabled, this.maxCompressedSize, resultSerializer);
            }
            catch (IOException ex) {
                OlapLoggers.MDX_EVALUATION_RESULT_CACHE.warn((Object)("[result-cache] MDX " + this.requestId(resultSerializer) + "could not compress result"), (Throwable)ex);
                return null;
            }
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            resultSerializer.write(out);
            byte[] bytes = out.toByteArray();
            lz4Result = new OlapLZ4Result(bytes.length, bytes.length, bytes);
        }
        catch (IOException ex) {
            OlapLoggers.MDX_EVALUATION_RESULT_CACHE.warn((Object)("[result-cache] MDX " + this.requestId(resultSerializer) + "could not store (uncompressed) result"), (Throwable)ex);
            return null;
        }
        if (lz4Result == null || lz4Result.getCompressedLength() > this.store.size()) {
            return null;
        }
        byte[] compressedResultBuffer = lz4Result.getCompressedBuffer();
        int compressedResultBufferLength = lz4Result.getCompressedLength();
        int requiredChunkCount = 1 + (compressedResultBufferLength - 1) / this.chunkSize;
        int availableChunkCount = this.availableChunks.size();
        while (availableChunkCount < requiredChunkCount) {
            if (this.evictionPolicy.isEmpty()) {
                throw new CdProgrammingException("internal error: could not allocate space (1)");
            }
            OlapResultStoreReference reference = this.evictionPolicy.getReferenceToDelete();
            if (reference == null) {
                throw new CdProgrammingException("internal error: could not allocate space (2)");
            }
            this.deleteResult(reference);
            ++this.evictedItemCount;
            if (this.availableChunks.size() <= availableChunkCount) {
                throw new CdProgrammingException("internal error: could not allocate space (3)");
            }
            availableChunkCount = this.availableChunks.size();
        }
        int[] chunks = new int[requiredChunkCount];
        for (int ii = 0; ii < chunks.length; ++ii) {
            chunks[ii] = this.availableChunks.pop();
        }
        int resultPos = 0;
        for (int ii = 0; ii < chunks.length; ++ii) {
            int len = ii == chunks.length - 1 ? compressedResultBufferLength - resultPos : this.chunkSize;
            this.store.setQuick(chunks[ii], compressedResultBuffer, resultPos, len);
            resultPos += this.chunkSize;
        }
        OlapResultStoreReference reference = this.evictionPolicy.createAndAddReference(resultSerializer.getInfo(), resultKey, lz4Result.getDecompressedLength(), compressedResultBufferLength, chunks);
        ++this.itemCount;
        this.totalActualCompressedSize += (long)lz4Result.getCompressedLength();
        this.totalActualDeCompressedSize += (long)lz4Result.getDecompressedLength();
        this.indexSizeOf += reference.sizeOf();
        OlapLoggers.MDX_EVALUATION_RESULT_CACHE.debug((Object)("[result-cache] MDX " + this.requestId(resultSerializer) + "result stored into cache [chunks:" + chunks.length + "]"));
        return reference;
    }

    private String requestId(OlapResultStoreSerializer resultSerializer) {
        String id = resultSerializer.getRequestId();
        if (id != null) {
            return id + " ";
        }
        return "";
    }

    public void recordReferenceAccess(OlapResultStoreReference reference) {
        if (reference.removed()) {
            return;
        }
        this.evictionPolicy.recordReferenceAccess(reference);
    }

    @Nullable
    public OlapResultStoreDeSerializer getResult(OlapResultStoreReference reference) {
        if (reference.removed()) {
            return null;
        }
        this.evictionPolicy.recordReferenceAccess(reference);
        byte[] compressedResult = new byte[reference.getSize()];
        int[] chunks = reference.getChunks();
        int resultPos = 0;
        for (int ii = 0; ii < chunks.length; ++ii) {
            int len = ii == chunks.length - 1 ? compressedResult.length - resultPos : this.chunkSize;
            this.store.getQuick(compressedResult, resultPos, chunks[ii], len);
            resultPos += this.chunkSize;
        }
        return new OlapResultStoreDeSerializer(this.compressionEnabled, reference.getDecompressedSize(), compressedResult, reference.getInfo());
    }

    public boolean deleteResult(OlapResultStoreReference reference) {
        return this.deleteResult(reference, true);
    }

    public boolean deleteResult(OlapResultStoreReference reference, boolean fireEvent) {
        if (reference.removed()) {
            return false;
        }
        int[] chunks = reference.getChunks();
        for (int ii = 0; ii < chunks.length; ++ii) {
            this.availableChunks.push(chunks[ii]);
        }
        this.evictionPolicy.recordReferenceRemoval(reference);
        reference.recordRemoval();
        if (fireEvent && this.listener != null) {
            this.listener.onReferenceRemoved(reference);
        }
        --this.itemCount;
        this.totalActualCompressedSize -= (long)reference.getSize();
        this.totalActualDeCompressedSize -= (long)reference.getDecompressedSize();
        this.indexSizeOf -= reference.sizeOf();
        return true;
    }

    public long indexSizeOf() {
        return this.indexSizeOf;
    }

    public long sizeOf() {
        return this.store.sizeOf();
    }

    public long sizeOfFiles() {
        return this.store.sizeOfFiles();
    }

    public double getFillPercent() {
        return (double)(this.totalAvailableChunkCount - this.availableChunks.size()) / (double)this.totalAvailableChunkCount * 100.0;
    }

    public double getCompressionRatio() {
        if (this.totalActualDeCompressedSize == 0L) {
            return 1.0;
        }
        return 1.0 * (double)this.totalActualCompressedSize / (double)this.totalActualDeCompressedSize;
    }

    public int getAvailableChunkCount() {
        return this.availableChunks.size();
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public int getEvictedItemCount() {
        return this.evictedItemCount;
    }
}

