/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.result.store;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemTmpReason;
import crazydev.iccube.olap.eval.cache.result.store.IOlapResultStoreListener;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStore;
import crazydev.iccube.olap.facts.column.columns.OlapFactMeasureColumnId;
import crazydev.iccube.olap.facts.column.list.IOlapFactByteList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactByteMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactMemMapListConfiguration;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class OlapResultMmapStore
extends OlapResultStore {
    public OlapResultMmapStore(@Nullable IOlapResultStoreListener listener, CdVFileSystem vfs, File tmpDirectory, boolean compressionEnabled, int bufferCount) {
        this(listener, vfs, tmpDirectory, compressionEnabled, bufferCount, 20, 10);
    }

    public OlapResultMmapStore(@Nullable IOlapResultStoreListener listener, CdVFileSystem vfs, File tmpDirectory, boolean compressionEnabled, int bufferCount, int bufferBits, int chunkBits) {
        super(listener, vfs, tmpDirectory, compressionEnabled, bufferCount, bufferBits, chunkBits);
    }

    @Override
    public boolean isMmap() {
        return true;
    }

    @Override
    protected IOlapFactByteList createList(CdVFileSystem vfs, @Nullable File tmpDirectory, int bufferBits) {
        OlapFactMemMapListConfiguration configuration = this.setupListConfiguration(vfs, tmpDirectory, bufferBits);
        return OlapFactByteMemMapList.create(configuration);
    }

    private OlapFactMemMapListConfiguration setupListConfiguration(CdVFileSystem vfs, @Nullable File tmpDirectory, int bufferBits) {
        if (tmpDirectory == null) {
            throw new CdProgrammingException("internal error: missing directory");
        }
        OlapFactMeasureColumnId columnId = new OlapFactMeasureColumnId("result-cache-cube", "result-cache-measure-group", "result-cache-measure");
        try {
            File resultCacheDir = vfs.createTmpDirectory(CdVFileSystemTmpReason.RESULT_CACHE, tmpDirectory);
            return new OlapFactMemMapListConfiguration(vfs, columnId, resultCacheDir, "result-cache", false, -1, bufferBits);
        }
        catch (IOException ex) {
            throw new RuntimeException("could not create the result cache file", ex);
        }
    }
}

