/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.result.lz4;

import java.io.IOException;
import java.io.OutputStream;

public class OlapLZ4MemoryDecompressedOutputStream
extends OutputStream {
    private final byte[] buffer;
    private int count;

    public OlapLZ4MemoryDecompressedOutputStream(int size) {
        this.buffer = new byte[size];
    }

    public byte[] getBuffer() {
        if (this.buffer.length != this.count) {
            throw new RuntimeException("internal error : inconsistent byte array usage");
        }
        return this.buffer;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        System.arraycopy(b, off, this.buffer, this.count, len);
        this.count += len;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

