/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.result.lz4;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class OlapLZ4CompressedOutputStream
extends OutputStream {
    private final int maxSize;
    private boolean maxSizeReached;
    private byte[] buffer;
    private int count;

    public OlapLZ4CompressedOutputStream(int maxSize) {
        this.maxSize = maxSize;
        this.buffer = new byte[4096];
        this.count = 0;
    }

    public boolean isMaxSizeReached() {
        return this.maxSizeReached;
    }

    public int size() {
        return this.count;
    }

    public byte[] buffer() {
        return this.buffer;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.shouldContinue(1)) {
            this.ensureCapacity(this.count + 1);
            this.buffer[this.count] = (byte)b;
            ++this.count;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.shouldContinue(len)) {
            this.ensureCapacity(this.count + len);
            System.arraycopy(b, off, this.buffer, this.count, len);
            this.count += len;
        }
    }

    private boolean shouldContinue(int len) {
        if (this.maxSizeReached) {
            return false;
        }
        if (this.count + len > this.maxSize) {
            this.maxSizeReached = true;
            return false;
        }
        return true;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buffer.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buffer.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity < 0) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

