/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.result.cache;

import crazydev.common.utils.CdSizeUtils;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class OlapResultCacheStats {
    private final boolean invalidated;
    private final int schemaCount;
    private final int keyCount;
    private final String mode;
    private final String cachingPolicy;
    private final boolean isMemory;
    private final boolean isMmap;
    private final boolean cachingGVI;
    private final boolean cachingXMLA;
    private final boolean cachingREST;
    private final boolean cachingAlerts;
    private final long indexRamSize;
    private final long storeRamSize;
    private final long storeFileSize;
    private final double storeFillPercent;
    private final double storeCompressionRatio;
    private final int storeItemCount;
    private final int storeEvictedItemCount;
    private final int addTotal;
    private final int accessTotal;
    private final int hitTotal;
    private final int missTotal;
    private final int keyCollisions;

    public OlapResultCacheStats(boolean invalidated, int schemaCount, int keyCount, String mode, boolean isMemory, boolean isMmap, boolean cachingGVI, boolean cachingXMLA, boolean cachingREST, boolean cachingAlerts, String cachingPolicy, long indexRamSize, long storeRamSize, long storeFileSize, double storeFillPercent, double storeCompressionRatio, int storeItemCount, int storeEvictedItemCount, int addTotal, int accessTotal, int hitTotal, int missTotal, int keyCollisions) {
        this.invalidated = invalidated;
        this.schemaCount = schemaCount;
        this.keyCount = keyCount;
        this.mode = mode;
        this.isMemory = isMemory;
        this.isMmap = isMmap;
        this.cachingGVI = cachingGVI;
        this.cachingXMLA = cachingXMLA;
        this.cachingREST = cachingREST;
        this.cachingAlerts = cachingAlerts;
        this.cachingPolicy = cachingPolicy;
        this.indexRamSize = indexRamSize;
        this.storeRamSize = storeRamSize;
        this.storeFileSize = storeFileSize;
        this.storeFillPercent = storeFillPercent;
        this.storeCompressionRatio = storeCompressionRatio;
        this.storeItemCount = storeItemCount;
        this.storeEvictedItemCount = storeEvictedItemCount;
        this.addTotal = addTotal;
        this.accessTotal = accessTotal;
        this.hitTotal = hitTotal;
        this.missTotal = missTotal;
        this.keyCollisions = keyCollisions;
    }

    public Map<String, String> getStats(Locale locale) {
        LinkedHashMap<String, String> stats = new LinkedHashMap<String, String>();
        if (this.invalidated) {
            stats.put("Invalidated", "yes");
        } else {
            stats.put("Mode", this.mode);
            stats.put("Caching GVI", String.valueOf(this.cachingGVI));
            stats.put("Caching XMLA", String.valueOf(this.cachingXMLA));
            stats.put("Caching REST API", String.valueOf(this.cachingREST));
            stats.put("Caching Alerts", String.valueOf(this.cachingAlerts));
            stats.put("Caching Policy", this.cachingPolicy);
            if (this.isMemory) {
                stats.put("RAM Size", CdSizeUtils.format((Locale)locale, (double)this.storeRamSize));
            }
            if (this.isMmap) {
                stats.put("File Size", CdSizeUtils.format((Locale)locale, (double)this.storeFileSize));
            }
            stats.put("Fill", String.format(locale, "%.2f%%", this.storeFillPercent));
            stats.put("Compression Rate", String.format(locale, "%.2f", this.storeCompressionRatio));
            stats.put("Results", String.format(locale, "%,d ( total : %,d)", this.storeItemCount, this.addTotal));
            stats.put("Evicted Rate", String.format(locale, "%.2f%% ( evicted : %,d )", 100.0 * ((double)this.storeEvictedItemCount / (double)(this.addTotal == 0 ? 1 : this.addTotal)), this.storeEvictedItemCount));
            stats.put("Hit Rate", String.format(locale, "%.2f%% ( hit : %,d )", 100.0 * ((double)this.hitTotal / (double)(this.accessTotal == 0 ? 1 : this.accessTotal)), this.hitTotal));
            stats.put("Miss Rate", String.format(locale, "%.2f%% ( miss : %,d )", 100.0 * ((double)this.missTotal / (double)(this.accessTotal == 0 ? 1 : this.accessTotal)), this.missTotal));
            stats.put("Index RAM Size", CdSizeUtils.format((Locale)locale, (double)this.indexRamSize));
            stats.put("Key Collisions", String.format(locale, "%,d", this.keyCollisions));
        }
        return stats;
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public int getSchemaCount() {
        return this.schemaCount;
    }

    public int getKeyCount() {
        return this.keyCount;
    }

    public String getMode() {
        return this.mode;
    }

    public String getCachingPolicy() {
        return this.cachingPolicy;
    }

    public long getStoreRamSize() {
        return this.storeRamSize;
    }

    public double getStoreFillPercent() {
        return this.storeFillPercent;
    }

    public int getStoreItemCount() {
        return this.storeItemCount;
    }

    public int getStoreEvictedItemCount() {
        return this.storeEvictedItemCount;
    }

    public int getAddTotal() {
        return this.addTotal;
    }

    public int getAccessTotal() {
        return this.accessTotal;
    }

    public int getHitTotal() {
        return this.hitTotal;
    }

    public int getMissTotal() {
        return this.missTotal;
    }
}

