/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.evaluator;

import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFStaticTupleEvaluator;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class OlapSchemaTupleEvaluators {
    private final Map<IOlapSchemaPermission, GFStaticTupleEvaluator> evaluators = new ConcurrentHashMap<IOlapSchemaPermission, GFStaticTupleEvaluator>();

    public GFStaticTupleEvaluator getOrCreateStaticTupleEvaluator(IOlapSchemaPermission permissions) {
        GFStaticTupleEvaluator evaluator = this.evaluators.computeIfAbsent(permissions, p -> new GFStaticTupleEvaluator());
        return evaluator;
    }

    public void onSchemaIncrLoaded(OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        this.onSchemaUpdated();
    }

    public void onSchemaIncrLoadedOnError(OlapSchema schema) {
        this.onSchemaUpdated();
    }

    public void onSchemaScriptStatementApplied(OlapSchema schema, OlapScriptInformation information) {
        this.onSchemaUpdated();
    }

    public void onSchemaUnloaded(OlapSchema schema) {
        this.onSchemaUpdated();
        this.evaluators.clear();
    }

    public void onSchemaPartitionsUnloaded(OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        this.onSchemaUpdated();
    }

    public void onSchemaPartitionsLoaded(OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        this.onSchemaUpdated();
    }

    public void onSchemaPartitionsLoadError(OlapSchema schema) {
        this.onSchemaUpdated();
    }

    public void onSchemaSecurityAllPermissionsRemoved(OlapSchema schema) {
        this.onSchemaUpdated();
        this.evaluators.clear();
    }

    public void onSchemaSecurityPermissionsSwitched(OlapSchema schema, String roleName, IOlapSchemaPermission newPerms, @Nullable IOlapSchemaPermission prevPerms) {
        this.onSchemaUpdated();
        if (prevPerms != null) {
            this.evaluators.remove(prevPerms);
        }
    }

    private void onSchemaUpdated() {
        for (GFStaticTupleEvaluator evaluator : this.evaluators.values()) {
            evaluator.onSchemaUpdated();
        }
    }
}

