/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache;

import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.shared.perms.S_FactPermsDef;
import crazydev.iccube.configuration.component.OlapEngineComponentConfiguration;
import crazydev.iccube.configuration.component.OlapEngineResultCacheConfiguration;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.schemas.IOlapEngineSchemaLifeCycleListener;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.cache.IOlapCacheEventHandler;
import crazydev.iccube.olap.eval.cache.IOlapSessionCacheManager;
import crazydev.iccube.olap.eval.cache.OlapCacheManagerStats;
import crazydev.iccube.olap.eval.cache.OlapSchemaCache;
import crazydev.iccube.olap.eval.cache.evaluator.OlapSchemaTupleEvaluators;
import crazydev.iccube.olap.eval.cache.result.cache.IOlapResultCachePolicy;
import crazydev.iccube.olap.eval.cache.result.cache.OlapGlobalResultCache;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCache;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheKey;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheMode;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheStats;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFStaticTupleEvaluator;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluation;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.goodies.perspective.permissions.OlapPerspectiveSchemaPermission;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import crazydev.iccube.pub.common.IOlapProtocol;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class OlapCacheManager
implements IOlapCacheEventHandler {
    private final OlapFileCleaner cleaner;
    @Nullable
    private final OlapGlobalResultCache globalResultCache;
    @Nullable
    private final Map<OlapResultCacheKey, OlapResultCache> allResultCaches;
    private final Map<OlapSchema, OlapSchemaTupleEvaluators> allSchemaTupleEvaluators;
    private final Map<OlapSchema, OlapSchemaCache> allSchemaCaches;
    private final List<IOlapSessionCacheManager> sessions = new ArrayList<IOlapSessionCacheManager>();
    private final Map<String, IOlapSessionCacheManager> sessionsByUUID = new HashMap<String, IOlapSessionCacheManager>();
    private final OlapEngineComponentConfiguration configuration;
    @Nullable
    private M_LocalCluster cluster;

    public OlapCacheManager(OlapEngineComponent engine) {
        this.cleaner = engine.getCleaner();
        this.configuration = engine.getConfiguration();
        OlapLixContent lc = engine.getLixContent();
        OlapEngineResultCacheConfiguration resultCacheConfiguration = this.configuration.getResultCacheConfiguration();
        if (resultCacheConfiguration != null) {
            OlapResultCacheMode resultCacheMode = resultCacheConfiguration.getMode();
            if (lc.isResultCacheAvailable() && resultCacheMode != OlapResultCacheMode.OFF) {
                int resultCacheSize = resultCacheConfiguration.getSize();
                File tmpDirectory = resultCacheMode == OlapResultCacheMode.FILE ? engine.getTmpDirectory() : null;
                IOlapResultCachePolicy resultCachePolicy = resultCacheConfiguration.getCachingPolicy();
                this.globalResultCache = new OlapGlobalResultCache(engine.getVfs(), tmpDirectory, true, resultCacheSize, resultCachePolicy, resultCacheConfiguration.isGvi(), resultCacheConfiguration.isXmla(), resultCacheConfiguration.isRestApi(), resultCacheConfiguration.isAlerts());
                this.allResultCaches = new HashMap<OlapResultCacheKey, OlapResultCache>();
            } else {
                this.globalResultCache = null;
                this.allResultCaches = null;
            }
        } else {
            this.globalResultCache = null;
            this.allResultCaches = null;
        }
        this.allSchemaTupleEvaluators = new HashMap<OlapSchema, OlapSchemaTupleEvaluators>();
        this.allSchemaCaches = new HashMap<OlapSchema, OlapSchemaCache>();
        engine.addStructuralSchemaLifeCycleListener(new IOlapEngineSchemaLifeCycleListener(this){
            final /* synthetic */ OlapCacheManager this$0;
            {
                OlapCacheManager olapCacheManager = this$0;
                Objects.requireNonNull(olapCacheManager);
                this.this$0 = olapCacheManager;
            }

            @Override
            public void onSchemaStartedPhaseI(OlapEngineRequestContext context, OlapSchema schema, String command) {
                this.this$0.onSchemaStartedPhaseI(context, schema, command);
            }

            @Override
            public void onSchemaStartedPhaseII(OlapEngineRequestContext context, OlapSchema schema, String command) {
                this.this$0.onSchemaStartedPhaseII(context, schema, command);
            }

            @Override
            public void onSchemaLoadedDone(OlapEngineRequestContext context, OlapSchema schema) {
                this.this$0.onSchemaLoadedDone(context, schema);
            }

            @Override
            public void onSchemaLoaded(OlapEngineRequestContext context, OlapSchema schema) {
                this.this$0.onSchemaLoaded(context, schema);
            }

            @Override
            public void onSchemaLoadedOnError(OlapEngineRequestContext context, OlapSchema schema) {
                this.this$0.onSchemaLoadedOnError(context, schema);
            }

            @Override
            public void onSchemaLoadedOnErrorCleanup(OlapEngineRequestContext context, OlapSchema schema) {
                this.this$0.onSchemaLoadedOnErrorCleanup(context, schema);
            }

            @Override
            public void onSchemaIncrLoaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
                this.this$0.onSchemaIncrLoaded(context, schema, incrLoadInfo);
            }

            @Override
            public void onSchemaIncrLoadedOnError(OlapEngineRequestContext context, OlapSchema schema) {
                this.this$0.onSchemaIncrLoadedOnError(context, schema);
            }

            @Override
            public void onSchemaScriptStatementApplied(OlapEngineRequestContext context, OlapSchema schema, OlapScriptInformation information) {
                this.this$0.onSchemaScriptStatementApplied(context, schema, information);
            }

            @Override
            public void onSchemaUnloaded(OlapEngineRequestContext context, OlapSchema schema) {
                this.this$0.onSchemaUnloaded(context, schema);
            }

            @Override
            public void onSchemaPartitionsUnloaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
                this.this$0.onSchemaPartitionsUnloaded(context, schema, unloadPartitionsInfo);
            }

            @Override
            public void onSchemaPartitionsLoaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
                this.this$0.onSchemaPartitionsLoaded(context, schema, loadPartitionsInfo);
            }

            @Override
            public void onSchemaPartitionsLoadError(OlapEngineRequestContext context, OlapSchema schema) {
                this.this$0.onSchemaPartitionsLoadError(context, schema);
            }
        });
    }

    public void attachCluster(M_LocalCluster cluster) {
        this.cluster = cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapCacheManagerStats getStats() {
        int schemaCount = 0;
        int keyCount = 0;
        OlapResultCacheStats resultCacheStats = null;
        if (this.allResultCaches != null) {
            Map<OlapResultCacheKey, OlapResultCache> map = this.allResultCaches;
            synchronized (map) {
                HashSet<OlapSchema> schemas = new HashSet<OlapSchema>();
                for (OlapResultCacheKey olapResultCacheKey : this.allResultCaches.keySet()) {
                    schemas.add(olapResultCacheKey.getSchema());
                }
                schemaCount = schemas.size();
                keyCount = this.allResultCaches.size();
                if (this.globalResultCache != null) {
                    resultCacheStats = this.globalResultCache.getStats();
                }
            }
        }
        return new OlapCacheManagerStats(schemaCount, keyCount, resultCacheStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionCount() {
        List<IOlapSessionCacheManager> list = this.sessions;
        synchronized (list) {
            return this.sessions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IOlapSessionCacheManager> getAllSessions(String uuid) {
        ArrayList<IOlapSessionCacheManager> allSessions = new ArrayList<IOlapSessionCacheManager>();
        List<IOlapSessionCacheManager> list = this.sessions;
        synchronized (list) {
            for (IOlapSessionCacheManager value : this.sessionsByUUID.values()) {
                if (value.getUUID().equals(uuid)) continue;
                allSessions.add(value);
            }
        }
        return allSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IOlapSessionCacheManager getSession(String uuid) {
        List<IOlapSessionCacheManager> list = this.sessions;
        synchronized (list) {
            return this.sessionsByUUID.get(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachSession(Consumer<IOlapSessionCacheManager> consumer) {
        List<IOlapSessionCacheManager> list = this.sessions;
        synchronized (list) {
            for (IOlapSessionCacheManager session : this.sessions) {
                consumer.accept(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSession(IOlapSessionCacheManager session) {
        List<IOlapSessionCacheManager> list = this.sessions;
        synchronized (list) {
            this.sessions.add(session);
            this.sessionsByUUID.put(session.getUUID(), session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSession(IOlapSessionCacheManager session) {
        List<IOlapSessionCacheManager> list = this.sessions;
        synchronized (list) {
            this.sessions.remove(session);
            this.sessionsByUUID.remove(session.getUUID());
        }
        session.onDestroyed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapSchemaCache getOrCreateSchemaCache(OlapSchema schema) {
        Map<OlapSchema, OlapSchemaCache> map = this.allSchemaCaches;
        synchronized (map) {
            OlapSchemaCache cache = this.allSchemaCaches.get(schema);
            if (cache == null) {
                cache = new OlapSchemaCache(schema);
                this.allSchemaCaches.put(schema, cache);
            }
            return cache;
        }
    }

    public boolean isResultCacheEnabled(IOlapProtocol protocol) {
        if (this.globalResultCache == null || this.allResultCaches == null) {
            return false;
        }
        return this.globalResultCache.isEnabled(protocol);
    }

    public boolean isResultCacheEnabledForAlerts() {
        if (this.globalResultCache == null || this.allResultCaches == null) {
            return false;
        }
        return this.globalResultCache.isEnabledForAlerts();
    }

    @Nullable
    public OlapResultCache getOrCreateResultCache(OlapEngineRequestContext context, IOlapProtocol protocol, OlapResultCacheKey key) {
        if (!this.isResultCacheEnabled(protocol)) {
            return null;
        }
        OlapResultCache cache = this.getOrCreateResultCache(context, key);
        return cache;
    }

    @Nullable
    public OlapResultCache getOrCreateResultCacheForAlerts(OlapEngineRequestContext context, OlapResultCacheKey key) {
        if (!this.isResultCacheEnabledForAlerts()) {
            return null;
        }
        OlapResultCache cache = this.getOrCreateResultCache(context, key);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private OlapResultCache getOrCreateResultCache(OlapEngineRequestContext context, OlapResultCacheKey key) {
        if (this.allResultCaches == null) {
            return null;
        }
        OlapSchema schema = key.getSchema();
        if (!context.canUseResultCache(schema)) {
            return null;
        }
        Map<OlapResultCacheKey, OlapResultCache> map = this.allResultCaches;
        synchronized (map) {
            if (this.globalResultCache == null) {
                return null;
            }
            if (!this.globalResultCache.isKeyActive(key)) {
                return null;
            }
            OlapResultCache resultCache = this.allResultCaches.get(key);
            if (resultCache == null) {
                resultCache = new OlapResultCache(key, this.globalResultCache);
                this.allResultCaches.put(key, resultCache);
            }
            return resultCache;
        }
    }

    public void clearResultCache(OlapEngineRequestContext context) {
        this.clearAllSchemaResultCaches(context);
    }

    @Nullable
    public OlapSetEvaluation getEvaluatedStaticSetDeclaration(OlapEvaluationContext context, OlapSetDeclaration setDeclaration) {
        OlapSchema schema = context.getSchema();
        return schema.getEvaluatedStaticSetDeclaration(context, setDeclaration);
    }

    public OlapSetEvaluation evaluateStaticSetDeclaration(OlapEvaluationContext context, OlapSetDeclaration setDeclaration) {
        OlapSchema schema = context.getSchema();
        return schema.evaluateStaticSetDeclaration(context, setDeclaration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GFStaticTupleEvaluator getOrCreateStaticTupleEvaluator(IOlapSchemaPermission permissions, OlapSchema schema) {
        Map<OlapSchema, OlapSchemaTupleEvaluators> map = this.allSchemaTupleEvaluators;
        synchronized (map) {
            OlapSchemaTupleEvaluators evaluators = this.allSchemaTupleEvaluators.computeIfAbsent(schema, s -> new OlapSchemaTupleEvaluators());
            GFStaticTupleEvaluator evaluator = evaluators.getOrCreateStaticTupleEvaluator(permissions);
            return evaluator;
        }
    }

    public void onSchemaStartedPhaseI(OlapEngineRequestContext context, OlapSchema schema, String command) {
        if (this.cluster != null) {
            this.cluster.onSchemaStartedPhaseI(schema.getClusterRef(), command);
        }
    }

    public void onSchemaStartedPhaseII(OlapEngineRequestContext context, OlapSchema schema, String command) {
        if (this.cluster != null) {
            this.cluster.onSchemaStartedPhaseII(schema.getClusterRef(), command);
        }
    }

    @Override
    public void onSchemaLoadedDone(OlapEngineRequestContext context, OlapSchema schema) {
        if (this.cluster != null) {
            this.cluster.onSchemaLoadedDone(schema.getClusterRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaLoaded(OlapEngineRequestContext context, OlapSchema schema) {
        if (this.allResultCaches == null) {
            return;
        }
        Map<Object, Object> map = this.allResultCaches;
        synchronized (map) {
            if (this.globalResultCache != null) {
                this.globalResultCache.onSchemaLoaded(schema);
            }
        }
        map = this.allSchemaCaches;
        synchronized (map) {
            this.getOrCreateSchemaCache(schema);
        }
        if (this.cluster != null) {
            this.cluster.onSchemaLoaded(schema.getClusterRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaLoadedOnError(OlapEngineRequestContext context, OlapSchema schema) {
        schema.onBuildError(this.cleaner);
        Map<OlapSchema, OlapSchemaCache> map = this.allSchemaTupleEvaluators;
        synchronized (map) {
            this.allSchemaTupleEvaluators.remove(schema);
        }
        map = this.sessions;
        synchronized (map) {
            for (IOlapSessionCacheManager session : this.sessions) {
                session.onSchemaLoadedOnError(schema);
            }
        }
        map = this.allSchemaCaches;
        synchronized (map) {
            this.allSchemaCaches.remove(schema);
        }
        if (this.cluster != null) {
            this.cluster.onSchemaLoadedOnError(schema.getClusterRef());
        }
    }

    public void onSchemaLoadedOnErrorCleanup(OlapEngineRequestContext context, OlapSchema schema) {
        schema.onBuildError(this.cleaner);
        if (this.cluster != null) {
            this.cluster.onSchemaLoadedOnErrorCleanup(schema.getClusterRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaIncrLoaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        Object object;
        if (this.allResultCaches != null) {
            object = this.allResultCaches;
            synchronized (object) {
                if (this.globalResultCache != null) {
                    this.globalResultCache.onSchemaIncrLoaded(schema, incrLoadInfo);
                }
            }
        }
        schema.onSchemaIncrLoaded(context, incrLoadInfo);
        this.clearSchemaResultCaches(context, schema);
        object = this.allSchemaTupleEvaluators;
        synchronized (object) {
            OlapSchemaTupleEvaluators evaluators = this.allSchemaTupleEvaluators.get(schema);
            if (evaluators != null) {
                evaluators.onSchemaIncrLoaded(schema, incrLoadInfo);
            }
        }
        object = this.allSchemaCaches;
        synchronized (object) {
            OlapSchemaCache cache = this.allSchemaCaches.get(schema);
            if (cache != null) {
                cache.onSchemaIncrLoaded(context, schema, incrLoadInfo);
            }
        }
        object = this.sessions;
        synchronized (object) {
            int size = this.sessions.size();
            for (int ii = 0; ii < size; ++ii) {
                IOlapSessionCacheManager session = this.sessions.get(ii);
                session.onSchemaIncrLoaded(context, schema, incrLoadInfo);
            }
        }
        if (this.cluster != null) {
            this.cluster.onSchemaIncrLoaded(schema.getClusterRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaIncrLoadedOnError(OlapEngineRequestContext context, OlapSchema schema) {
        Object object;
        if (this.allResultCaches != null) {
            object = this.allResultCaches;
            synchronized (object) {
                if (this.globalResultCache != null) {
                    this.globalResultCache.onSchemaIncrLoadedOnError(schema);
                }
            }
        }
        schema.onSchemaIncrLoadedOnError();
        this.clearSchemaResultCaches(context, schema);
        object = this.allSchemaTupleEvaluators;
        synchronized (object) {
            OlapSchemaTupleEvaluators evaluators = this.allSchemaTupleEvaluators.get(schema);
            if (evaluators != null) {
                evaluators.onSchemaIncrLoadedOnError(schema);
            }
        }
        object = this.allSchemaCaches;
        synchronized (object) {
            OlapSchemaCache cache = this.allSchemaCaches.get(schema);
            if (cache != null) {
                cache.onSchemaIncrLoadedOnError(context, schema);
            }
        }
        object = this.sessions;
        synchronized (object) {
            for (IOlapSessionCacheManager session : this.sessions) {
                session.onSchemaIncrLoadedOnError(schema);
            }
        }
        if (this.cluster != null) {
            this.cluster.onSchemaIncrLoadedOnError(schema.getClusterRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaScriptStatementApplied(OlapEngineRequestContext context, OlapSchema schema, OlapScriptInformation information) {
        schema.onScriptStatementApplied(information);
        this.clearSchemaResultCaches(context, schema);
        Object object = this.allSchemaTupleEvaluators;
        synchronized (object) {
            OlapSchemaTupleEvaluators evaluators = this.allSchemaTupleEvaluators.get(schema);
            if (evaluators != null) {
                evaluators.onSchemaScriptStatementApplied(schema, information);
            }
        }
        object = this.allSchemaCaches;
        synchronized (object) {
            OlapSchemaCache cache = this.allSchemaCaches.get(schema);
            if (cache != null) {
                cache.onSchemaScriptStatementApplied(context, schema, information);
            }
        }
        object = this.sessions;
        synchronized (object) {
            for (IOlapSessionCacheManager session : this.sessions) {
                session.onScriptStatementApplied(schema, information);
            }
        }
        if (this.cluster != null) {
            this.cluster.onSchemaScriptStatementApplied(schema.getClusterRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaUnloaded(OlapEngineRequestContext context, OlapSchema schema) {
        Object object;
        schema.onSchemaUnloaded(this.cleaner);
        if (this.allResultCaches != null) {
            object = this.allResultCaches;
            synchronized (object) {
                if (this.globalResultCache != null) {
                    this.globalResultCache.onSchemaUnloaded(schema);
                }
            }
        }
        this.clearSchemaResultCaches(context, schema);
        object = this.allSchemaTupleEvaluators;
        synchronized (object) {
            OlapSchemaTupleEvaluators evaluators = this.allSchemaTupleEvaluators.get(schema);
            if (evaluators != null) {
                evaluators.onSchemaUnloaded(schema);
                this.allSchemaTupleEvaluators.remove(schema);
            }
        }
        object = this.allSchemaCaches;
        synchronized (object) {
            OlapSchemaCache cache = this.allSchemaCaches.get(schema);
            if (cache != null) {
                cache.onSchemaUnloaded(context, schema);
                this.allSchemaCaches.remove(schema);
            }
        }
        object = this.sessions;
        synchronized (object) {
            for (IOlapSessionCacheManager session : this.sessions) {
                session.onSchemaUnloaded(schema);
            }
        }
        if (this.cluster != null) {
            this.cluster.onSchemaUnloaded(schema.getClusterRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaPartitionsUnloaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        Object object;
        if (this.allResultCaches != null) {
            object = this.allResultCaches;
            synchronized (object) {
                if (this.globalResultCache != null) {
                    this.globalResultCache.onSchemaPartitionsUnloaded(schema, unloadPartitionsInfo);
                }
            }
        }
        schema.onSchemaPartitionsUnloaded(unloadPartitionsInfo);
        this.clearSchemaResultCaches(context, schema);
        object = this.allSchemaTupleEvaluators;
        synchronized (object) {
            OlapSchemaTupleEvaluators evaluators = this.allSchemaTupleEvaluators.get(schema);
            if (evaluators != null) {
                evaluators.onSchemaPartitionsUnloaded(schema, unloadPartitionsInfo);
            }
        }
        object = this.allSchemaCaches;
        synchronized (object) {
            OlapSchemaCache cache = this.allSchemaCaches.get(schema);
            if (cache != null) {
                cache.onSchemaPartitionsUnloaded(context, schema, unloadPartitionsInfo);
            }
        }
        object = this.sessions;
        synchronized (object) {
            int size = this.sessions.size();
            for (int ii = 0; ii < size; ++ii) {
                IOlapSessionCacheManager session = this.sessions.get(ii);
                session.onSchemaPartitionsUnloaded(schema, unloadPartitionsInfo);
            }
        }
        if (this.cluster != null) {
            this.cluster.onSchemaPartitionsUnloaded(schema.getClusterRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaPartitionsLoaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        Object object;
        if (this.allResultCaches != null) {
            object = this.allResultCaches;
            synchronized (object) {
                if (this.globalResultCache != null) {
                    this.globalResultCache.onSchemaPartitionsLoaded(schema, loadPartitionsInfo);
                }
            }
        }
        schema.onSchemaPartitionsLoaded(loadPartitionsInfo);
        this.clearSchemaResultCaches(context, schema);
        object = this.allSchemaTupleEvaluators;
        synchronized (object) {
            OlapSchemaTupleEvaluators evaluators = this.allSchemaTupleEvaluators.get(schema);
            if (evaluators != null) {
                evaluators.onSchemaPartitionsLoaded(schema, loadPartitionsInfo);
            }
        }
        object = this.allSchemaCaches;
        synchronized (object) {
            OlapSchemaCache cache = this.allSchemaCaches.get(schema);
            if (cache != null) {
                cache.onSchemaPartitionsLoaded(context, schema, loadPartitionsInfo);
            }
        }
        object = this.sessions;
        synchronized (object) {
            int size = this.sessions.size();
            for (int ii = 0; ii < size; ++ii) {
                IOlapSessionCacheManager session = this.sessions.get(ii);
                session.onSchemaPartitionsLoaded(schema, loadPartitionsInfo);
            }
        }
        if (this.cluster != null) {
            this.cluster.onSchemaPartitionsLoaded(schema.getClusterRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaPartitionsLoadError(OlapEngineRequestContext context, OlapSchema schema) {
        Object object;
        if (this.allResultCaches != null) {
            object = this.allResultCaches;
            synchronized (object) {
                if (this.globalResultCache != null) {
                    this.globalResultCache.onSchemaPartitionsLoadError(schema);
                }
            }
        }
        schema.onSchemaPartitionsLoadError();
        this.clearSchemaResultCaches(context, schema);
        object = this.allSchemaTupleEvaluators;
        synchronized (object) {
            OlapSchemaTupleEvaluators evaluators = this.allSchemaTupleEvaluators.get(schema);
            if (evaluators != null) {
                evaluators.onSchemaPartitionsLoadError(schema);
            }
        }
        object = this.allSchemaCaches;
        synchronized (object) {
            OlapSchemaCache cache = this.allSchemaCaches.get(schema);
            if (cache != null) {
                cache.onSchemaPartitionsLoadError(context, schema);
            }
        }
        object = this.sessions;
        synchronized (object) {
            for (IOlapSessionCacheManager session : this.sessions) {
                session.onSchemaPartitionsLoadError(schema);
            }
        }
        if (this.cluster != null) {
            this.cluster.onSchemaPartitionsLoadedOnError(schema.getClusterRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaSecurityAllPermissionsRemoved(OlapEngineRequestContext context, OlapSchema schema) {
        schema.onSecurityAllPermissionsRemoved();
        this.clearSchemaResultCaches(context, schema);
        Object object = this.allSchemaTupleEvaluators;
        synchronized (object) {
            OlapSchemaTupleEvaluators evaluators = this.allSchemaTupleEvaluators.get(schema);
            if (evaluators != null) {
                evaluators.onSchemaSecurityAllPermissionsRemoved(schema);
            }
        }
        object = this.allSchemaCaches;
        synchronized (object) {
            OlapSchemaCache cache = this.allSchemaCaches.get(schema);
            if (cache != null) {
                cache.onSchemaSecurityAllPermissionsRemoved(context, schema);
            }
        }
        object = this.sessions;
        synchronized (object) {
            for (IOlapSessionCacheManager session : this.sessions) {
                session.onSecurityAllPermissionsRemoved(schema);
            }
        }
        if (this.cluster != null) {
            this.cluster.onSchemaSecurityAllPermissionsRemoved(schema.getClusterRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaSecurityPermissionsSwitched(OlapEngineRequestContext context, OlapSchema schema, String roleName, IOlapSchemaPermission newPerms, @Nullable IOlapSchemaPermission prevPerms) {
        schema.onSecurityPermissionsSwitched(context, prevPerms);
        if (prevPerms != null) {
            this.clearSchemaResultCaches(context, schema, prevPerms);
        }
        Object object = this.allSchemaTupleEvaluators;
        synchronized (object) {
            OlapSchemaTupleEvaluators evaluators = this.allSchemaTupleEvaluators.get(schema);
            if (evaluators != null) {
                evaluators.onSchemaSecurityPermissionsSwitched(schema, roleName, newPerms, prevPerms);
            }
        }
        object = this.allSchemaCaches;
        synchronized (object) {
            OlapSchemaCache cache = this.allSchemaCaches.get(schema);
            if (cache != null) {
                cache.onSchemaSecurityPermissionsSwitched(context, schema, roleName, newPerms, prevPerms);
            }
        }
        object = this.sessions;
        synchronized (object) {
            int size = this.sessions.size();
            for (int ii = 0; ii < size; ++ii) {
                IOlapSessionCacheManager session = this.sessions.get(ii);
                session.onSecurityPermissionsSwitched(context, schema, prevPerms);
            }
        }
        if (newPerms instanceof OlapPerspectiveSchemaPermission) {
            throw new RuntimeException("internal error: unexpected security permissions (perspective)");
        }
        S_FactPermsDef newPerms_ = newPerms.createClusterPerms();
        if (this.cluster != null) {
            this.cluster.onSchemaSecurityPermissionsSwitched(schema.getClusterRef(), roleName, newPerms_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSchemaResultCaches(OlapEngineRequestContext context, OlapSchema schema) {
        if (this.allResultCaches == null) {
            return;
        }
        Map<OlapResultCacheKey, OlapResultCache> map = this.allResultCaches;
        synchronized (map) {
            ArrayList<OlapResultCacheKey> toRemove = null;
            for (OlapResultCacheKey key : this.allResultCaches.keySet()) {
                if (!key.getSchema().equals(schema)) continue;
                if (toRemove == null) {
                    toRemove = new ArrayList<OlapResultCacheKey>();
                }
                toRemove.add(key);
            }
            if (toRemove != null) {
                for (OlapResultCacheKey key : toRemove) {
                    OlapResultCache cache = this.allResultCaches.remove(key);
                    if (cache == null) continue;
                    cache.clear(context);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSchemaResultCaches(OlapEngineRequestContext context, OlapSchema schema, @Nullable IOlapSchemaPermission permissions) {
        if (this.allResultCaches == null) {
            return;
        }
        Map<OlapResultCacheKey, OlapResultCache> map = this.allResultCaches;
        synchronized (map) {
            ArrayList<OlapResultCacheKey> toRemove = null;
            for (OlapResultCacheKey key : this.allResultCaches.keySet()) {
                if (!key.getSchema().equals(schema) || !key.getSchemaPermission().equals(permissions)) continue;
                if (toRemove == null) {
                    toRemove = new ArrayList<OlapResultCacheKey>();
                }
                toRemove.add(key);
            }
            if (toRemove != null) {
                for (OlapResultCacheKey key : toRemove) {
                    OlapResultCache cache = this.allResultCaches.remove(key);
                    if (cache == null) continue;
                    cache.clear(context);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAllSchemaResultCaches(OlapEngineRequestContext context) {
        if (this.allResultCaches == null) {
            return;
        }
        Map<OlapResultCacheKey, OlapResultCache> map = this.allResultCaches;
        synchronized (map) {
            for (OlapResultCache cache : this.allResultCaches.values()) {
                cache.clear(context);
            }
            this.allResultCaches.clear();
        }
    }
}

