/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.alert;

import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutionPermit;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapAlert;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.io.Serializable;
import java.util.List;

public abstract class OlapAlertEvalHelper {
    public static boolean eval(OlapEngineRequestContext requestContext, OlapMdxExecutionPermit permit, OlapSchema schema, OlapCube cube, OlapAlert alert) {
        try {
            OlapEngineMdxHelper helper = OlapEngineMdxHelper.create(requestContext);
            OlapEntity res = helper.executeMdxValueExpression(permit, schema, cube.getName(OlapNameContext.DEFAULT_VALUES), alert.createStatement(), "?");
            if (res instanceof OlapBooleanEntity) {
                OlapBooleanEntity alerted = (OlapBooleanEntity)res;
                return alerted.value();
            }
            throw new OlapEvaluationException((OlapErrorLocation)null, OlapErrorCode.ALERT_TYPE_MISMATCH, new Serializable[]{schema.getName(), alert.getName(), res.getFriendlyTypeName()});
        }
        catch (CdMdxScannerException | MdxParserException ex) {
            OlapLoggers.SCHEDULER.error((Object)("[SCHEDULER-ALERTS] [schema:" + schema.getName() + "] [alert:" + alert.getName() + "] eval. error"), (Throwable)ex);
            throw new OlapEvaluationException((OlapErrorLocation)null, OlapErrorCode.ALERT_EVAL_ERROR, new Serializable[]{schema.getName(), alert.getName(), ex.getMessage()});
        }
    }

    public static OlapCube resolveAlertCube(OlapEngineRequestContext requestContext, OlapSchema schema, OlapAlert alert) {
        IOlapSchemaPermission perms = requestContext.getSchemaPermissions(schema);
        List<OlapCube> cubes = schema.getCubes(perms);
        String alertCubeName = alert.getCubeName();
        if (CdStringUtils.isNotNullAndNotBlank((String)alertCubeName)) {
            OlapRequestNamesContext nameContext = requestContext.getNameContext();
            for (OlapCube cube : cubes) {
                if (!OlapCaseInsensitiveName.equals(cube.getName(nameContext), alertCubeName)) continue;
                return cube;
            }
            throw new OlapEvaluationException((OlapErrorLocation)null, OlapErrorCode.ALERT_MISSING_CUBE, new Serializable[]{schema.getName(), alert.getName(), alert.getCubeName()});
        }
        if (cubes.size() == 1) {
            return cubes.get(0);
        }
        StringBuilder cubeNames = new StringBuilder();
        for (int ii = 0; ii < cubes.size(); ++ii) {
            if (ii > 0) {
                cubeNames.append(",");
            }
            cubeNames.append(cubes.get(ii).getNameX());
        }
        throw new OlapEvaluationException((OlapErrorLocation)null, OlapErrorCode.ALERT_CUBE_UNSPECIFIED, new Serializable[]{schema.getName(), alert.getName(), cubeNames.toString()});
    }
}

