/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.action;

import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.result.OlapResDropActionBlankStatementDataSet;
import crazydev.iccube.olap.eval.action.OlapDropActionStatementExecutionContext;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.OlapScriptCommandStatementInstr;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDropActionStatementInstr
extends OlapScriptCommandStatementInstr<OlapDropActionStatementExecutionContext> {
    private final List<String> names;

    public OlapDropActionStatementInstr(OlapInstrLocationRange range, List<String> names) {
        super(range);
        this.names = names;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.WRITE;
    }

    @Override
    public String typeForError() {
        return "DROP ACTION";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        v.visit(this);
    }

    @Override
    protected OlapDropActionStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapDropActionStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapDropActionStatementExecutionContext context) {
        this.assertAuthorizationForDropStatement(context);
        OlapSchema schema = context.getSchema();
        if (context.isPrepareExecutionMode()) {
            return new OlapResDropActionBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        for (String name : this.names) {
            schema.removeAction(context.getErrorLocation(), context.getSchemaPermissions(), name);
        }
        this.onScriptStatementApplied(context, schema, true);
        return new OlapResDropActionBlankStatementDataSet(schema.getName(), "?", this.getActionNames());
    }

    private String getActionNames() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.names) {
            if (!sb.isEmpty()) {
                sb.append(",");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    @Override
    public String toStringForDebugger() {
        return "DROP ACTION : " + this.names.toString();
    }
}

