/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.tuple.dimensionality;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityHelper;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class OlapTupleDimensionalityCache {
    private final Map<OlapBitSet, OlapTupleDimensionality> tupleDimensionalities = new ConcurrentHashMap<OlapBitSet, OlapTupleDimensionality>();

    public OlapTupleDimensionality getOrCreate(OlapBitSet hierarchies) {
        return this.tupleDimensionalities.computeIfAbsent(hierarchies, hierarchies_ -> {
            if (hierarchies.cardinality() < 2) {
                throw new CdShouldNotBeHereProgrammingException();
            }
            return new OlapTupleDimensionality(OlapTupleDimensionality.Usage.CACHE, hierarchies);
        });
    }

    public OlapTupleDimensionality getOrCreate(@Nullable IOlapEvaluationExceptionContext errContext, IOlapTuple tuple) {
        int count = tuple.getMemberCount();
        if (count == 1) {
            OlapMember member = tuple.getMember(0);
            return member.getHierarchy().getTupleDimensionality();
        }
        OlapBitSet key = OlapTupleDimensionalityCache.createLookupKey(errContext, tuple);
        OlapTupleDimensionality dim = this.getOrCreateTupleDimensionality(key);
        return dim;
    }

    private static OlapBitSet createLookupKey(@Nullable IOlapEvaluationExceptionContext context, IOlapTuple tuple) {
        OlapBitSet hierarchies = new OlapBitSet();
        int count = tuple.getMemberCount();
        for (int idx = 0; idx < count; ++idx) {
            OlapMember member = tuple.getMember(idx);
            OlapHierarchy hierarchy = member.getHierarchy();
            int bit = hierarchy.getTupleDimensionalityIndex();
            if (!hierarchies.setX(bit)) continue;
            if (context == null) {
                context = IOlapEvaluationExceptionContext.NULL;
            } else if (!context.isDimensionalityCheck()) continue;
            OlapTupleDimensionalityHelper.onDimensionalityError(context, tuple);
        }
        return hierarchies;
    }

    public OlapTupleDimensionality getOrCreateUnion(OlapTupleDimensionality dim1, OlapTupleDimensionality dim2) {
        if (dim1.size() == 1 && dim2.size() == 1 && dim1.intersects(dim2)) {
            return dim1;
        }
        OlapBitSet key = dim1.unionEx(dim2);
        OlapTupleDimensionality dim = this.getOrCreateTupleDimensionality(key);
        return dim;
    }

    private OlapTupleDimensionality getOrCreateTupleDimensionality(OlapBitSet key) {
        return this.tupleDimensionalities.computeIfAbsent(key, key_ -> new OlapTupleDimensionality(OlapTupleDimensionality.Usage.CACHE, (OlapBitSet)key_));
    }
}

