/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.tuple.dimensionality;

import crazydev.common.collection.CdArrayList;
import crazydev.iccube.cluster.shared.schema.S_BitSetTupleDimensionality;
import crazydev.iccube.cluster.shared.schema.S_MemberDef;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionality;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.IOlapDimensionality;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityFactory;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import org.jetbrains.annotations.Nullable;

public class OlapTupleDimensionality
implements S_TupleDimensionality,
IOlapDimensionality {
    private final Usage usage;
    private final OlapBitSet hierarchies;
    private final int size;
    private int[] mapping;

    OlapTupleDimensionality(Usage usage) {
        this(usage, new OlapBitSet(), -1);
    }

    OlapTupleDimensionality(Usage usage, int tupleDimensionalityIndex) {
        this(usage, new OlapBitSet(), tupleDimensionalityIndex);
    }

    OlapTupleDimensionality(Usage usage, OlapBitSet hierarchies) {
        this(usage, hierarchies, -1);
    }

    private OlapTupleDimensionality(Usage usage, OlapBitSet hierarchies, int tupleDimensionalityIndex) {
        this.usage = usage;
        this.hierarchies = hierarchies;
        if (tupleDimensionalityIndex != -1 && tupleDimensionalityIndex != -2) {
            this.hierarchies.set(tupleDimensionalityIndex);
        }
        this.size = hierarchies.cardinality();
    }

    public OlapTupleDimensionality(Usage usage, long[] words) {
        this.usage = usage;
        this.hierarchies = new OlapBitSet(words);
        this.size = this.hierarchies.cardinality();
    }

    public OlapTupleDimensionality(OlapBitSet bitSet) {
        this.usage = Usage.OTHER;
        this.hierarchies = bitSet;
        this.size = this.hierarchies.cardinality();
    }

    public OlapBitSet copyBitSet() {
        return new OlapBitSet(this.hierarchies);
    }

    public static boolean same(OlapTuple tuple, OlapTuple tuple2) {
        return tuple.getTupleDimensionality().intersects(tuple2.getTupleDimensionality());
    }

    @Override
    public OlapBitSet asBitSet() {
        return this.hierarchies;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    @Override
    public int cardinality() {
        return this.hierarchies.cardinality();
    }

    public boolean isIn(OlapHierarchy hierarchy) {
        return this.hierarchies.get(hierarchy.getTupleDimensionalityIndex());
    }

    @Override
    public boolean isIn(S_MemberDef member) {
        return this.hierarchies.get(member.getHierIdx());
    }

    @Override
    public S_TupleDimensionality and(S_TupleDimensionality other) {
        if (this.isEmpty() || other.isEmpty()) {
            return S_BitSetTupleDimensionality.ZERO;
        }
        OlapBitSet copy = new OlapBitSet(this.hierarchies);
        copy.and(other.asBitSet());
        if (copy.isEmpty()) {
            return S_BitSetTupleDimensionality.ZERO;
        }
        return new S_BitSetTupleDimensionality(copy.getWords());
    }

    public OlapTupleDimensionality and(OlapTupleDimensionality other) {
        if (this.isEmpty() || other.isEmpty()) {
            return OlapTupleDimensionalityFactory.createForBlankTuple();
        }
        OlapBitSet copy = new OlapBitSet(this.hierarchies);
        copy.and(other.asBitSet());
        if (copy.isEmpty()) {
            return OlapTupleDimensionalityFactory.createForBlankTuple();
        }
        return new OlapTupleDimensionality(copy);
    }

    public boolean intersects(OlapTupleDimensionality other) {
        return this == other || this.hierarchies.intersects(other.hierarchies);
    }

    public boolean containsAll(OlapTupleDimensionality other) {
        return this.hierarchies.containsAll(other.hierarchies);
    }

    @Override
    public OlapTupleDimensionality union(S_TupleDimensionality dimensionality) {
        OlapBitSet newBitSet = this.unionEx(dimensionality);
        return new OlapTupleDimensionality(Usage.OTHER, newBitSet);
    }

    public OlapBitSet unionEx(S_TupleDimensionality dimensionality) {
        OlapBitSet newBitSet = new OlapBitSet();
        newBitSet.or(this.hierarchies);
        newBitSet.or(dimensionality.asBitSet());
        return newBitSet;
    }

    public OlapBitSet andBitSet(OlapTupleDimensionality colDimensionality) {
        OlapBitSet newSet = new OlapBitSet(this.hierarchies);
        newSet.and(colDimensionality.hierarchies);
        return newSet;
    }

    public OlapTupleDimensionality or(@Nullable OlapTupleDimensionality dimensionality) {
        if (dimensionality == null) {
            return this;
        }
        OlapBitSet newSet = new OlapBitSet(this.hierarchies);
        newSet.or(dimensionality.hierarchies);
        return new OlapTupleDimensionality(Usage.OTHER, newSet);
    }

    public int[] getMapping() {
        if (this.mapping == null) {
            return this.getOrCreateMapping();
        }
        return this.mapping;
    }

    private synchronized int[] getOrCreateMapping() {
        if (this.mapping != null) {
            return this.mapping;
        }
        CdArrayList array = new CdArrayList();
        int pos = 0;
        int i = this.hierarchies.nextSetBit(0);
        while (i >= 0) {
            array.set(i, (Object)pos++);
            i = this.hierarchies.nextSetBit(i + 1);
        }
        int[] mappingArray = new int[array.size()];
        for (int i2 = 0; i2 < array.size(); ++i2) {
            Integer integer = (Integer)array.get(i2);
            mappingArray[i2] = integer == null ? -1 : integer;
        }
        this.mapping = mappingArray;
        return this.mapping;
    }

    public boolean equals_(Object obj) {
        return this.equals(obj);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OlapTupleDimensionality that = (OlapTupleDimensionality)obj;
        if (this.usage != Usage.OTHER && that.usage != Usage.OTHER) {
            return false;
        }
        return this.hierarchies.equals(that.hierarchies);
    }

    public int hashCode() {
        if (this.usage != Usage.OTHER) {
            return System.identityHashCode(this);
        }
        return this.hierarchies.hashCode();
    }

    public String asString(OlapMdxStatementExecutionContext context) {
        StringBuilder sb = new StringBuilder("( ");
        OlapNameContext nameContext = context.getNameContext();
        boolean needComma = false;
        int idx = this.hierarchies.nextSetBit(0);
        while (idx >= 0) {
            OlapHierarchy hierarchy;
            if (needComma) {
                sb.append(", ");
            }
            if ((hierarchy = context.lookupHierarchyByTupleDimensionalityIndex(idx)) != null) {
                sb.append(hierarchy.getUniqueName(nameContext));
            } else {
                sb.append(idx);
            }
            needComma = true;
            idx = this.hierarchies.nextSetBit(idx + 1);
        }
        sb.append(" )");
        return sb.toString();
    }

    public String toString() {
        return this.hierarchies.toString();
    }

    public long[] getWords() {
        return this.hierarchies.getWords();
    }

    public boolean isIn(OlapTupleDimensionality dimensionality) {
        return this == dimensionality || this.hierarchies.isIn(dimensionality.hierarchies);
    }

    public static enum Usage {
        DEGENERATED,
        HIERARCHY,
        CACHE,
        OTHER;

    }
}

