/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.tuple;

import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleHierarchizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class OlapTupleHierarchizedList {
    private ArrayList tupleWithRank;
    private final Comparator<OlapTupleHierarchizer.TupleWithRank> comparator;

    public OlapTupleHierarchizedList(boolean postOn) {
        this.comparator = postOn ? OlapTupleHierarchizer.POST_ON : OlapTupleHierarchizer.POST_OFF;
        this.tupleWithRank = new ArrayList();
    }

    public OlapTupleHierarchizedList(List<? extends OlapTuple> tuples, boolean postOn) {
        this.comparator = postOn ? OlapTupleHierarchizer.POST_ON : OlapTupleHierarchizer.POST_OFF;
        this.tupleWithRank = new ArrayList(tuples.size());
        for (int i = 0; i < tuples.size(); ++i) {
            OlapTuple tuple = tuples.get(i);
            this.add(tuple);
        }
    }

    public boolean add(OlapTuple tuple) {
        OlapTupleHierarchizer.TupleWithRank allInOne = new OlapTupleHierarchizer.TupleWithRank(tuple);
        int val = Collections.binarySearch(this.tupleWithRank, allInOne, this.comparator);
        if (val >= 0) {
            return this.addInternal(val + 1, allInOne);
        }
        return this.addInternal(-val - 1, allInOne);
    }

    private boolean addInternal(int pos, OlapTupleHierarchizer.TupleWithRank allInOne) {
        while (pos < this.tupleWithRank.size() && this.comparator.compare(allInOne, (OlapTupleHierarchizer.TupleWithRank)this.tupleWithRank.get(pos)) == 0) {
            ++pos;
        }
        if (pos >= this.tupleWithRank.size()) {
            this.tupleWithRank.add(allInOne);
        } else {
            this.tupleWithRank.add(pos, allInOne);
        }
        return true;
    }

    public List resetAndGetTupleList() {
        ArrayList tuples = this.tupleWithRank;
        this.tupleWithRank = null;
        for (int i = 0; i < tuples.size(); ++i) {
            tuples.set(i, ((OlapTupleHierarchizer.TupleWithRank)tuples.get((int)i)).tuple);
        }
        return tuples;
    }
}

