/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.tuple;

import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.IOlapMembers;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;

public abstract class OlapTupleHelper {
    public static boolean sameCell(IOlapTuple left, IOlapTuple right) {
        OlapTupleDimensionality rDim;
        int rCount;
        if (left.isKO() || right.isKO()) {
            return false;
        }
        int lCount = left.getMemberCount();
        if (lCount != (rCount = right.getMemberCount())) {
            return false;
        }
        if (lCount == 1) {
            return left.equals(right);
        }
        OlapTupleDimensionality lDim = left.getTupleDimensionality();
        if (!lDim.equals_(rDim = right.getTupleDimensionality())) {
            return false;
        }
        for (int ii = 0; ii < lCount; ++ii) {
            OlapMember lMember = left.getMember(ii);
            OlapHierarchy lMemberHierarchy = lMember.getHierarchy();
            int rMemberIdx = right.getMemberPos(lMemberHierarchy);
            if (rMemberIdx == -1) {
                return false;
            }
            OlapMember rMember = right.getMember(rMemberIdx);
            if (lMember.equals(rMember)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(IOlapTuple left, IOlapTuple right) {
        int leftMembersCount = left.getMemberCount();
        if (leftMembersCount != right.getMemberCount()) {
            return false;
        }
        for (int tidx = 0; tidx < leftMembersCount; ++tidx) {
            if (left.getMember(tidx).equals(right.getMember(tidx))) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(IOlapTuple tuple) {
        int hash = 1;
        int membersCount = tuple.getMemberCount();
        for (int idx = 0; idx < membersCount; ++idx) {
            OlapMember member = tuple.getMember(idx);
            hash = 31 * hash + member.hashCode();
        }
        return hash;
    }

    public static String toDimensionalityString(OlapNameContext nameContext, IOlapTuple tuple) {
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < tuple.getMemberCount(); ++idx) {
            OlapMember member = tuple.getMember(idx);
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(member.getHierarchy().getUniqueName(nameContext));
        }
        return sb.toString();
    }

    public static String toString(IOlapMembers tuple) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int membersCount = tuple.getMemberCount();
        for (int idx = 0; idx < membersCount; ++idx) {
            OlapMember member = tuple.getMember(idx);
            if (sb.length() > 1) {
                sb.append(",");
            }
            if (member.isAll()) {
                sb.append(ONames.name4Log(member.getHierarchy()));
                sb.append(".");
            }
            sb.append(ONames.name4Log(member));
            sb.append("<").append(member.getKey()).append(">");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String toTidyCellsColumnName(IOlapMembers tuple) {
        StringBuilder sb = new StringBuilder();
        int membersCount = tuple.getMemberCount();
        for (int idx = 0; idx < membersCount; ++idx) {
            OlapMember member = tuple.getMember(idx);
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(member.getNameX());
        }
        return sb.toString();
    }
}

