/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.tuple;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.OlapBlankTuple;
import crazydev.iccube.olap.entity.tuple.OlapFilteredOutTuple;
import crazydev.iccube.olap.entity.tuple.OlapInvalidTuple;
import crazydev.iccube.olap.entity.tuple.OlapRegularTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapTupleFactory {
    public static OlapTuple instance(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, OlapMember ... newTuple) {
        return OlapTupleFactory.instance(context, cache, (OlapTupleDimensionality)null, newTuple);
    }

    public static OlapTuple instance(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, @Nullable OlapTupleDimensionality dimensionality, OlapMember ... members) {
        return members.length == 1 ? members[0] : new OlapRegularTuple(context, cache, dimensionality, members);
    }

    public static OlapTuple instance(OlapTupleDimensionality dimensionality, OlapMember ... members) {
        return members.length == 1 ? members[0] : new OlapRegularTuple(dimensionality, members);
    }

    public static OlapTuple instance(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, @Nullable OlapTupleFilter tupleFilter, List<OlapMember> members) {
        return OlapTupleFactory.instance(context, cache, tupleFilter, null, members);
    }

    public static OlapTuple instance(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, @Nullable OlapTupleFilter tupleFilter, @Nullable OlapTuple tuple, List<OlapMember> emembers) {
        if (tuple != null) {
            if (tuple.isKO()) {
                return tuple;
            }
            if (emembers.isEmpty()) {
                return OlapTupleFactory.filter(tupleFilter, tuple);
            }
        } else {
            if (emembers.size() == 1) {
                return OlapTupleFactory.filter(tupleFilter, emembers.get(0));
            }
            if (emembers.isEmpty()) {
                return OlapInvalidTuple.INSTANCE;
            }
        }
        return OlapTupleFactory.filter(tupleFilter, new OlapRegularTuple(context, cache, tuple, emembers));
    }

    public static OlapTuple instance(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, @Nullable OlapTupleFilter tupleFilter, OlapTuple ... tuples) {
        if (tuples == null || tuples.length == 0) {
            return OlapBlankTuple.INSTANCE;
        }
        if (tuples.length == 1) {
            return OlapTupleFactory.filter(tupleFilter, tuples[0]);
        }
        for (int idx = 0; idx < tuples.length; ++idx) {
            OlapTuple tuple = tuples[idx];
            if (!tuple.isKO()) continue;
            return tuple;
        }
        return OlapTupleFactory.filter(tupleFilter, new OlapRegularTuple(context, cache, tuples));
    }

    private static OlapTuple filter(@Nullable OlapTupleFilter tupleFilter, OlapTuple tuple) {
        if (tupleFilter == null) {
            return tuple;
        }
        return tupleFilter.isAccepting(tuple) ? tuple : OlapFilteredOutTuple.INSTANCE;
    }

    public static OlapTuple instance(GFContext context, List<OlapEntity> entities) {
        OlapMember[] members = new OlapMember[entities.size()];
        for (int idx = 0; idx < entities.size(); ++idx) {
            OlapEntity entity = entities.get(idx);
            if (entity.isMdxNull()) {
                return OlapInvalidTuple.INSTANCE;
            }
            if (!entity.isToMemberApplicable(context.getPrepareContext())) {
                throw new OlapEvaluationException(context, OlapErrorCode.TYPE_MISMATCH, new Serializable[]{"member", entity.getFriendlyTypeName()});
            }
            OlapMember member = entity.toNullableMember(context.getPrepareContext());
            if (member == null) {
                return OlapFilteredOutTuple.INSTANCE;
            }
            members[idx] = member;
        }
        OlapTupleFilter filter = null;
        return members.length == 1 ? members[0] : OlapTupleFactory.filter(filter, new OlapRegularTuple(context, members));
    }
}

