/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.subcube;

import crazydev.common.collection.CdArrayList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.cluster.shared.schema.S_FactSubCube;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapAbstractCategoryMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapTruncatedString;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeOperationKind;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapSubCubeOthersEntity
extends OlapSubCubeEntity {
    public static final String FRIENDLY_NAME = "SubCubeOthers";

    public OlapSubCubeOthersEntity(List<OlapNonScalarEntity> args) {
        super(args);
    }

    @Override
    public List<OlapNonScalarEntity> getEntities(OlapAbstractCategoryMember member) {
        List<OlapNonScalarEntity> args = super.getEntities(member);
        CdArrayList list = new CdArrayList();
        OlapMember parent = member.getParent();
        list.add(parent == null || parent.isAll() ? null : parent);
        if (args.isEmpty() && parent != null) {
            int count = parent.getChildrenCount();
            for (int i = 0; i < count; ++i) {
                OlapMember child = parent.getChild(i);
                if (child.isOtherCategory()) continue;
                list.add(child);
            }
        } else {
            for (OlapNonScalarEntity entity : args) {
                list.add(entity);
            }
        }
        return list;
    }

    @Override
    public S_FactSubCube asClusterCube(@Nullable OlapAbstractCategoryMember category) {
        if (category == null) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        List<OlapNonScalarEntity> entities = this.getEntities(category);
        int size = entities.size();
        if (size == 0) {
            return new S_FactSubCube(S_FactSubCube.Operation.AND);
        }
        S_FactSubCube sucuNot = new S_FactSubCube(S_FactSubCube.Operation.NOT);
        S_FactSubCube sucuOr = new S_FactSubCube(S_FactSubCube.Operation.OR);
        for (int i = 1; i < size; ++i) {
            OlapSubCubeOthersEntity.add(sucuOr, entities.get(i));
        }
        sucuNot.addSubCube(sucuOr);
        OlapNonScalarEntity parent = entities.get(0);
        if (parent == null) {
            return sucuNot;
        }
        S_FactSubCube sucuAnd = new S_FactSubCube(S_FactSubCube.Operation.AND);
        OlapSubCubeOthersEntity.add(sucuAnd, parent);
        sucuAnd.addSubCube(sucuNot);
        return sucuAnd;
    }

    @Override
    public OlapSubCubeOperationKind getOperation() {
        return OlapSubCubeOperationKind.OTHERS;
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    @Override
    public String toMdxString(OlapNameContext nameContext, boolean truncate, int maxSize) throws OlapTruncatedString {
        return "SubCubeOthers()";
    }
}

