/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.subcube;

import crazydev.common.collection.CdActionEx;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.cluster.shared.schema.S_FactSubCube;
import crazydev.iccube.cluster.shared.schema.S_MemberDef;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.member.OlapAbstractCategoryMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarAbstractEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeOperationKind;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapSubCubeEntity
extends OlapNonScalarAbstractEntity {
    private List<OlapNonScalarEntity> args;

    protected OlapSubCubeEntity(List<OlapNonScalarEntity> args) {
        this.args = args;
    }

    public boolean isNeutralElement() {
        return false;
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.SUB_CUBE;
    }

    public abstract OlapSubCubeOperationKind getOperation();

    public List<OlapNonScalarEntity> getEntities(@Nullable OlapAbstractCategoryMember member) {
        return this.args;
    }

    public boolean forEachSet(CdActionEx<OlapTupleSet<?>> action) {
        for (int i = 0; i < this.args.size(); ++i) {
            OlapNonScalarEntity entity = this.args.get(i);
            if (!(entity instanceof OlapTupleSet ? !action.apply(i, (Object)((OlapTupleSet)entity)) : entity instanceof OlapSubCubeEntity && !((OlapSubCubeEntity)entity).forEachSet(action))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapSubCubeEntity that = (OlapSubCubeEntity)o;
        return !(this.args == null ? that.args != null : !this.args.equals(that.args));
    }

    @Override
    public int hashCode() {
        return this.args != null ? this.args.hashCode() : 0;
    }

    public abstract S_FactSubCube asClusterCube(@Nullable OlapAbstractCategoryMember var1);

    protected static void add(S_FactSubCube sucu, OlapNonScalarEntity olapNonScalarEntity) {
        if (olapNonScalarEntity instanceof OlapSubCubeEntity) {
            OlapSubCubeEntity subCubeEntity = (OlapSubCubeEntity)olapNonScalarEntity;
            sucu.addSubCube(subCubeEntity.asClusterCube(null));
        } else if (olapNonScalarEntity instanceof OlapMember) {
            OlapMember member = (OlapMember)olapNonScalarEntity;
            sucu.addMember(new S_MemberDef(member));
        } else if (olapNonScalarEntity instanceof OlapTupleSet) {
            OlapTuple tuple;
            OlapTupleSet set = (OlapTupleSet)olapNonScalarEntity;
            OlapIterator tupleIter = set.getIterator(false);
            tupleIter.reset();
            while ((tuple = (OlapTuple)tupleIter.next()) != null) {
                if (tuple.getMemberCount() == 1) {
                    OlapMember member = tuple.getMember(0);
                    OlapSubCubeEntity.add(sucu, member);
                    continue;
                }
                S_FactSubCube sucu2 = new S_FactSubCube(S_FactSubCube.Operation.AND);
                for (int j = 0; j < tuple.getMemberCount(); ++j) {
                    OlapMember member = tuple.getMember(j);
                    OlapSubCubeEntity.add(sucu2, member);
                }
                sucu.addSubCube(sucu2);
            }
        } else {
            throw new CdShouldNotBeHereProgrammingException(olapNonScalarEntity.getFriendlyTypeName());
        }
    }

    @Override
    public String toStringForDebugger() {
        return this.getOperation().name() + "(...)";
    }
}

