/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.set;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapListAsNamedTupleSet;
import crazydev.iccube.olap.entity.set.OlapListNamedTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleHierarchizedList;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.select.context.OlapSetFormulaEvaluationContext;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class OlapListTupleSet<T extends OlapTuple>
extends OlapTupleSet<T> {
    public static final OlapListTupleSet EMPTY_TUPLE_SET = new OlapListTupleSet(Collections.emptyList());
    protected final List<T> tuples;
    private boolean unorder;

    private OlapListTupleSet(List<T> tuples, boolean unorder) {
        this.tuples = tuples;
        this.unorder = unorder;
    }

    OlapListTupleSet(List<T> tuples) {
        this.tuples = tuples;
    }

    @Override
    public long fastEstimatedSize() {
        return this.tuples.size();
    }

    @Override
    public boolean mightHaveCalcMember() {
        boolean hasCalcMember = false;
        for (int ii = 0; ii < this.tuples.size(); ++ii) {
            OlapTuple tuple = (OlapTuple)this.tuples.get(ii);
            if (!tuple.isCalculated()) continue;
            hasCalcMember = true;
            break;
        }
        return hasCalcMember;
    }

    @Override
    public OlapTupleSet<T> materialize() {
        return this;
    }

    @Override
    public boolean isSlicerFiltered() {
        return false;
    }

    @Override
    public int _sizeSlow() {
        return this.tuples.size();
    }

    @Override
    @Nullable
    public T _getSlow(int index) {
        if (index >= this.tuples.size()) {
            return null;
        }
        return (T)((OlapTuple)this.tuples.get(index));
    }

    @Override
    public OlapTupleSet<T> head(int count) {
        if (count < 1) {
            return OlapSetFactory.empty();
        }
        if (count >= this.tuples.size()) {
            return this;
        }
        List<T> xmembers = this.tuples.subList(0, count);
        return new OlapListTupleSet<T>(xmembers);
    }

    @Override
    public OlapTupleSet<T> tail(int count) {
        if (count < 1) {
            return OlapSetFactory.empty();
        }
        if (count >= this.tuples.size()) {
            return this;
        }
        List<T> xmembers = this.tuples.subList(this.tuples.size() - count, this.tuples.size());
        return new OlapListTupleSet<T>(xmembers);
    }

    @Override
    public OlapTupleSet<T> subset(int start, int count) {
        if (start < 0 || start >= this.tuples.size()) {
            return OlapSetFactory.empty();
        }
        int to = count == -1 ? this.tuples.size() : Math.min(start + count, this.tuples.size());
        List<T> xmembers = this.tuples.subList(start, to);
        return new OlapListTupleSet<T>(xmembers);
    }

    @Override
    public OlapListTupleSet<T> asTupleList() {
        return new OlapListTupleSet<T>(this.tuples);
    }

    @Override
    public boolean isMembersCrossjoin() {
        return false;
    }

    @Override
    public void setUnorder() {
        this.unorder = true;
    }

    @Override
    public boolean isUnorder() {
        return this.unorder;
    }

    @Override
    public boolean _isEmpty() {
        return this.tuples.isEmpty();
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        this.tuples.forEach(consumer);
    }

    @Override
    public OlapIterator<T> getIterator(boolean forceCache) {
        return OlapIteratorFactory.instance(this.tuples);
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        if (this.tuples.isEmpty()) {
            return null;
        }
        return ((OlapTuple)this.tuples.get(0)).getTupleDimensionality();
    }

    @Override
    public OlapTupleSet<T> hierarchize(boolean post) {
        if (this.tuples.isEmpty()) {
            return this;
        }
        OlapTupleHierarchizedList list = new OlapTupleHierarchizedList(this.tuples, post);
        return new OlapListTupleSet<T>(list.resetAndGetTupleList());
    }

    @Override
    public OlapTupleSet<T> convertToMaterializedNamedSet(OlapSetFormulaEvaluationContext context, String name, int limit) {
        return new OlapListNamedTupleSet<T>(name, this.tuples);
    }

    @Override
    public OlapTupleSet<T> convertToAsNamedSet(String name) {
        return new OlapListAsNamedTupleSet<T>(name, this.tuples);
    }

    @Override
    public boolean isNamedSet() {
        return false;
    }

    @Override
    public boolean isAsNamedSet() {
        return false;
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    @Nullable
    public OlapTupleSet<OlapMember> asMemberSet() {
        if (this.tuples.isEmpty()) {
            return this;
        }
        if (this.tuples.get(0) instanceof OlapMember) {
            return this;
        }
        return null;
    }

    public List<T> getTuples() {
        return this.tuples;
    }

    public T getItem(int lookupPos) {
        return (T)((OlapTuple)this.tuples.get(lookupPos));
    }

    public int size() {
        return this.tuples.size();
    }

    public boolean hasCalculatedMember() {
        for (int i = 0; i < this.tuples.size(); ++i) {
            OlapTuple t = (OlapTuple)this.tuples.get(i);
            if (!t.isCalculated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapListTupleSet that = (OlapListTupleSet)o;
        return this.tuples.size() == that.tuples.size() && this.tuples.equals(that.tuples);
    }

    @Override
    public int hashCode() {
        return this.tuples.hashCode();
    }

    public OlapListTupleSet<T> limit(int maxSize) {
        if (maxSize < 0 || maxSize >= this.tuples.size()) {
            return this;
        }
        List<T> ntuples = this.tuples.subList(0, maxSize);
        return new OlapListTupleSet<T>(ntuples, this.unorder);
    }
}

