/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar.tidy;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.olap.entity.scalar.tidy.TidyColumn;
import crazydev.iccube.olap.entity.scalar.tidy.TidyColumnPaginated;
import crazydev.iccube.pub.olap.ITidyColumn;
import crazydev.iccube.pub.olap.ITidyTable;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class TidyTable
implements ITidyTable {
    private final Map<String, ITidyColumn> columns = new ConcurrentHashMap<String, ITidyColumn>();
    private final ArrayList<String> columnNames;

    public TidyTable(Map<N_FactPage, IntArrayList> tidyTablePages) {
        N_FactPage firstPage = (N_FactPage)tidyTablePages.keySet().stream().findFirst().get();
        int size = firstPage.getNumberOfFacts();
        for (int i = 0; i < size; ++i) {
            String measureName = firstPage.getFactMeasureNames(i);
            if (measureName == null) continue;
            ITidyColumn tidyColumn = TidyTable.createTidyColumn(measureName, tidyTablePages, firstPage, i);
            this.columns.put(measureName, tidyColumn);
        }
        this.columnNames = new ArrayList<String>(this.columns.keySet());
    }

    @Override
    public int getColumnSize() {
        return this.columns.size();
    }

    @Override
    public ArrayList<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public ITidyColumn getColumn(String columnName) {
        return this.columns.get(columnName);
    }

    @Override
    public Stream<Map.Entry<String, ITidyColumn>> stream() {
        return this.columns.entrySet().stream();
    }

    @NotNull
    private static ITidyColumn createTidyColumn(String columnName, Map<N_FactPage, IntArrayList> tidyTablePages, N_FactPage firstPage, int i) {
        if (tidyTablePages.size() == 1) {
            return new TidyColumn(columnName, firstPage.getFacts(i), tidyTablePages.get(firstPage));
        }
        List<TidyColumn> tidyColumns = tidyTablePages.entrySet().stream().map(entry -> {
            N_FactPage page = (N_FactPage)entry.getKey();
            if (page.getMeasureGroupDef() != firstPage.getMeasureGroupDef()) {
                throw new CdShouldNotBeHereProgrammingException();
            }
            return new TidyColumn(columnName, page.getFacts(i), (IntArrayList)entry.getValue());
        }).toList();
        return new TidyColumnPaginated(tidyColumns);
    }
}

