/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar.tidy;

import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.entity.scalar.tidy.TidyColumn;
import crazydev.iccube.pub.olap.ITidyColumn;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class TidyColumnPaginated
implements ITidyColumn {
    private final List<TidyColumn> tidyColumns;
    private final int[] positions;
    private final int size;

    public TidyColumnPaginated(List<TidyColumn> tidyColumns) {
        this.positions = new int[tidyColumns.size()];
        this.tidyColumns = tidyColumns;
        int startPos = 0;
        for (int i = 0; i < tidyColumns.size(); ++i) {
            TidyColumn tidyColumn = tidyColumns.get(i);
            this.positions[i] = startPos += tidyColumn.size();
        }
        this.size = startPos;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Comparable get(int index) {
        Objects.checkIndex(index, this.size);
        int i = Arrays.binarySearch(this.positions, index);
        i = i >= 0 ? i : -i - 1;
        int startPos = i == 0 ? 0 : this.positions[i - 1];
        return this.tidyColumns.get(i).get(index - startPos);
    }

    @Override
    public OlapScalarEntityTidyType getType() {
        return this.tidyColumns.get(0).getType();
    }

    @Override
    public String getName() {
        return this.tidyColumns.get(0).getName();
    }

    @Override
    public String getCaption() {
        return this.tidyColumns.get(0).getCaption();
    }
}

