/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.iccube.olap.entity.scalar.OlapAbstractObjectEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class OlapWrappedEntity
extends OlapAbstractObjectEntity {
    public static final String FRIENDLY_NAME = "object-wrapper";
    public static int operatorIndex = OlapScalarOperators.createIndex(OlapWrappedEntity.class);
    private final Object value;

    public OlapWrappedEntity(Object value) {
        this.value = value;
    }

    @Override
    public String asString() {
        return String.valueOf(this.value);
    }

    @Override
    public Object asValue() {
        return this.value;
    }

    @Override
    public Class getUnderlyingJavaNativeValueType() {
        return Object.class;
    }

    @Override
    public boolean doIsConvertibleToJavaType(Class target) {
        return this.value.getClass().isAssignableFrom(target);
    }

    @Override
    public Object doAsJavaNativeValue(Class expectedClazz) {
        if (this.value.getClass().isAssignableFrom(expectedClazz)) {
            return this.value;
        }
        return null;
    }

    @Override
    public int getOperatorIndex() {
        return operatorIndex;
    }

    @Override
    public String javaFormat(GFCellPropertyEvalContext context, Locale locale, String pattern) {
        String formatted = String.format(locale, pattern, this.value);
        return formatted;
    }

    @Override
    public String excelFormat(GFCellPropertyEvalContext context, Locale locale, String format) {
        return this.toString();
    }

    @Override
    public Object toTidyTableValue() {
        return this.toString();
    }

    @Override
    @Nullable
    public Number toLatLongValue() {
        if (this.value instanceof Number) {
            Double n;
            if (this.value instanceof Double && (Double.isNaN(n = (Double)this.value) || Double.isInfinite(n))) {
                return null;
            }
            return (Number)this.value;
        }
        return null;
    }

    @Override
    public OlapScalarEntityTidyType toTidyTableValueType() {
        return OlapScalarEntityTidyType.CHARACTER;
    }

    @Override
    public OlapScalarEntity multiplyByZero() {
        if (this.value instanceof Number) {
            return new OlapNumericEntity(0.0);
        }
        return super.multiplyByZero();
    }

    @Override
    public boolean isZero() {
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue() == 0.0;
        }
        return super.isZero();
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    @Override
    public String toStringForDebugger() {
        return "object";
    }

    @Override
    public String toStringForDebuggerAsValue() {
        return String.valueOf(this.value);
    }

    @Override
    public OlapScalarEntity asConstant() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapWrappedEntity that = (OlapWrappedEntity)o;
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

