/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.exception.programming.CdNotImplementedProgrammingException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.lang.CdXmlaOptions;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.entity.scalar.tidy.TidyTable;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import crazydev.iccube.pub.olap.ITidyTable;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class OlapTableRowNumbersEntity
extends OlapAbstractScalarEntity<OlapTableRowNumbersEntity> {
    public static final String FRIENDLY_NAME = "TableRowNumbers";
    public static int operatorIndex = OlapScalarOperators.createIndex(OlapTableRowNumbersEntity.class);
    private final Map<N_FactPage, IntArrayList> tidyTablePages;

    public OlapTableRowNumbersEntity(Map<N_FactPage, IntArrayList> tidyTablePages) {
        this.tidyTablePages = tidyTablePages;
    }

    @Override
    public CdXmlaSchemaType getXmlaType(@Nullable CdXmlaOptions options) {
        return CdXmlaSchemaType.DBTYPE_WSTR;
    }

    @Override
    public String asXmlaString() {
        return this.toString();
    }

    @Override
    public String asString() {
        return this.toString();
    }

    @Override
    public Object asValue() {
        return this.tidyTablePages;
    }

    @Override
    public Class getUnderlyingJavaNativeValueType() {
        return OlapTableRowNumbersEntity.class;
    }

    @Override
    public int getOperatorIndex() {
        return operatorIndex;
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    @Override
    public OlapScalarEntity asConstant() {
        return this;
    }

    @Override
    public boolean isFormattingNumeric() {
        return super.isFormattingNumeric();
    }

    @Override
    protected boolean doIsConvertibleToJavaType(Class target) {
        return ITidyTable.class.equals((Object)target);
    }

    @Override
    @Nullable
    public Object doAsJavaNativeValue(Class<?> expectedClass) {
        if (ITidyTable.class.equals(expectedClass)) {
            return new TidyTable(this.tidyTablePages);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.tidyTablePages.hashCode();
    }

    @Override
    public Object toTidyTableValue() {
        throw new CdNotImplementedProgrammingException();
    }

    @Override
    @Nullable
    public Object toTidyTableValueEx() {
        return this.toString();
    }

    @Override
    public OlapScalarEntityTidyType toTidyTableValueType() {
        return OlapScalarEntityTidyType.CHARACTER;
    }

    @Override
    public String toString() {
        if (this.tidyTablePages.size() == 1) {
            IntArrayList rowNumbers = this.tidyTablePages.values().stream().findFirst().get();
            StringBuilder b = new StringBuilder("{");
            for (int i = 0; i < rowNumbers.size(); ++i) {
                b.append(i != 0 ? "," : "").append(rowNumbers.getInt(i));
            }
            b.append("}");
            return b.toString();
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    @Nullable
    public String javaFormat(GFCellPropertyEvalContext context, Locale locale, String pattern) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    @Nullable
    public String excelFormat(GFCellPropertyEvalContext context, Locale locale, String format) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public boolean hasSpecialFormatter() {
        return false;
    }

    @Override
    public String specialFormat(Locale locale, String formatString) {
        throw new CdNotImplementedProgrammingException();
    }

    @Override
    public OlapTableRowNumbersEntity aggregate(OlapMember[] members, OlapMember measure, OlapScalarEntity entity, OlapAggregationType aggregationType) {
        if (entity.isMdxNull()) {
            return this;
        }
        if (entity instanceof OlapTableRowNumbersEntity) {
            OlapTableRowNumbersEntity tidyTable = (OlapTableRowNumbersEntity)entity;
            Map<N_FactPage, IntArrayList> newMap = Stream.concat(tidyTable.tidyTablePages.entrySet().stream(), this.tidyTablePages.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
            return new OlapTableRowNumbersEntity(newMap);
        }
        throw new RuntimeException("internal error: inconsistent aggregation for NUMERIC entity [" + String.valueOf((Object)aggregationType) + "]");
    }
}

