/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapErrorEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;

public class OlapNumericWithUnitEntity
extends OlapNumericEntity {
    public static int operatorIndex = OlapScalarOperators.createIndex(OlapNumericWithUnitEntity.class);
    private final String unit;
    private final boolean errorOnMismatch;

    public OlapNumericWithUnitEntity(CdXmlaSchemaType kind, double value, boolean constant, String unit, boolean errorOnMismatch) {
        super(kind, value, constant);
        this.unit = unit == null ? "" : unit;
        this.errorOnMismatch = errorOnMismatch;
    }

    public OlapNumericWithUnitEntity(double value, String formattedValue, boolean errorOnMismatch) {
        this(DOUBLE_TYPE, value, true, formattedValue, errorOnMismatch);
    }

    @Override
    public int getOperatorIndex() {
        return operatorIndex;
    }

    public String getUnit() {
        return this.unit;
    }

    public OlapScalarEntity minus(OlapNumericWithUnitEntity other) {
        if (this.isMismatch(other)) {
            return this.onMismatch(other);
        }
        return super.sum(other);
    }

    public OlapScalarEntity sum(OlapNumericWithUnitEntity other) {
        if (this.isMismatch(other)) {
            return this.onMismatch(other);
        }
        return super.sum(other);
    }

    public OlapScalarEntity multiply(OlapNumericWithUnitEntity other) {
        return new OlapNumericEntity(DOUBLE_TYPE, other.value * this.value, false);
    }

    public OlapScalarEntity divide(OlapNumericWithUnitEntity other) {
        return new OlapNumericEntity(DOUBLE_TYPE, this.value / other.value, false);
    }

    private boolean isMismatch(OlapNumericWithUnitEntity other) {
        return !this.unit.equals(other.getUnit());
    }

    private OlapAbstractScalarEntity onMismatch(OlapNumericWithUnitEntity other) {
        if (this.errorOnMismatch) {
            return new OlapErrorEntity(new WrongUnits(this.unit, other.getUnit()));
        }
        return OlapEmptyEntity.INSTANCE;
    }

    @Override
    public OlapNumericEntity withNewValue(CdXmlaSchemaType kind, double value) {
        return new OlapNumericWithUnitEntity(kind, value, false, this.unit, this.errorOnMismatch);
    }

    @Override
    protected OlapScalarEntity doAsConstant() {
        return new OlapNumericWithUnitEntity(this.kind, this.value, true, this.unit, this.errorOnMismatch);
    }

    @Override
    protected String asFormatted(String formatted) {
        return formatted + " " + this.unit;
    }

    static class WrongUnits
    extends OlapException {
        protected WrongUnits(String u1, String u2) {
            super("Np matching units [" + u1 + "]/[" + u2 + "]");
        }
    }
}

