/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.collection.CdArrays;
import crazydev.common.math.CdIMatrix;
import crazydev.common.math.CdMatrixFactory;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapAbstractObjectEntity;
import crazydev.iccube.olap.entity.scalar.OlapBaseArrayEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleMatrixEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnSumDoubleAggregator;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.pub.olap.IOlapDoubleVector;
import crazydev.iccube.pub.olap.IOlapNumeric;
import crazydev.iccube.pub.olap.IOlapScalar;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.Arrays;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.apache.commons.math3.util.Precision;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OlapDoubleVectorEntity
extends OlapBaseArrayEntity
implements IOlapDoubleVector {
    public static final String FRIENDLY_NAME = "vector";
    protected static final OlapDoubleVectorEntity EMPTY = new OlapDoubleVectorEntity(new double[0]);
    public static int operatorIndex = OlapScalarOperators.createIndex(OlapDoubleVectorEntity.class);
    protected final double[] values;
    protected final boolean sorted;
    protected boolean constant;

    public OlapDoubleVectorEntity(double ... values) {
        this(values, false);
    }

    public OlapDoubleVectorEntity(double[] values, boolean sort) {
        this.values = values;
        this.sorted = sort;
        this.constant = false;
        if (sort) {
            Arrays.parallelSort(values);
        }
    }

    @Override
    public OlapScalarEntity asConstant() {
        this.constant = true;
        return this;
    }

    @Override
    public int length() {
        return this.values.length;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public String asString() {
        return Arrays.toString(this.values);
    }

    public double[] toTidyTableValue() {
        return this.values;
    }

    @Override
    public OlapScalarEntityTidyType toTidyTableValueType() {
        return OlapScalarEntityTidyType.LIST;
    }

    @Override
    @Nullable
    public OlapScalarEntityTidyType toTidyTableValueSubType() {
        return OlapScalarEntityTidyType.NUMERIC;
    }

    @Override
    public OlapScalarEntity multiplyByZero() {
        return this.newVectorEntity(new double[this.values.length], this.sorted);
    }

    @Override
    public boolean isZero() {
        for (double value : this.values) {
            if (value == 0.0) continue;
            return false;
        }
        return true;
    }

    public double[] asValue() {
        return this.values;
    }

    @Override
    public Class getUnderlyingJavaNativeValueType() {
        return double[].class;
    }

    protected int getSafePosition(double i) {
        int maxI = this.values.length - 1;
        return (int)(i <= 0.0 ? 0.0 : (i < 1.0 ? i * (double)(maxI + 1) - 1.0 : (i <= (double)maxI ? i : (double)maxI)));
    }

    protected int getSafeLength(double i) {
        int maxI = this.values.length;
        return (int)(i <= 0.0 ? 0.0 : (i < 1.0 ? i * (double)(maxI + 1) : (i <= (double)maxI ? i : (double)maxI)));
    }

    @Override
    public double value(int i) {
        return this.values[i];
    }

    public double get(double i) {
        if (i < 0.0) {
            return Double.NaN;
        }
        return this.values[this.getSafePosition(i)];
    }

    @Override
    public double corr(double[] other) {
        if (this.values.length < 2) {
            return 0.0;
        }
        return new PearsonsCorrelation().correlation(this.values, other);
    }

    @Override
    public int countEQ(double value) {
        int count = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (value != this.values[i]) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countGT(double value) {
        int count = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (!(this.values[i] > value)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countGE(double value) {
        int count = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (!(this.values[i] >= value)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countLE(double value) {
        int count = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (!(this.values[i] <= value)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countLT(double value) {
        int count = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (!(this.values[i] < value)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countNE(double value) {
        int count = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == value) continue;
            ++count;
        }
        return count;
    }

    @Override
    @Nullable
    public Double minGT(double cutoff) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.values.length; ++i) {
            double val = this.values[i];
            if (!(val > cutoff)) continue;
            min = Math.min(min, val);
        }
        return min == Double.MAX_VALUE ? null : Double.valueOf(min);
    }

    @Override
    public double cumSum() {
        double sum = 0.0;
        double cumValue = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            sum += (cumValue += this.values[i]);
        }
        return sum;
    }

    @Override
    public double mean() {
        return StatUtils.mean((double[])this.values);
    }

    @Override
    public double median() {
        return StatUtils.percentile((double[])this.values, (double)50.0);
    }

    @Override
    public double geometricMean() {
        return StatUtils.geometricMean((double[])this.values);
    }

    @Override
    public double max() {
        return StatUtils.max((double[])this.values);
    }

    @Override
    public double min() {
        return StatUtils.min((double[])this.values);
    }

    @Override
    public double percentile(double p) {
        return StatUtils.percentile((double[])this.values, (double)p);
    }

    @Override
    public double product() {
        return StatUtils.product((double[])this.values);
    }

    @Override
    public double sum() {
        return StatUtils.sum((double[])this.values);
    }

    @Override
    public double aggregate() {
        if (this.values.length == 0) {
            return 0.0;
        }
        OlapScalarEntityFactColumn.Aggregator na = OlapFactColumnSumDoubleAggregator.create();
        for (double value : this.values) {
            na.aggregate(value);
        }
        return na.asDoubleValue();
    }

    @Override
    public double sumHP() {
        if (this.values.length == 0) {
            return 0.0;
        }
        OlapScalarEntityFactColumn.Aggregator na = OlapFactColumnSumDoubleAggregator.createHP();
        for (double value : this.values) {
            na.aggregate(value);
        }
        return na.asDoubleValue();
    }

    @Override
    public double sumLog() {
        return StatUtils.sumLog((double[])this.values);
    }

    @Override
    public double sumSq() {
        return StatUtils.sumSq((double[])this.values);
    }

    @Override
    public double variance() {
        return StatUtils.variance((double[])this.values);
    }

    @Override
    public double stdev() {
        return Math.sqrt(StatUtils.variance((double[])this.values));
    }

    @Override
    public IOlapNumeric power(IOlapDoubleVector vector) {
        OlapDoubleVectorEntity vector_ = (OlapDoubleVectorEntity)vector;
        double res = 0.0;
        int length = vector_.values.length;
        for (int i = 0; i < this.values.length; ++i) {
            res += this.values[i] * vector_.values[i % length];
        }
        return new OlapNumericEntity(res);
    }

    @Override
    public double phist(Double start, Double stop) {
        int length = this.length();
        return length == 0 ? 0.0 : (double)this.hist(start, stop) / (double)length;
    }

    @Override
    public OlapDoubleVectorEntity unique() {
        double[] sortedV;
        if (!this.sorted) {
            sortedV = new double[this.values.length];
            System.arraycopy(this.values, 0, sortedV, 0, this.values.length);
            Arrays.parallelSort(sortedV);
        } else {
            sortedV = this.values;
        }
        DoubleArrayList list = new DoubleArrayList();
        double lastValue = Double.MAX_VALUE;
        for (int i = 0; i < sortedV.length; ++i) {
            double value = sortedV[i];
            if (lastValue != value || list.isEmpty()) {
                list.add(value);
            }
            lastValue = value;
        }
        return new OlapDoubleVectorEntity(list.toDoubleArray(), true);
    }

    @Override
    public OlapScalarEntity sumOn(@Nullable IOlapDoubleVector positions) {
        if (positions == null || positions.length() == 0) {
            return OlapEmptyEntity.INSTANCE;
        }
        OlapDoubleVectorEntity positions_ = (OlapDoubleVectorEntity)positions;
        double sum = 0.0;
        for (int i = 0; i < positions_.values.length; ++i) {
            int idx = (int)positions_.values[i];
            if (idx < 0 || idx >= this.values.length) continue;
            sum += this.values[idx];
        }
        return new OlapNumericEntity(sum);
    }

    @Override
    public int hist(Double start, Double stop) {
        int count = 0;
        for (double value : this.values) {
            if (start == null) {
                if (stop != null && !(value < stop)) continue;
                ++count;
                continue;
            }
            if (!(value >= start) || stop != null && !(value < stop)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public OlapDoubleVectorEntity histVectorII(int bucketCount) {
        double min = this.min();
        double max = this.max();
        return this.histVector(bucketCount, (max - min) / (double)bucketCount, min, true);
    }

    @Override
    public OlapDoubleVectorEntity histVector(double bucketSize) {
        return this.histVector(bucketSize, this.min());
    }

    @Override
    public OlapDoubleVectorEntity histVector(double bucketSize, double start) {
        int countBuckets = (int)Math.ceil((bucketSize > 0.0 ? this.min() - start : this.max() - start) / bucketSize);
        return this.histVector(countBuckets, bucketSize, start, true);
    }

    @Override
    public OlapDoubleVectorEntity histVector(int countBuckets, double bucketSize, double start, boolean overflowToLast) {
        if (this.values.length == 0) {
            return new OlapDoubleVectorEntity(new double[0]);
        }
        double[] newArray = new double[countBuckets];
        for (int i = 0; i < this.values.length; ++i) {
            double value = this.values[i];
            int bucket = (int)Math.floor((value - start) / bucketSize);
            if (bucket < 0 || !overflowToLast && bucket > countBuckets) continue;
            int n = Math.min(bucket, countBuckets - 1);
            newArray[n] = newArray[n] + 1.0;
        }
        return new OlapDoubleVectorEntity(newArray);
    }

    @Override
    public double norm() {
        return Math.sqrt(StatUtils.sumSq((double[])this.values));
    }

    @Override
    public OlapDoubleVectorEntity sort() {
        if (this.sorted) {
            return this;
        }
        if (this.constant) {
            return this.copy().sort();
        }
        Arrays.sort(this.values);
        return this;
    }

    @Override
    public OlapDoubleVectorEntity parallelSort() {
        if (this.sorted) {
            return this;
        }
        if (this.constant) {
            return this.copy().parallelSort();
        }
        Arrays.parallelSort(this.values);
        return this;
    }

    @Override
    public OlapDoubleVectorEntity copy() {
        double[] nvalues = new double[this.values.length];
        System.arraycopy(this.values, 0, nvalues, 0, this.values.length);
        OlapDoubleVectorEntity vector = this.newVectorEntity(nvalues, this.sorted);
        return vector;
    }

    @Override
    public OlapDoubleVectorEntity fft() {
        FastFourierTransformer fft = new FastFourierTransformer(DftNormalization.STANDARD);
        Complex[] ret = fft.transform(this.values, TransformType.FORWARD);
        double[] newArray = new double[ret.length];
        for (int i = 0; i < this.values.length; ++i) {
            newArray[this.values.length - 1 - i] = ret[i].abs();
        }
        return new OlapDoubleVectorEntity(newArray, this.sorted);
    }

    @Override
    public double first() {
        return this.values.length > 0 ? this.values[0] : Double.NaN;
    }

    @Override
    public double last() {
        return this.values.length > 0 ? this.values[this.values.length - 1] : Double.NaN;
    }

    @Override
    public OlapDoubleVectorEntity head(double newSizeD) {
        if (newSizeD >= (double)this.values.length) {
            return this;
        }
        if (newSizeD <= 0.0) {
            return EMPTY;
        }
        int newSize = this.getSafeLength(newSizeD);
        double[] newArray = new double[newSize];
        System.arraycopy(this.values, 0, newArray, 0, newSize);
        return new OlapDoubleVectorEntity(newArray, this.sorted);
    }

    @Override
    public OlapDoubleVectorEntity tail(double newSizeD) {
        if (newSizeD >= (double)this.values.length) {
            return this;
        }
        if (newSizeD <= 0.0) {
            return EMPTY;
        }
        int newSize = this.getSafeLength(newSizeD);
        double[] newArray = new double[newSize];
        System.arraycopy(this.values, this.values.length - newSize, newArray, 0, newSize);
        return new OlapDoubleVectorEntity(newArray, this.sorted);
    }

    @Override
    public boolean doIsConvertibleToJavaType(Class target) {
        if (IOlapDoubleVector.class.equals((Object)target)) {
            return true;
        }
        return double[].class.equals((Object)target);
    }

    @Override
    public Object doAsJavaNativeValue(Class expectedClazz) {
        if (IOlapDoubleVector.class.equals((Object)expectedClazz)) {
            return this;
        }
        if (double[].class == expectedClazz) {
            return this.asValue();
        }
        return null;
    }

    @Override
    public int getOperatorIndex() {
        return operatorIndex;
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    protected OlapDoubleVectorEntity newVectorEntity(double[] newArray, boolean sorted) {
        return new OlapDoubleVectorEntity(newArray, sorted);
    }

    @Override
    public OlapScalarEntity asInitialValueFor(OlapMember[] members, OlapMember measure, OlapAggregationType aggregationType) {
        if (aggregationType.isVector()) {
            return this;
        }
        return super.asInitialValueFor(members, measure, aggregationType);
    }

    @Override
    public OlapAbstractObjectEntity aggregate(OlapMember[] members, OlapMember measure, OlapScalarEntity entity, OlapAggregationType aggregationType) {
        if (aggregationType.isVector() && entity instanceof OlapDoubleVectorEntity) {
            OlapDoubleVectorEntity vectorEntity = (OlapDoubleVectorEntity)entity;
            double[] nvalues = new double[this.values.length + vectorEntity.values.length];
            System.arraycopy(this.values, 0, nvalues, 0, this.values.length);
            System.arraycopy(vectorEntity.values, 0, nvalues, this.values.length, vectorEntity.values.length);
            return new OlapDoubleVectorEntity(nvalues, this.sorted);
        }
        return (OlapAbstractObjectEntity)super.aggregate(members, measure, entity, aggregationType);
    }

    @Override
    public String toStringForDebugger() {
        return FRIENDLY_NAME;
    }

    @Override
    public String toStringForDebuggerAsValue() {
        return CdArrays.toString((double[])this.values, (int)1024);
    }

    @Override
    public OlapDoubleVectorEntity cumulative() {
        if (this.constant) {
            return this.copy().cumulative();
        }
        double sum = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = sum += this.values[i];
        }
        return this;
    }

    @Override
    public OlapDoubleVectorEntity round(int precision) {
        if (this.constant) {
            return this.copy().round(precision);
        }
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Precision.round((double)this.values[i], (int)precision) + 0.0;
        }
        return this;
    }

    @Override
    public OlapDoubleVectorEntity pMin(double[] other) {
        if (this.constant) {
            return this.copy().pMin(other);
        }
        int oLength = other.length - 1;
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Math.min(this.values[i], other[Math.min(i, oLength)]);
        }
        return this;
    }

    @Override
    public OlapDoubleVectorEntity pMax(double[] other) {
        if (this.constant) {
            return this.copy().pMax(other);
        }
        int oLength = other.length - 1;
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Math.max(this.values[i], other[Math.min(i, oLength)]);
        }
        return this;
    }

    @Override
    public OlapDoubleVectorEntity pDif(double[] other) {
        if (this.constant) {
            return this.copy().pDif(other);
        }
        int oLength = other.length - 1;
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Math.abs(this.values[i] - other[Math.min(i, oLength)]);
        }
        return this;
    }

    @Override
    public OlapDoubleVectorEntity pAbs() {
        if (this.constant) {
            return this.copy().pAbs();
        }
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Math.abs(this.values[i]);
        }
        return this;
    }

    @Override
    public OlapDoubleVectorEntity scale() {
        if (this.constant) {
            return this.copy().scale();
        }
        if (this.values.length == 0) {
            return this;
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.values.length; ++i) {
            double value = this.values[i];
            min = Math.min(value, min);
            max = Math.max(value, max);
        }
        double scale = max - min;
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = (this.values[i] - min) / scale;
        }
        return this;
    }

    @Override
    public OlapDoubleVectorEntity divide(Double value) {
        if (value == null) {
            value = 0.0;
        }
        if (this.constant) {
            return this.copy().divide(value);
        }
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] / value;
        }
        return this;
    }

    public OlapDoubleVectorEntity divide(OlapNumericEntity num) {
        return this.divide(num.value());
    }

    @Override
    public OlapDoubleVectorEntity divide(IOlapDoubleVector vector) {
        if (this.constant) {
            return this.copy().divide(vector);
        }
        OlapDoubleVectorEntity vector_ = (OlapDoubleVectorEntity)vector;
        int length = vector_.values.length;
        for (int i = 0; i < this.values.length; ++i) {
            int n = i;
            this.values[n] = this.values[n] / vector_.values[i % length];
        }
        return this;
    }

    @Override
    public OlapScalarEntity multiply(Double value) {
        if (value == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        if (this.constant) {
            return this.copy().multiply(value);
        }
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] * value;
        }
        return this;
    }

    public OlapDoubleVectorEntity multiply(OlapNumericEntity num) {
        return (OlapDoubleVectorEntity)this.multiply(num.value());
    }

    @Override
    public OlapDoubleVectorEntity multiply(IOlapDoubleVector vector) {
        if (this.constant) {
            return this.copy().multiply(vector);
        }
        OlapDoubleVectorEntity vector_ = (OlapDoubleVectorEntity)vector;
        int length = vector_.values.length;
        for (int i = 0; i < this.values.length; ++i) {
            int n = i;
            this.values[n] = this.values[n] * vector_.values[i % length];
        }
        return this;
    }

    @Override
    public OlapScalarEntity power(Double value) {
        if (value == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        if (this.constant) {
            return this.copy().power(value);
        }
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Math.pow(this.values[i], value);
        }
        return this;
    }

    public OlapDoubleVectorEntity power(OlapNumericEntity num) {
        return (OlapDoubleVectorEntity)this.power(num.value());
    }

    @Override
    public OlapDoubleVectorEntity sum(Double value) {
        if (value == null) {
            return this;
        }
        if (this.constant) {
            return this.copy().sum(value);
        }
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] + value;
        }
        return this;
    }

    public OlapDoubleVectorEntity sum(OlapNumericEntity num) {
        return this.sum(num.value());
    }

    @Override
    public OlapDoubleVectorEntity sum(IOlapDoubleVector vector) {
        if (this.constant) {
            return this.copy().sum(vector);
        }
        OlapDoubleVectorEntity vector_ = (OlapDoubleVectorEntity)vector;
        int length = vector_.values.length;
        for (int i = 0; i < this.values.length; ++i) {
            int n = i;
            this.values[n] = this.values[n] + vector_.values[i % length];
        }
        return this;
    }

    @Override
    public OlapDoubleVectorEntity minus(Double value) {
        if (value == null) {
            return this;
        }
        if (this.constant) {
            return this.copy().minus(value);
        }
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] - value;
        }
        return this;
    }

    public OlapDoubleVectorEntity minus(OlapNumericEntity num) {
        return this.minus(num.value());
    }

    @Override
    public OlapDoubleVectorEntity minus(IOlapDoubleVector vector) {
        if (this.constant) {
            return this.copy().minus(vector);
        }
        OlapDoubleVectorEntity vector_ = (OlapDoubleVectorEntity)vector;
        int length = vector_.values.length;
        for (int i = 0; i < this.values.length; ++i) {
            int n = i;
            this.values[n] = this.values[n] - vector_.values[i % length];
        }
        return this;
    }

    @Override
    public OlapDoubleVectorEntity unaryMinus() {
        if (this.constant) {
            return this.copy().unaryMinus();
        }
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = -this.values[i];
        }
        return this;
    }

    @Override
    public OlapDoubleVectorEntity reverse() {
        if (this.constant) {
            return this.copy().reverse();
        }
        if (this.values.length == 0) {
            return this;
        }
        int j = this.values.length - 1;
        int end = this.values.length / 2;
        int i = 0;
        while (i < end) {
            double temp = this.values[i];
            this.values[i] = this.values[j];
            this.values[j] = temp;
            ++i;
            --j;
        }
        return this;
    }

    @Override
    public OlapScalarEntity setMinus(IOlapDoubleVector vectorEntity) {
        OlapDoubleVectorEntity vectorEntity_ = (OlapDoubleVectorEntity)vectorEntity;
        double[] newValues = Arrays.stream(this.values).filter(i -> vectorEntity_.indexOf(i) < 0).toArray();
        if (newValues == null || newValues.length == 0) {
            return OlapEmptyEntity.INSTANCE;
        }
        return this.newVectorEntity(newValues, this.sorted);
    }

    @Override
    public OlapDoubleVectorEntity setUnion(IOlapDoubleVector vectorEntity) {
        OlapDoubleVectorEntity vectorEntity_ = (OlapDoubleVectorEntity)vectorEntity;
        double[] newValues = new double[this.length() + vectorEntity.length()];
        System.arraycopy(this.values, 0, newValues, 0, this.length());
        System.arraycopy(vectorEntity_.values, 0, newValues, this.length(), vectorEntity.length());
        OlapDoubleVectorEntity newVector = this.newVectorEntity(newValues, false);
        return newVector;
    }

    @Override
    public OlapScalarEntity setIntersect(IOlapDoubleVector vectorEntity) {
        OlapDoubleVectorEntity vectorEntity_ = (OlapDoubleVectorEntity)vectorEntity;
        double[] newValues = Arrays.stream(this.values).filter(i -> vectorEntity_.indexOf(i) >= 0).toArray();
        if (newValues == null || newValues.length == 0) {
            return OlapEmptyEntity.INSTANCE;
        }
        return this.newVectorEntity(newValues, this.sorted);
    }

    @Override
    public IOlapScalar toMatrix(int cols) {
        CdIMatrix cdIMatrix = CdMatrixFactory.create((double[])this.values, (int)cols);
        return new OlapDoubleMatrixEntity(cdIMatrix);
    }

    public boolean contains(Double value) {
        if (value == null) {
            return false;
        }
        return this.indexOf(value) != -1;
    }

    public int indexOf(Double value) {
        if (value == null) {
            return -1;
        }
        if (this.sorted) {
            int pos = Arrays.binarySearch(this.values, value);
            return pos < 0 ? -1 : pos;
        }
        return CdArrays.indexOf((double[])this.values, (double)value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapDoubleVectorEntity that = (OlapDoubleVectorEntity)o;
        return Arrays.equals(this.values, that.values);
    }

    @NotNull
    public String doFormat(String prefix, String suffix, String delimiter) {
        return this.doFormat(prefix, suffix, delimiter, -1, -1);
    }

    @NotNull
    public String doFormat(String prefix, String suffix, String delimiter, int limitCount, int limitSizeKb) {
        int size = limitCount == -1 ? this.values.length : Math.min(this.values.length, limitCount);
        return OlapDoubleVectorEntity._doFormat(size, i -> Double.toString(this.values[i]), prefix, suffix, delimiter, limitSizeKb);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }
}

