/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDoubleVectorAEntity
extends OlapDoubleVectorEntity {
    public static final String FRIENDLY_NAME = "VectorA";
    private OlapListTupleSet<? extends OlapTuple> rowList;

    public OlapDoubleVectorAEntity(OlapListTupleSet<? extends OlapTuple> rowList, double ... values) {
        this(rowList, values, false);
    }

    public OlapDoubleVectorAEntity(OlapListTupleSet<? extends OlapTuple> rowList, double[] values, boolean sorted) {
        super(values, sorted);
        this.rowList = rowList;
    }

    public OlapDoubleVectorAEntity(OlapListTupleSet<?> rowList, OlapDoubleVectorEntity vectorEntity) {
        this(rowList, vectorEntity.asValue());
    }

    public List<OlapTuple> getAxisList(int axis) {
        switch (axis) {
            case 0: {
                return this.rowList.getTuples();
            }
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    public OlapEntity axis(int axis) {
        switch (axis) {
            case 0: {
                return this.rowList.asTupleList();
            }
        }
        return OlapEmptyEntity.INSTANCE;
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    @Override
    protected OlapDoubleVectorAEntity newVectorEntity(double[] values, boolean sorted) {
        return new OlapDoubleVectorAEntity(this.rowList, values, sorted);
    }

    @Override
    public OlapDoubleVectorEntity sort() {
        throw new CdShouldNotBeHereProgrammingException("VectorA con not be sorted");
    }

    @Override
    public OlapDoubleVectorEntity parallelSort() {
        throw new CdShouldNotBeHereProgrammingException("VectorA con not be sorted");
    }

    public OlapScalarEntity getElementValue(@Nullable OlapTuple completeTuple) {
        if (completeTuple == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        int rowIdx = OlapDoubleVectorAEntity.getIndex(completeTuple, this.rowList, null);
        if (rowIdx == -1) {
            return OlapEmptyEntity.INSTANCE;
        }
        return new OlapNumericEntity(this.value(rowIdx));
    }

    private static int getIndex(OlapTuple completeTuple, OlapListTupleSet<? extends OlapTuple> list, @Nullable OlapBitSet bitSet) {
        for (int i = 0; i < list.size(); ++i) {
            OlapTuple tuple = list.getItem(i);
            if (!completeTuple.inSubTuple(tuple, bitSet)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public OlapDoubleVectorEntity reverse() {
        if (this.values.length == 0) {
            return this;
        }
        double[] newArray = new double[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            newArray[this.values.length - 1 - i] = this.values[i];
        }
        OlapListTupleSet<OlapTuple> reverseList = OlapSetFactory.instance(OlapIteratorFactory.reverse(this.rowList)).asTupleList();
        return new OlapDoubleVectorAEntity(reverseList, newArray, this.sorted);
    }

    @Override
    public OlapDoubleVectorEntity head(double newSizeD) {
        if (newSizeD >= (double)this.values.length) {
            return this;
        }
        if (newSizeD <= 0.0) {
            return EMPTY;
        }
        int newSize = this.getSafeLength(newSizeD);
        double[] newArray = new double[newSize];
        System.arraycopy(this.values, 0, newArray, 0, newSize);
        return new OlapDoubleVectorAEntity(this.rowList.head(newSize).asTupleList(), newArray, this.sorted);
    }

    @Override
    public OlapDoubleVectorEntity tail(double newSizeD) {
        if (newSizeD >= (double)this.values.length) {
            return this;
        }
        if (newSizeD <= 0.0) {
            return EMPTY;
        }
        int newSize = this.getSafeLength(newSizeD);
        double[] newArray = new double[newSize];
        System.arraycopy(this.values, this.values.length - newSize, newArray, 0, newSize);
        return new OlapDoubleVectorAEntity(this.rowList.tail(newSize).asTupleList(), newArray, this.sorted);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OlapDoubleVectorAEntity that = (OlapDoubleVectorAEntity)o;
        return this.rowList != null ? this.rowList.equals(that.rowList) : that.rowList == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.rowList != null ? this.rowList.hashCode() : 0);
        return result;
    }
}

