/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.math.CdIMatrix;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleMatrixEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorAEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDoubleMatrixAEntity
extends OlapDoubleMatrixEntity {
    public static final String FRIENDLY_NAME = "MatrixA";
    private final OlapListTupleSet<? extends OlapTuple> colList;
    private final OlapListTupleSet<? extends OlapTuple> rowList;

    public OlapDoubleMatrixAEntity(OlapListTupleSet<?> colList, OlapListTupleSet<?> rowList, OlapDoubleMatrixEntity matrix) {
        this(colList, rowList, matrix.asValue());
    }

    public OlapDoubleMatrixAEntity(OlapListTupleSet<? extends OlapTuple> colList, OlapListTupleSet<? extends OlapTuple> rowList, CdIMatrix matrix) {
        super(matrix);
        this.colList = colList;
        this.rowList = rowList;
    }

    @Override
    @Nullable
    public OlapDoubleMatrixEntity inverse() {
        OlapDoubleMatrixEntity matrix = super.inverse();
        return new OlapDoubleMatrixAEntity(this.rowList, this.colList, matrix.asValue());
    }

    @Override
    public OlapDoubleMatrixEntity multiply(OlapDoubleMatrixEntity matrixEntity) {
        CdIMatrix matrixMult = this.matrix.multiply(matrixEntity.matrix);
        if (matrixEntity instanceof OlapDoubleMatrixAEntity) {
            OlapDoubleMatrixAEntity aEntity = (OlapDoubleMatrixAEntity)matrixEntity;
            return new OlapDoubleMatrixAEntity(aEntity.colList, this.rowList, matrixMult);
        }
        return this.newMatrixEntity(matrixMult);
    }

    public List<OlapTuple> getAxisList(int axis) {
        switch (axis) {
            case 0: {
                return this.colList.getTuples();
            }
            case 1: {
                return this.rowList.getTuples();
            }
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    public OlapEntity axis(int axis) {
        switch (axis) {
            case 0: {
                return this.colList;
            }
            case 1: {
                return this.rowList;
            }
        }
        return OlapEmptyEntity.INSTANCE;
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    @Override
    protected OlapDoubleMatrixEntity newMatrixEntity(CdIMatrix cdIMatrix) {
        return new OlapDoubleMatrixAEntity(this.colList, this.rowList, cdIMatrix);
    }

    @Override
    protected OlapDoubleVectorEntity newRowsVector(double[] solution) {
        return new OlapDoubleVectorAEntity(this.rowList, solution);
    }

    public OlapScalarEntity getElementValue(@Nullable OlapTuple completeTuple) {
        int rowIdx;
        OlapTupleDimensionality colDimensionality;
        if (completeTuple == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        int colIdx = OlapDoubleMatrixAEntity.getIndex(completeTuple, this.colList, null);
        if (colIdx == -1) {
            return OlapEmptyEntity.INSTANCE;
        }
        OlapBitSet bitSet = null;
        OlapTupleDimensionality rowDimensionality = this.rowList.getItem(0).getTupleDimensionality();
        if (rowDimensionality.intersects(colDimensionality = this.colList.getItem(0).getTupleDimensionality())) {
            bitSet = rowDimensionality.andBitSet(colDimensionality);
        }
        if ((rowIdx = OlapDoubleMatrixAEntity.getIndex(completeTuple, this.rowList, bitSet)) == -1) {
            return OlapEmptyEntity.INSTANCE;
        }
        return new OlapNumericEntity(this.value(colIdx, rowIdx));
    }

    private static int getIndex(OlapTuple completeTuple, OlapListTupleSet<? extends OlapTuple> list, @Nullable OlapBitSet bitSet) {
        for (int i = 0; i < list.size(); ++i) {
            OlapTuple tuple = list.getItem(i);
            if (!completeTuple.inSubTuple(tuple, bitSet)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OlapDoubleMatrixAEntity that = (OlapDoubleMatrixAEntity)o;
        if (!this.colList.equals(that.colList)) {
            return false;
        }
        return this.rowList.equals(that.rowList);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.colList.hashCode();
        result = 31 * result + this.rowList.hashCode();
        return result;
    }
}

