/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.collection.CdPaginatedSortedList;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.IAggregationScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import crazydev.iccube.request.request.IcCubeRequest;
import org.jetbrains.annotations.Nullable;

public class OlapCountUniqueAggrEntity
extends OlapNumericEntity
implements IAggregationScalarEntity {
    private static final long serialVersionUID = -5375690270346985320L;
    @Nullable
    private final CdPaginatedSortedList<OlapScalarEntity> sortedList;

    public OlapCountUniqueAggrEntity(OlapAbstractScalarEntity entity) {
        super(0L, false);
        this.sortedList = new CdPaginatedSortedList(OlapScalarOperators.COMPARATOR_FOR_UNIQUE);
        this.aggregate(null, null, entity, OlapAggregationType.DISTINCT_COUNT);
    }

    public OlapCountUniqueAggrEntity(CdXmlaSchemaType kind, double value, boolean constant) {
        super(kind, value, constant);
        this.sortedList = !constant ? new CdPaginatedSortedList(OlapScalarOperators.COMPARATOR_FOR_UNIQUE) : null;
    }

    @Override
    public OlapScalarEntity asNonAggregating(boolean constant) {
        return new OlapNumericEntity(this.kind, this.value, constant);
    }

    @Override
    protected OlapScalarEntity doAsConstant() {
        if (this.constant) {
            return this;
        }
        return new OlapCountUniqueAggrEntity(this.kind, this.value, true);
    }

    @Override
    public OlapNumericEntity aggregate(OlapMember[] members, OlapMember measure, OlapScalarEntity entity, OlapAggregationType aggregationType) {
        if (entity.isMdxNull()) {
            return this;
        }
        switch (aggregationType) {
            case DISTINCT_COUNT: {
                IcCubeRequest.assertNotCancelled("count-unique-aggr-entity");
                if (!this.constant) {
                    this.sortedList.addIfMissing((Object)entity);
                    this.value = this.sortedList.size();
                    return this;
                }
                throw new RuntimeException("internal error: inconsistent aggregation for CONSTANT UNIQUE COUNTING entity");
            }
        }
        throw new RuntimeException("internal error: inconsistent aggregation for UNIQUE COUNTING entity [" + String.valueOf((Object)aggregationType) + "]");
    }

    @Override
    public String toStringForDebugger() {
        return "DISTINCT_COUNT: " + this.value;
    }
}

