/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import com.google.gson.Gson;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.lang.CdXmlaOptions;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.common.utils.CdClassUtils;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleMatrixEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import crazydev.iccube.pub.olap.IOlapComparableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OlapComparableVectorEntity
extends OlapAbstractScalarEntity<OlapComparableVectorEntity>
implements IOlapComparableList {
    public static final String FRIENDLY_NAME = "ComparableVector";
    public static int SMALL_CONTENT_MAX_SIZE = 128;
    public static int operatorIndex = OlapScalarOperators.createIndex(OlapDoubleMatrixEntity.class);
    private final List<Comparable> values;
    private final boolean isConstant;
    public static final Comparator<Comparable> NATURAL_COMPARATOR_WITH_NULLS = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return Comparator.naturalOrder().compare((Comparable)o1, (Comparable)o2);
    };

    public OlapComparableVectorEntity(Comparable ... values) {
        this.values = Arrays.asList(values);
        this.isConstant = true;
    }

    public OlapComparableVectorEntity(List<Comparable> values, boolean isConstant) {
        this.isConstant = isConstant;
        this.values = values;
    }

    public Class getVectorType() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.get(0).getClass();
    }

    @Override
    public CdXmlaSchemaType getXmlaType(@Nullable CdXmlaOptions options) {
        return CdXmlaSchemaType.DBTYPE_WSTR;
    }

    @Override
    public String asXmlaString() {
        return this.doFormat("", "", ", ", -1, 1000);
    }

    @Override
    public String asString() {
        return this.asSmallContent();
    }

    @Override
    public Object asValue() {
        return this.values;
    }

    @Override
    public Class getUnderlyingJavaNativeValueType() {
        return ArrayList.class;
    }

    @Override
    public int getOperatorIndex() {
        return operatorIndex;
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    @Override
    public OlapScalarEntity asConstant() {
        return new OlapComparableVectorEntity(new ArrayList<Comparable>(this.values), true);
    }

    public OlapComparableVectorEntity filterNulls() {
        for (int i = 0; i < this.values.size(); ++i) {
            Comparable comparable = this.values.get(i);
            if (comparable != null) continue;
            return new OlapComparableVectorEntity(this.values.stream().filter(Objects::nonNull).toList(), this.isConstant);
        }
        return this;
    }

    @Override
    protected boolean doIsConvertibleToJavaType(Class target) {
        if (IOlapComparableList.class.equals((Object)target)) {
            return true;
        }
        return target == List.class || target == ArrayList.class;
    }

    @Override
    @Nullable
    public Object doAsJavaNativeValue(Class<?> expectedClass) {
        if (IOlapComparableList.class.equals(expectedClass)) {
            return this;
        }
        if (expectedClass == List.class || expectedClass == ArrayList.class) {
            return this.values;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapComparableVectorEntity that = (OlapComparableVectorEntity)o;
        return this.values.equals(that.values);
    }

    @Override
    public List<Comparable> toTidyTableValue() {
        return this.values;
    }

    @Override
    public OlapScalarEntityTidyType toTidyTableValueType() {
        return OlapScalarEntityTidyType.LIST;
    }

    @Override
    @Nullable
    public OlapScalarEntityTidyType toTidyTableValueSubType() {
        OlapScalarEntityTidyType type = null;
        for (Comparable value : this.values) {
            if (value == null) continue;
            if (value instanceof String) {
                if (type == OlapScalarEntityTidyType.CHARACTER || type == null) {
                    type = OlapScalarEntityTidyType.CHARACTER;
                    continue;
                }
                type = OlapScalarEntityTidyType.MIXED;
                continue;
            }
            if (!(value instanceof Number)) continue;
            if (type == OlapScalarEntityTidyType.NUMERIC || type == null) {
                type = OlapScalarEntityTidyType.NUMERIC;
                continue;
            }
            type = OlapScalarEntityTidyType.MIXED;
        }
        return type;
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public String toString() {
        return this.asSmallContent();
    }

    @Override
    @Nullable
    public String javaFormat(GFCellPropertyEvalContext context, Locale locale, String pattern) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    @Nullable
    public String excelFormat(GFCellPropertyEvalContext context, Locale locale, String format) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public boolean hasSpecialFormatter() {
        return true;
    }

    @Override
    public String specialFormat(Locale locale, String formatString) {
        if (formatString.equalsIgnoreCase("json")) {
            return new Gson().toJson(this.values);
        }
        String prefix = "";
        String suffix = "";
        String delimiter = ",";
        int limitCount = -1;
        int limitSize = 10;
        if (formatString.length() == 1) {
            delimiter = formatString;
        }
        return this.doFormat("", "", delimiter, -1, 10);
    }

    @NotNull
    public String doFormat(String prefix, String suffix, String delimiter) {
        return this.doFormat(prefix, suffix, delimiter, -1, -1);
    }

    @NotNull
    public String doFormat(String prefix, String suffix, String delimiter, int limitCount, int limitSizeKb) {
        int size = limitCount == -1 ? this.values.size() : Math.min(this.values.size(), limitCount);
        return OlapComparableVectorEntity._doFormat(size, i -> String.valueOf(this.values.get(i)), prefix, suffix, delimiter, limitSizeKb);
    }

    private String asSmallContent() {
        if (this.values.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < this.values.size(); ++i) {
            builder.append(i == 0 ? "" : ", ").append(this.values.get(i));
            if (builder.length() <= SMALL_CONTENT_MAX_SIZE) continue;
            builder.delete(SMALL_CONTENT_MAX_SIZE, builder.length());
            builder.append("...");
            break;
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public OlapComparableVectorEntity aggregate(OlapMember[] members, OlapMember measure, OlapScalarEntity entity, OlapAggregationType aggregationType) {
        if (entity.isMdxNull()) {
            return this;
        }
        if (aggregationType == OlapAggregationType.VECTOR) {
            if (entity instanceof OlapComparableVectorEntity) {
                OlapComparableVectorEntity vectorEntity = (OlapComparableVectorEntity)entity;
                return this.sum(vectorEntity);
            }
            throw new OlapEvaluationException(IOlapEvaluationExceptionContext.NULL, OlapErrorCode.TYPE_MISMATCH, new Serializable[]{"numeric", entity.getFriendlyTypeName()});
        }
        if (aggregationType == OlapAggregationType.VECTOR_SORTED) {
            if (entity instanceof OlapComparableVectorEntity) {
                OlapComparableVectorEntity vectorEntity = (OlapComparableVectorEntity)entity;
                return this.sum(vectorEntity).sort();
            }
            throw new OlapEvaluationException(IOlapEvaluationExceptionContext.NULL, OlapErrorCode.TYPE_MISMATCH, new Serializable[]{"numeric", entity.getFriendlyTypeName()});
        }
        if (aggregationType == OlapAggregationType.VECTOR_UNIQUE) {
            if (entity instanceof OlapComparableVectorEntity) {
                OlapComparableVectorEntity vectorEntity = (OlapComparableVectorEntity)entity;
                return this.sum(vectorEntity).unique();
            }
            throw new OlapEvaluationException(IOlapEvaluationExceptionContext.NULL, OlapErrorCode.TYPE_MISMATCH, new Serializable[]{"numeric", entity.getFriendlyTypeName()});
        }
        throw new RuntimeException("internal error: inconsistent aggregation for NUMERIC entity [" + String.valueOf((Object)aggregationType) + "]");
    }

    public int count() {
        return this.values.size();
    }

    public boolean contains(Comparable value) {
        return this.values.contains(value);
    }

    public boolean contains(OlapStringEntity value) {
        return this.values.contains(value.value());
    }

    public boolean contains(OlapComparableVectorEntity ent2) {
        for (Comparable value2 : ent2.values) {
            if (this.values.contains(value2)) continue;
            return false;
        }
        return true;
    }

    public OlapComparableVectorEntity unique() {
        List<Comparable> unique = this.values.stream().distinct().sorted(NATURAL_COMPARATOR_WITH_NULLS).collect(Collectors.toList());
        return new OlapComparableVectorEntity(unique, false);
    }

    public OlapComparableVectorEntity sort() {
        OlapComparableVectorEntity that = this.asNew();
        that.values.sort(NATURAL_COMPARATOR_WITH_NULLS);
        return this;
    }

    public OlapComparableVectorEntity union(OlapComparableVectorEntity entity) {
        return this.sum(entity);
    }

    public OlapComparableVectorEntity sum(OlapComparableVectorEntity entity) {
        OlapComparableVectorEntity that = this.asNew();
        that.values.addAll(entity.values);
        return that;
    }

    public OlapComparableVectorEntity sum(OlapStringEntity entity) {
        OlapComparableVectorEntity that = this.asNew();
        that.values.add((Comparable)((Object)entity.toString()));
        return that;
    }

    private OlapComparableVectorEntity asNew() {
        if (this.isConstant) {
            return new OlapComparableVectorEntity(new ArrayList<Comparable>(this.values), false);
        }
        return this;
    }

    public int compare(OlapComparableVectorEntity ent2) {
        if (this == ent2 || this.values == ent2.values) {
            return 0;
        }
        int comp = Integer.compare(this.values.size(), ent2.values.size());
        if (comp != 0) {
            return comp;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            Comparable thatValue;
            Comparable thisValue = this.values.get(i);
            comp = thisValue.compareTo(thatValue = ent2.values.get(i));
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    public OlapScalarEntity intersectRows(OlapComparableVectorEntity ent2) {
        if (this.size() == 0 || ent2.size() == 0) {
            return OlapEmptyEntity.INSTANCE;
        }
        if (!(this.values.get(0) instanceof String) && !(ent2.get(0) instanceof String)) {
            return this.intersect(ent2);
        }
        Map<String, Integer> ent2Partitions = this.getPartitionPos(ent2);
        OlapComparableVectorEntity that = new OlapComparableVectorEntity(new ArrayList<Comparable>(), true);
        for (int i = 0; i < this.values.size(); ++i) {
            String partition;
            Integer pos;
            Comparable comparable = this.values.get(i);
            if (!(comparable instanceof String) || (pos = ent2Partitions.get(partition = (String)((Object)comparable))) == null) continue;
            OlapComparableVectorEntity.intersectsAllSpecial(that.values, this.values, i + 1, ent2.values, pos + 1);
        }
        return that.values.isEmpty() ? OlapEmptyEntity.INSTANCE : that;
    }

    private static void intersectsAllSpecial(List<Comparable> out, List<Comparable> values, int start, List<Comparable> values2, int start2) {
        boolean addHeader = false;
        int end = OlapComparableVectorEntity.endPartition(values, start);
        int end2 = OlapComparableVectorEntity.endPartition(values2, start2);
        for (int i2 = 0; i2 < end2; ++i2) {
            Comparable comp2 = values2.get(i2);
            for (int i = 0; i < end; ++i) {
                Comparable comp = values.get(i);
                if (!comp2.equals(comp)) continue;
                if (!addHeader) {
                    out.add(values.get(start - 1));
                    addHeader = true;
                }
                out.add(Integer.valueOf(i));
            }
        }
    }

    public OlapScalarEntity minusRows(OlapComparableVectorEntity ent2) {
        if (this.size() == 0 || ent2.size() == 0) {
            return this;
        }
        if (!(this.values.get(0) instanceof String) && !(ent2.get(0) instanceof String)) {
            return this.minus(ent2);
        }
        Map<String, Integer> ent2Partitions = this.getPartitionPos(ent2);
        OlapComparableVectorEntity that = this.asNew();
        for (int i = 0; i < that.values.size(); ++i) {
            String partition;
            Integer pos;
            Comparable comparable = that.values.get(i);
            if (!(comparable instanceof String) || (pos = ent2Partitions.get(partition = (String)((Object)comparable))) == null) continue;
            OlapComparableVectorEntity.removeAllSpecial(that.values, i + 1, ent2.values, pos + 1);
        }
        return that.values.isEmpty() ? OlapEmptyEntity.INSTANCE : that;
    }

    @NotNull
    public Map<String, Integer> getPartitionPos(OlapComparableVectorEntity ent2) {
        HashMap<String, Integer> ent2Partitions = new HashMap<String, Integer>();
        for (int i = 0; i < ent2.values.size(); ++i) {
            Comparable comparable = ent2.values.get(i);
            if (!(comparable instanceof String)) continue;
            ent2Partitions.put((String)((Object)comparable), i);
        }
        return ent2Partitions;
    }

    private static void removeAllSpecial(List<Comparable> values, int start, List<Comparable> values2, int start2) {
        int end = OlapComparableVectorEntity.endPartition(values, start);
        int end2 = OlapComparableVectorEntity.endPartition(values2, start2);
        for (int i2 = 0; i2 < end2; ++i2) {
            Comparable comp2 = values2.get(i2);
            for (int i = 0; i < end; ++i) {
                Comparable comp = values.get(i);
                if (!comp2.equals(comp)) continue;
                values.remove(i);
                --end;
            }
        }
    }

    private static int endPartition(List<Comparable> values, int start) {
        int end;
        for (end = start; end < values.size() && !(values.get(end) instanceof String); ++end) {
        }
        return end;
    }

    public OlapScalarEntity minus(OlapComparableVectorEntity ent2) {
        OlapComparableVectorEntity that = this.asNew();
        that.values.removeAll(ent2.values);
        if (that.values.isEmpty()) {
            return OlapEmptyEntity.INSTANCE;
        }
        return that;
    }

    public OlapScalarEntity minus(OlapStringEntity ent2) {
        OlapComparableVectorEntity that = this.asNew();
        that.values.remove(ent2.asString());
        if (that.values.isEmpty()) {
            return OlapEmptyEntity.INSTANCE;
        }
        return that;
    }

    public OlapScalarEntity intersect(OlapComparableVectorEntity ent2) {
        List<Comparable> list = this.values.stream().filter(ent2.values::contains).collect(Collectors.toList());
        if (list.isEmpty()) {
            return OlapEmptyEntity.INSTANCE;
        }
        return new OlapComparableVectorEntity(list, false);
    }

    public List<Comparable> getVector() {
        return this.values;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public int length() {
        return this.size();
    }

    @Nullable
    public Comparable first() {
        return this.values.isEmpty() ? null : this.values.get(0);
    }

    @Nullable
    public Comparable last() {
        return this.values.isEmpty() ? null : this.values.get(this.values.size() - 1);
    }

    public Comparable firstNotNull() {
        for (int i = 0; i < this.values.size(); ++i) {
            Comparable val = this.values.get(i);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    @Nullable
    public Comparable lastNotNull() {
        for (int i = this.values.size() - 1; i >= 0; --i) {
            Comparable val = this.values.get(i);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    @Nullable
    public Comparable min() {
        Comparator comparator = Comparator.naturalOrder();
        return this.values.stream().min(comparator).orElse(null);
    }

    @Nullable
    public Comparable max() {
        Comparator comparator = Comparator.naturalOrder();
        return this.values.stream().max(comparator).orElse(null);
    }

    @Nullable
    public String join(String delimiter) {
        return this.join(delimiter, "", "");
    }

    @Nullable
    public String join(String delimiter, String prefix, String suffix) {
        return this.values.isEmpty() ? null : this.values.stream().map(Object::toString).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    public Comparable get(int index) {
        return this.values.get(index);
    }

    public boolean sameValues() {
        if (this.values.size() <= 1) {
            return true;
        }
        Comparable first = this.values.get(0);
        for (int i = 1; i < this.values.size(); ++i) {
            if (CdClassUtils.compareTo((Comparable)first, (Comparable)this.values.get(i)) == 0) continue;
            return false;
        }
        return true;
    }
}

