/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.IAggregationScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import java.io.Serializable;

public class OlapAveragingAggrEntity
extends OlapNumericEntity
implements IAggregationScalarEntity {
    private static final long serialVersionUID = -4138102597018139546L;
    private double sum;
    private int count;

    public OlapAveragingAggrEntity(OlapNumericEntity one, boolean constant) {
        super(one.value(), constant);
        if (one instanceof OlapAveragingAggrEntity) {
            OlapAveragingAggrEntity aggrEntity = (OlapAveragingAggrEntity)one;
            this.sum = aggrEntity.sum;
            this.count = aggrEntity.count;
        } else {
            this.sum = one.value();
            this.count = 1;
        }
    }

    public OlapAveragingAggrEntity(double sum, int count) {
        super(sum / (double)count);
        this.sum = sum;
        this.count = count;
    }

    private OlapAveragingAggrEntity(CdXmlaSchemaType kind, double value, boolean constant, double sum, int count) {
        super(kind, value, constant);
        this.sum = sum;
        this.count = count;
    }

    @Override
    public OlapScalarEntity asNonAggregating(boolean constant) {
        return new OlapNumericEntity(this.kind, this.value, constant);
    }

    @Override
    protected OlapScalarEntity doAsConstant() {
        return new OlapAveragingAggrEntity(this.kind, this.value, true, this.sum, this.count);
    }

    @Override
    public OlapNumericEntity aggregate(OlapMember[] members, OlapMember measure, OlapScalarEntity entity, OlapAggregationType aggregationType) {
        if (entity.isMdxNull()) {
            return this;
        }
        if (!(entity instanceof OlapNumericEntity)) {
            throw new OlapEvaluationException(IOlapEvaluationExceptionContext.NULL, OlapErrorCode.TYPE_MISMATCH, new Serializable[]{"numeric", entity.getFriendlyTypeName()});
        }
        switch (aggregationType) {
            case AVG_LEAVES: {
                double sum_;
                int count_;
                if (entity instanceof OlapAveragingAggrEntity) {
                    OlapAveragingAggrEntity avgEntity = (OlapAveragingAggrEntity)entity;
                    count_ = this.count + avgEntity.count;
                    sum_ = this.sum + avgEntity.sum;
                } else {
                    OlapNumericEntity numEntity = (OlapNumericEntity)entity;
                    count_ = this.count + 1;
                    sum_ = this.sum + numEntity.value();
                }
                double value_ = sum_ / (double)count_;
                if (!this.constant) {
                    this.count = count_;
                    this.sum = sum_;
                    this.value = value_;
                    return this;
                }
                return new OlapAveragingAggrEntity(this.kind, value_, false, sum_, count_);
            }
        }
        throw new RuntimeException("internal error: inconsistent aggregation for AVERAGING entity [" + String.valueOf((Object)aggregationType) + "]");
    }

    @Override
    public String toStringForDebugger() {
        return "AVG: " + this.value + " [sum:" + this.sum + "][count:" + this.count + "]";
    }
}

