/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.collection.CdArrays;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.lang.CdXmlaOptions;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.exception.OlapError;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapCellMeasureVectorScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class OlapArgArrayWrapperScalarEntity<T extends OlapScalarEntity<T>>
extends OlapAbstractScalarEntity<T> {
    private final OlapScalarEntity<?>[] values;

    public OlapArgArrayWrapperScalarEntity(OlapScalarEntity<?>[] values) {
        this.values = values;
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.LIST;
    }

    @Override
    public CdXmlaSchemaType getXmlaType(@Nullable CdXmlaOptions options) {
        return CdXmlaSchemaType.DBTYPE_WSTR;
    }

    @Override
    public String asXmlaString() {
        return this.asString();
    }

    @Override
    public String asString() {
        return CdArrays.toString((Object[])this.values, (int)1024);
    }

    public OlapScalarEntity<?>[] asValue() {
        return this.values;
    }

    @Override
    public Class getUnderlyingJavaNativeValueType() {
        return OlapScalarEntity[].class;
    }

    @Override
    public boolean isConvertibleToJavaNativeValueType(Class target) {
        if (Object.class.equals((Object)target)) {
            return true;
        }
        return this.doIsConvertibleToJavaType(target);
    }

    @Override
    protected boolean doIsConvertibleToJavaType(Class target) {
        if (OlapArgArrayWrapperScalarEntity.class.equals((Object)target)) {
            return true;
        }
        return OlapScalarEntity[].class.equals((Object)target);
    }

    @Override
    @Nullable
    public Object doAsJavaNativeValue(Class<?> expectedClazz) {
        if (OlapArgArrayWrapperScalarEntity.class.equals(expectedClazz)) {
            return this;
        }
        if (OlapScalarEntity[].class == expectedClazz) {
            return this.asValue();
        }
        return null;
    }

    @Override
    public OlapScalarEntity asInitialValueFor(OlapMember[] members, OlapMember measure, OlapAggregationType aggregationType) {
        throw new OlapEvaluationException(new OlapError(OlapErrorCode.AGGREGATION_NOT_SUPPORTED_FOR_TYPE, new Serializable[]{aggregationType, this.getFriendlyTypeName()}));
    }

    @Override
    public T aggregate(OlapMember[] members, OlapMember measure, OlapScalarEntity entity, OlapAggregationType aggregationType) {
        throw new OlapEvaluationException(new OlapError(OlapErrorCode.AGGREGATION_NOT_SUPPORTED_FOR_TYPE, new Serializable[]{aggregationType, this.getFriendlyTypeName()}));
    }

    @Override
    public int getOperatorIndex() {
        throw new CdShouldNotBeHereProgrammingException();
    }

    public OlapScalarEntity<?> get(int pos) {
        OlapEmptyEntity value = pos >= 0 && pos < this.values.length ? this.values[pos] : null;
        return value != null ? value : OlapEmptyEntity.INSTANCE;
    }

    public int size() {
        return this.values.length;
    }

    @Override
    public String getFriendlyTypeName() {
        return "scalar-list";
    }

    @Override
    @Nullable
    public String javaFormat(GFCellPropertyEvalContext context, Locale locale, String pattern) {
        return null;
    }

    @Override
    @Nullable
    public String excelFormat(GFCellPropertyEvalContext context, Locale locale, String format) {
        return null;
    }

    @Override
    public OlapScalarEntity multiplyByZero() {
        OlapScalarEntity[] newEntities = new OlapScalarEntity[this.values.length];
        for (int ii = 0; ii < this.values.length; ++ii) {
            newEntities[ii] = this.values[ii].multiplyByZero();
        }
        return new OlapCellMeasureVectorScalarEntity(newEntities);
    }

    @Override
    public boolean isZero() {
        for (OlapScalarEntity<?> entity : this.values) {
            if (entity.isZero()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toStringForDebugger() {
        return "array";
    }

    @Override
    public String toStringForDebuggerAsValue() {
        return CdArrays.toString((Object[])this.values, (int)1024);
    }

    @Override
    public String toString() {
        return this.asString();
    }

    @Override
    public OlapScalarEntity asConstant() {
        return this;
    }

    @Override
    @Nullable
    public Object toTidyTableValue() {
        Object[] valuesT = new Object[this.values.length];
        for (int ii = 0; ii < valuesT.length; ++ii) {
            OlapScalarEntity<?> value = this.values[ii];
            valuesT[ii] = value != null ? value.toTidyTableValue() : OlapEmptyEntity.INSTANCE.toTidyTableValue();
        }
        return valuesT;
    }

    @Override
    @Nullable
    public Object toTidyTableValueEx() {
        Object[] valuesT = new Object[this.values.length];
        for (int ii = 0; ii < valuesT.length; ++ii) {
            OlapScalarEntity<?> value = this.values[ii];
            valuesT[ii] = value != null ? value.toTidyTableValueEx() : OlapEmptyEntity.INSTANCE.toTidyTableValue();
        }
        return valuesT;
    }

    @Override
    public OlapScalarEntityTidyType toTidyTableValueType() {
        return OlapScalarEntityTidyType.LIST;
    }

    @Override
    public OlapScalarEntityTidyType toTidyTableValueSubType() {
        OlapScalarEntityTidyType subType = null;
        for (OlapScalarEntity<?> value : this.values) {
            OlapScalarEntityTidyType vType;
            OlapScalarEntityTidyType olapScalarEntityTidyType = vType = value != null ? value.toTidyTableValueType() : OlapScalarEntityTidyType.NULL;
            if (vType == OlapScalarEntityTidyType.NULL) continue;
            if (vType == OlapScalarEntityTidyType.UNKNOWN) {
                subType = OlapScalarEntityTidyType.UNKNOWN;
                break;
            }
            if (vType == OlapScalarEntityTidyType.MIXED) {
                subType = OlapScalarEntityTidyType.MIXED;
                break;
            }
            if (subType == null) {
                subType = vType;
                continue;
            }
            if (subType == vType) continue;
            subType = OlapScalarEntityTidyType.MIXED;
            break;
        }
        return subType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapArgArrayWrapperScalarEntity that = (OlapArgArrayWrapperScalarEntity)o;
        return Arrays.equals(this.values, that.values);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }
}

