/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.scalar;

import crazydev.common.lang.CdXmlaOptions;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public abstract class OlapAbstractStringEntity<T extends OlapAbstractStringEntity<T>>
extends OlapAbstractScalarEntity<T> {
    public static final String FRIENDLY_NAME = "string";
    public static int operatorIndex = OlapScalarOperators.createIndex(OlapAbstractStringEntity.class);
    private final String value;

    public OlapAbstractStringEntity(String value) {
        this.value = value;
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.STRING;
    }

    public String value() {
        return this.value;
    }

    @Override
    public CdXmlaSchemaType getXmlaType(@Nullable CdXmlaOptions options) {
        return CdXmlaSchemaType.DBTYPE_WSTR;
    }

    @Override
    public String asXmlaString() {
        return this.asString();
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public String asValue() {
        return this.value;
    }

    @Override
    public Class getUnderlyingJavaNativeValueType() {
        return String.class;
    }

    @Override
    public boolean doIsConvertibleToJavaType(Class target) {
        return target.isAssignableFrom(String.class) || Double.class.equals((Object)target) || Double.TYPE.equals(target) || Long.class.equals((Object)target) || Long.TYPE.equals(target) || Float.class.equals((Object)target) || Float.TYPE.equals(target) || Integer.class.equals((Object)target) || Integer.TYPE.equals(target);
    }

    @Override
    public Object doAsJavaNativeValue(Class expectedClazz) {
        if (expectedClazz.isAssignableFrom(String.class)) {
            return this.value;
        }
        if (expectedClazz == Double.TYPE || expectedClazz == Double.class) {
            return Double.parseDouble(this.value);
        }
        if (expectedClazz == Long.TYPE || expectedClazz == Long.class) {
            return Long.parseLong(this.value);
        }
        if (expectedClazz == Float.TYPE || expectedClazz == Float.class) {
            return Float.valueOf(Float.parseFloat(this.value));
        }
        if (expectedClazz == Integer.TYPE || expectedClazz == Integer.class) {
            return Integer.parseInt(this.value);
        }
        return null;
    }

    @Override
    public int getOperatorIndex() {
        return operatorIndex;
    }

    @Override
    public String javaFormat(GFCellPropertyEvalContext context, Locale locale, String pattern) {
        return this.value;
    }

    @Override
    public String excelFormat(GFCellPropertyEvalContext context, Locale locale, String format) {
        return this.value;
    }

    @Override
    public Object toTidyTableValue() {
        return this.value;
    }

    @Override
    public OlapScalarEntityTidyType toTidyTableValueType() {
        return OlapScalarEntityTidyType.CHARACTER;
    }

    @Override
    @Nullable
    public Number toLatLongValue() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    public OlapScalarEntity sum(OlapAbstractStringEntity other) {
        return this.create(this.value + other.value);
    }

    protected abstract OlapAbstractStringEntity create(String var1);

    public boolean isExcelFormatString() {
        return false;
    }

    public boolean isJavaFormatString() {
        return false;
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public OlapScalarEntity asConstant() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapAbstractStringEntity that = (OlapAbstractStringEntity)o;
        return this.value.equals(that.value);
    }

    @Override
    public boolean isStringForOperator() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

