/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.serialize;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemTmpReason;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.entity.result.tidy.serialize.IOlapSerializedTidyResource;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapFileSerializedTidyResourceCB;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapSerializedTidyResourceCompression;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.apache.commons.io.IOUtils;

public class OlapFileSerializedTidyResource
implements IOlapSerializedTidyResource {
    private final OlapSerializedTidyResourceCompression compression;
    private final AtomicReference<File> resource = new AtomicReference();

    private OlapFileSerializedTidyResource(OlapSerializedTidyResourceCompression compression, File resource) {
        this.compression = compression;
        this.resource.set(resource);
    }

    @Override
    public long length() {
        File file = this.resource.get();
        if (file != null) {
            return file.length();
        }
        return 0L;
    }

    @Override
    public void release() {
        File file = this.resource.getAndSet(null);
        if (file != null) {
            CdVFileSystemUtils.deleteQuietly((File)file);
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        File file = this.resource.get();
        if (file == null) {
            throw new IOException("The resource has been released.");
        }
        try (FileInputStream inF = new FileInputStream(file);
             BufferedInputStream inB = new BufferedInputStream(inF);
             InputStream in = OlapFileSerializedTidyResource.createInputStream(inB, this.compression);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    static InputStream createInputStream(InputStream in, OlapSerializedTidyResourceCompression compression) throws IOException {
        return switch (compression) {
            case OlapSerializedTidyResourceCompression.NONE -> in;
            case OlapSerializedTidyResourceCompression.LZ4 -> {
                LZ4FastDecompressor decompressor = LZ4Factory.fastestInstance().fastDecompressor();
                yield new LZ4BlockInputStream(in, decompressor);
            }
            case OlapSerializedTidyResourceCompression.ZIP -> new GZIPInputStream(in);
            default -> throw new RuntimeException("internal error : unexpected compression [" + String.valueOf((Object)compression) + "]");
        };
    }

    static OlapFileSerializedTidyResource create(OlapRuntimeContext context, OlapSerializedTidyResourceCompression compression, OlapFileSerializedTidyResourceCB cb) throws IOException {
        OlapDirectoriesResolved directories = context.getDirectoriesResolved();
        CdVFileSystem vfs = directories.getVfs();
        File file = vfs.createTmpFile(CdVFileSystemTmpReason.RESULT, directories.getTmpDirectory());
        try {
            try (FileOutputStream outF = new FileOutputStream(file);
                 BufferedOutputStream outB = new BufferedOutputStream(outF);
                 OutputStream out = OlapFileSerializedTidyResource.createOutputStream(outB, compression);){
                cb.process(out);
                out.flush();
            }
            return new OlapFileSerializedTidyResource(compression, file);
        }
        catch (Exception ex) {
            CdVFileSystemUtils.deleteQuietly((File)file);
            throw ex;
        }
    }

    static OutputStream createOutputStream(OutputStream out, OlapSerializedTidyResourceCompression compression) throws IOException {
        return switch (compression) {
            case OlapSerializedTidyResourceCompression.NONE -> out;
            case OlapSerializedTidyResourceCompression.LZ4 -> {
                int blockSize = 65536;
                LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();
                yield new LZ4BlockOutputStream(out, 65536, compressor);
            }
            case OlapSerializedTidyResourceCompression.ZIP -> new GZIPOutputStream(out);
            default -> throw new RuntimeException("internal error : unexpected compression [" + String.valueOf((Object)compression) + "]");
        };
    }
}

