/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.prettyprint;

import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTable;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableColumn;
import crazydev.iccube.olap.entity.result.tidy.prettyprint.OlapResMdxTidyPrettyPrinterHeader;
import java.io.PrintWriter;
import org.jetbrains.annotations.Nullable;

public class OlapResMdxTidyPrettyPrinter {
    private final OlapResMdxTidyMaterializedTable table;
    private final PrintWriter out;

    public OlapResMdxTidyPrettyPrinter(OlapResMdxTidyMaterializedTable table, PrintWriter out) {
        this.table = table;
        this.out = out;
    }

    public void prettyPrint() {
        if (this.table.getColumnCount() == 0) {
            this.out.println("no data");
            return;
        }
        int columnCount = this.table.getColumnCount();
        int rowCount = this.table.getRowCount();
        int[] maxWidths = new int[columnCount];
        for (int ii = 0; ii < maxWidths.length; ++ii) {
            OlapResMdxTidyMaterializedTableColumn column = this.table.getColumn(ii);
            maxWidths[ii] = column.prettyPrintMaxWidth(this.table);
        }
        for (int rr = 0; rr < rowCount; ++rr) {
            if (rr == 0) {
                this.prettyPrintRow(maxWidths, rr, OlapResMdxTidyPrettyPrinterHeader.NAME);
                this.prettyPrintRow(maxWidths, rr, OlapResMdxTidyPrettyPrinterHeader.SEPARATOR);
                this.prettyPrintRow(maxWidths, rr, OlapResMdxTidyPrettyPrinterHeader.TYPE);
                this.prettyPrintRow(maxWidths, rr, OlapResMdxTidyPrettyPrinterHeader.SUB_TYPE);
                this.prettyPrintRow(maxWidths, rr, OlapResMdxTidyPrettyPrinterHeader.FORMAT_STRING);
                this.prettyPrintRow(maxWidths, rr, OlapResMdxTidyPrettyPrinterHeader.SEPARATOR);
            }
            this.prettyPrintRow(maxWidths, rr, null);
        }
    }

    private void prettyPrintRow(int[] maxWidths, int rr, @Nullable OlapResMdxTidyPrettyPrinterHeader header) {
        int columnCount = this.table.getColumnCount();
        StringBuilder row = new StringBuilder();
        for (int cc = 0; cc < columnCount; ++cc) {
            OlapResMdxTidyMaterializedTableColumn column = this.table.getColumn(cc);
            String value = header != null ? column.prettyPrintHeader(header) : column.prettyPrint(this.table, rr);
            row.append(" | ").append(value);
            int padding = maxWidths[cc] - value.length();
            for (int p = 0; p < padding; ++p) {
                row.append(" ");
            }
        }
        this.out.println(row);
    }
}

