/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.debug;

import crazydev.iccube.olap.entity.result.tidy.TidyTableClassID;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResFlatTidyMaterializedTableColumn;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTable;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableAxis;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableColumn;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableColumnAxisInfo;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableColumnHierarchyInfo;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableColumnLevelInfo;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableMemberSubType;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableMemberType;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableMembersInfo;
import crazydev.iccube.olap.entity.result.tidy.prettyprint.OlapResMdxTidyPrettyPrinterHeader;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapResMdxTidyMaterializedTableMembersColumn
extends OlapResMdxTidyMaterializedTableColumn {
    public OlapResMdxTidyMaterializedTableMembersColumn(@Nullable String role, String name, String caption, OlapResMdxTidyMaterializedTableColumnAxisInfo axis) {
        super(TidyTableClassID.MDX_MEMBERS, role, name, caption, OlapScalarEntityTidyType.CHARACTER, null, axis);
    }

    public OlapResFlatTidyMaterializedTableColumn<?> toFlat(List<Integer> axisInfo, OlapResMdxTidyMaterializedTableMembersInfo membersInfo) {
        ArrayList<String> values = new ArrayList<String>();
        int rowCount = axisInfo.size();
        for (int rr = 0; rr < rowCount; ++rr) {
            values.add(this.toFlatCaption(axisInfo, membersInfo, rr));
        }
        return new OlapResFlatTidyMaterializedTableColumn(OlapScalarEntityTidyType.CHARACTER, this.getName(), this.getCaption(), values);
    }

    private String toFlatCaption(List<Integer> axisInfo, OlapResMdxTidyMaterializedTableMembersInfo membersInfo, int rowIndex) {
        int tupleIndex = axisInfo.get(rowIndex);
        int memberIndex = membersInfo.getMemberIndex(tupleIndex);
        String caption = membersInfo.getCaption(memberIndex);
        return caption;
    }

    @Override
    public void setNaN() {
    }

    @Override
    public int prettyPrintMaxWidth(OlapResMdxTidyMaterializedTable table) {
        int max = 0;
        max = Math.max(max, this.prettyPrintHeader(OlapResMdxTidyPrettyPrinterHeader.NAME).length());
        max = Math.max(max, this.prettyPrintHeader(OlapResMdxTidyPrettyPrinterHeader.TYPE).length());
        max = Math.max(max, this.prettyPrintHeader(OlapResMdxTidyPrettyPrinterHeader.SUB_TYPE).length());
        max = Math.max(max, this.prettyPrintHeader(OlapResMdxTidyPrettyPrinterHeader.FORMAT_STRING).length());
        int rowCount = table.getRowCount();
        for (int rr = 0; rr < rowCount; ++rr) {
            max = Math.max(max, this.prettyPrint(table, rr).length());
        }
        return max;
    }

    @Override
    public String prettyPrintHeader(OlapResMdxTidyPrettyPrinterHeader header) {
        OlapResMdxTidyMaterializedTableColumnLevelInfo level = this.axis.getLevelInfo();
        OlapResMdxTidyMaterializedTableColumnHierarchyInfo hierarchy = this.axis.getHierarchyInfo();
        OlapResMdxTidyMaterializedTableMemberType kt = level != null ? level.getType() : hierarchy.getType();
        OlapResMdxTidyMaterializedTableMemberSubType lt = level != null ? level.getSubType() : null;
        switch (header) {
            case NAME: {
                return this.name + "[" + this.caption + "]";
            }
            case TYPE: {
                return "KT: " + String.valueOf(kt != null ? kt : "");
            }
            case SUB_TYPE: {
                return "LT: " + String.valueOf(lt != null ? lt : "");
            }
            case FORMAT_STRING: {
                return "FS: ";
            }
            case SEPARATOR: {
                return "--";
            }
        }
        return "";
    }

    @Override
    public String prettyPrint(OlapResMdxTidyMaterializedTable table, int rowIndex) {
        return this.getName(table, rowIndex);
    }

    public String getName(OlapResMdxTidyMaterializedTable table, int rowIndex) {
        OlapResMdxTidyMaterializedTableAxis axisInfo = table.getAxis(this.axis.getAxis());
        OlapResMdxTidyMaterializedTableMembersInfo membersInfo = table.getMembers(this.axis.getAxis(), this.axis.getHierarchyIdx());
        int tupleIndex = axisInfo.getTupleIndex(rowIndex);
        int memberIndex = membersInfo.getMemberIndex(tupleIndex);
        String name = membersInfo.getName(memberIndex);
        return name;
    }

    public String getUniqueName(OlapResMdxTidyMaterializedTable table, int rowIndex) {
        OlapResMdxTidyMaterializedTableAxis axisInfo = table.getAxis(this.axis.getAxis());
        OlapResMdxTidyMaterializedTableMembersInfo membersInfo = table.getMembers(this.axis.getAxis(), this.axis.getHierarchyIdx());
        int tupleIndex = axisInfo.getTupleIndex(rowIndex);
        int memberIndex = membersInfo.getMemberIndex(tupleIndex);
        String name = membersInfo.getUniqueName(memberIndex);
        return name;
    }
}

