/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.debug;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyUtils;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableAxis;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableMembersColumn;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableMembersInfo;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapResMdxTidyMaterializedTableMembers {
    private final OlapResMdxTidyMaterializedTableAxis axisInfo;
    private final OlapResMdxTidyMaterializedTableMembersInfo membersInfo;
    private final OlapResMdxTidyMaterializedTableMembersColumn column;

    public OlapResMdxTidyMaterializedTableMembers(OlapResMdxTidyMaterializedTableAxis axisInfo, OlapResMdxTidyMaterializedTableMembersInfo membersInfo, OlapResMdxTidyMaterializedTableMembersColumn column) {
        this.axisInfo = axisInfo;
        this.membersInfo = membersInfo;
        this.column = column;
    }

    public int getRowCount() {
        return this.axisInfo.getRowCount();
    }

    public int getMemberIndex(int rowIndex) {
        int tupleIndex = this.axisInfo.getTupleIndex(rowIndex);
        int memberIndex = this.membersInfo.getMemberIndex(tupleIndex);
        return memberIndex;
    }

    public String getName(int rowIndex) {
        int memberIndex = this.getMemberIndex(rowIndex);
        return this.membersInfo.getName(memberIndex);
    }

    public String getCaption(int rowIndex) {
        int memberIndex = this.getMemberIndex(rowIndex);
        return this.membersInfo.getCaption(memberIndex);
    }

    @Nullable
    public String getIc3Iso2(int rowIndex) {
        int memberIndex = this.getMemberIndex(rowIndex);
        return this.membersInfo.getIc3Iso2(memberIndex);
    }

    @Nullable
    public Number getIc3Lat(int rowIndex) {
        int memberIndex = this.getMemberIndex(rowIndex);
        return this.membersInfo.getIc3Lat(memberIndex);
    }

    @Nullable
    public Number getIc3Long(int rowIndex) {
        int memberIndex = this.getMemberIndex(rowIndex);
        return this.membersInfo.getIc3Long(memberIndex);
    }

    @Nullable
    public String getColor(int rowIndex) {
        int memberIndex = this.getMemberIndex(rowIndex);
        return this.membersInfo.getColor(memberIndex);
    }

    @Nullable
    public Object getDpValue(String prop, int rowIndex) {
        List<Object> values = this.membersInfo.getDpValues(prop);
        if (values != null) {
            int memberIndex = this.getMemberIndex(rowIndex);
            return values.get(memberIndex);
        }
        return null;
    }

    public void assertEquals(OlapResMdxTidyMaterializedTableMembers other, String kind) {
        int rowCount = this.axisInfo.getRowCount();
        OlapResMdxTidyUtils.assertTrue("row count", rowCount > 0);
        OlapResMdxTidyUtils.assertEquals("row count", rowCount, other.axisInfo.getRowCount());
        for (int rr = 0; rr < rowCount; ++rr) {
            int thisTupleIndex = this.axisInfo.getTupleIndex(rr);
            int thisMemberIndex = this.membersInfo.getMemberIndex(thisTupleIndex);
            int otherTupleIndex = other.axisInfo.getTupleIndex(rr);
            int otherMemberIndex = other.membersInfo.getMemberIndex(otherTupleIndex);
            if (kind.equals("all") || kind.equals("caption")) {
                String thisCaption = this.membersInfo.getCaption(thisMemberIndex);
                String otherCaption = other.membersInfo.getCaption(otherMemberIndex);
                OlapResMdxTidyUtils.assertEquals("member caption:" + rr, thisCaption, otherCaption);
            }
            if (!kind.equals("all")) continue;
            String thisName = this.membersInfo.getName(thisMemberIndex);
            String otherName = other.membersInfo.getName(otherMemberIndex);
            OlapResMdxTidyUtils.assertEquals("member name:" + rr, thisName, otherName);
            String thisUName = this.membersInfo.getUniqueName(thisMemberIndex);
            String otherUName = other.membersInfo.getUniqueName(otherMemberIndex);
            OlapResMdxTidyUtils.assertEquals("member unique-name:" + rr, thisUName, otherUName);
        }
        if (kind.equals("all")) {
            List<String> thisDpNames = this.membersInfo.getDpNames();
            List<String> otherDpNames = other.membersInfo.getDpNames();
            OlapResMdxTidyUtils.assertEquals("member DP names", thisDpNames, otherDpNames);
            if (thisDpNames != null) {
                for (String prop : thisDpNames) {
                    OlapScalarEntityTidyType thisDpType = this.membersInfo.getDpType(prop);
                    OlapScalarEntityTidyType otherDpType = other.membersInfo.getDpType(prop);
                    OlapResMdxTidyUtils.assertEquals("member DP type:" + prop, (Object)thisDpType, (Object)otherDpType);
                    List<Object> thisDpValues = this.membersInfo.getDpValues(prop);
                    List<Object> otherDpValues = other.membersInfo.getDpValues(prop);
                    OlapResMdxTidyUtils.assertEquals("member DP values:" + prop, thisDpValues, otherDpValues);
                }
            }
        }
    }

    public void assertEquals(List<OlapTuple> expected, int hierarchy) {
        for (int rr = 0; rr < expected.size(); ++rr) {
            OlapMember expectedMember = expected.get(rr).getMember(hierarchy);
            String expectedUniqueName = expectedMember.getUniqueName(OlapNameContext.DEFAULT_VALUES);
            int tupleIndex = this.axisInfo.getTupleIndex(rr);
            int memberIndex = this.membersInfo.getMemberIndex(tupleIndex);
            String uniqueName = this.membersInfo.getUniqueName(memberIndex);
            OlapResMdxTidyUtils.assertEquals("member unique-name:" + rr, expectedUniqueName, uniqueName);
        }
    }
}

