/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.debug;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyUtils;
import crazydev.iccube.olap.entity.result.tidy.TidyTableClassID;
import crazydev.iccube.olap.entity.result.tidy.TidyTableColumnNaN;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResFlatTidyMaterializedTableColumn;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTable;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableCellError;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableCellsPage;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableColumn;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableColumnAxisInfo;
import crazydev.iccube.olap.entity.result.tidy.prettyprint.OlapResMdxTidyPrettyPrinterHeader;
import crazydev.iccube.olap.entity.result.tidy.prettyprint.OlapResMdxTidyPrettyPrinterHeaderValue;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapResMdxTidyMaterializedTableCellsColumn
extends OlapResMdxTidyMaterializedTableColumn {
    private final int tupleIdx;
    private final ArrayList<Object> values;
    @Nullable
    private TidyTableColumnNaN valuesN;
    @Nullable
    private final List<OlapResMdxTidyMaterializedTableCellError> errors;
    @Nullable
    private final List<String> formattedValues;
    @Nullable
    private final List<String> backColors;
    @Nullable
    private final List<String> foreColors;
    @Nullable
    private final String fs;
    @Nullable
    private final String color;
    @Nullable
    private final String[] colors;
    @Nullable
    private final OlapResMdxTidyMaterializedTableCellsPage[] pages;

    public OlapResMdxTidyMaterializedTableCellsColumn(@Nullable String role, String name, String caption, OlapResMdxTidyMaterializedTableColumnAxisInfo axis, int tupleIdx, @Nullable String fs, @Nullable String color, @Nullable String[] colors, OlapResMdxTidyMaterializedTableCellsPage[] pages) {
        super(TidyTableClassID.MDX_CELLS, role, name, caption, pages[0].getType(), pages[0].getTypeParam(), axis);
        this.tupleIdx = tupleIdx;
        this.fs = fs;
        this.color = color;
        this.colors = colors;
        this.values = pages[0].getValues();
        this.errors = pages[0].getErrors();
        this.formattedValues = pages[0].getFormattedValues();
        this.backColors = pages[0].getBackColors();
        this.foreColors = pages[0].getForeColors();
        this.pages = pages.length > 1 ? Arrays.copyOfRange(pages, 1, pages.length) : null;
    }

    public OlapResFlatTidyMaterializedTableColumn<?> toFlat() {
        OlapScalarEntityTidyType fType = this.getType();
        ArrayList<Object> fValues = new ArrayList<Object>();
        int rowCount = this.values.size();
        for (int rr = 0; rr < rowCount; ++rr) {
            Object value;
            OlapResMdxTidyMaterializedTableCellError error = this.getError(rr);
            if (error != null) {
                if (fType != OlapScalarEntityTidyType.CHARACTER) {
                    fType = OlapScalarEntityTidyType.MIXED;
                }
                value = error.getErrorCode() + "  " + error.getErrorDescription();
                fValues.add(value);
                continue;
            }
            value = this.getValue(rr);
            fValues.add(value);
        }
        return new OlapResFlatTidyMaterializedTableColumn(fType, this.getName(), this.getCaption(), fValues);
    }

    @Override
    public void setNaN() {
        if (this.valuesN == null) {
            this.valuesN = TidyTableColumnNaN.createNaN(this.values);
        }
        if (this.pages != null) {
            for (OlapResMdxTidyMaterializedTableCellsPage page : this.pages) {
                page.setNaN();
            }
        }
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public int getPageCount() {
        return this.pages != null ? this.pages.length : 0;
    }

    @Nullable
    public Object getValue(int rowIndex) {
        Object value = this.values.get(rowIndex);
        if (value == null && this.valuesN != null) {
            return this.valuesN.get(rowIndex);
        }
        return value;
    }

    @Nullable
    public OlapResMdxTidyMaterializedTableCellError getError(int rowIndex) {
        OlapResMdxTidyMaterializedTableCellError error;
        if (this.errors != null && (error = this.errors.get(rowIndex)) != null) {
            return error;
        }
        return null;
    }

    @Nullable
    public String getErrorCode(int rowIndex) {
        OlapResMdxTidyMaterializedTableCellError error = this.getError(rowIndex);
        if (error != null) {
            return error.getErrorCode();
        }
        return null;
    }

    @Nullable
    public String getErrorDescription(int rowIndex) {
        OlapResMdxTidyMaterializedTableCellError error = this.getError(rowIndex);
        if (error != null) {
            return error.getErrorDescription();
        }
        return null;
    }

    @Nullable
    public String getFormattedValue(int rowIndex) {
        if (this.formattedValues != null) {
            return this.formattedValues.get(rowIndex);
        }
        return null;
    }

    @Override
    public int prettyPrintMaxWidth(OlapResMdxTidyMaterializedTable table) {
        int max = 0;
        max = Math.max(max, this.prettyPrintHeader(OlapResMdxTidyPrettyPrinterHeader.NAME).length());
        max = Math.max(max, this.prettyPrintHeader(OlapResMdxTidyPrettyPrinterHeader.TYPE).length());
        max = Math.max(max, this.prettyPrintHeader(OlapResMdxTidyPrettyPrinterHeader.SUB_TYPE).length());
        max = Math.max(max, this.prettyPrintHeader(OlapResMdxTidyPrettyPrinterHeader.FORMAT_STRING).length());
        int rowCount = table.getRowCount();
        for (int rr = 0; rr < rowCount; ++rr) {
            max = Math.max(max, this.prettyPrint(table, rr).length());
        }
        return max;
    }

    @Override
    public String prettyPrintHeader(OlapResMdxTidyPrettyPrinterHeader header) {
        switch (header) {
            case NAME: {
                return this.prettyPrintHeader((int page) -> {
                    if (page == 0) {
                        return this.name + "[" + this.caption + "]";
                    }
                    OlapResMdxTidyMaterializedTableCellsPage p = this.pages[page - 1];
                    return p.getName() + "[" + p.getCaption() + "]";
                });
            }
            case TYPE: {
                return " T: " + this.prettyPrintHeader((int page) -> {
                    if (page == 0) {
                        return this.type.toString();
                    }
                    OlapResMdxTidyMaterializedTableCellsPage p = this.pages[page - 1];
                    return p.getType().toString();
                });
            }
            case SUB_TYPE: {
                return "SB: " + this.prettyPrintHeader((int page) -> {
                    if (page == 0) {
                        return this.typeParam != null ? this.typeParam.toString() : "";
                    }
                    OlapResMdxTidyMaterializedTableCellsPage p = this.pages[page - 1];
                    return p.getTypeParam() != null ? p.getTypeParam().toString() : "";
                });
            }
            case FORMAT_STRING: {
                return "FS: " + (this.fs != null ? this.fs : "");
            }
            case SEPARATOR: {
                return "--";
            }
        }
        return "";
    }

    private String prettyPrintHeader(OlapResMdxTidyPrettyPrinterHeaderValue value) {
        StringBuilder name = new StringBuilder(value.get(0));
        if (this.pages != null) {
            name.append(" ( ");
            for (int pp = 0; pp < this.pages.length; ++pp) {
                if (pp > 1) {
                    name.append(", ");
                }
                name.append(value.get(pp + 1));
            }
            name.append(" )");
        }
        return name.toString();
    }

    @Override
    public String prettyPrint(OlapResMdxTidyMaterializedTable table, int rowIndex) {
        StringBuilder row = new StringBuilder(this.prettyPrintValueOrError(rowIndex));
        OlapResMdxTidyMaterializedTableCellsPage[] thisPages = this.pages;
        if (thisPages != null) {
            row.append(" ( ");
            for (int pp = 0; pp < thisPages.length; ++pp) {
                if (pp > 0) {
                    row.append(", ");
                }
                row.append(thisPages[pp].prettyPrintValueOrError(rowIndex));
            }
            row.append(" )");
        }
        return row.toString();
    }

    private String prettyPrintValueOrError(int rowIndex) {
        OlapResMdxTidyMaterializedTableCellError error;
        if (this.errors != null && (error = this.errors.get(rowIndex)) != null) {
            return error.getErrorCode();
        }
        Object value = this.getValue(rowIndex);
        if (value == null) {
            return "<empty>";
        }
        return value.toString();
    }

    public void assertCellsEquals(OlapResMdxTidyMaterializedTableCellsColumn other) {
        OlapResMdxTidyUtils.assertNull("errors", this.errors);
        OlapResMdxTidyUtils.assertNull("errors", other.errors);
        OlapResMdxTidyUtils.assertFalse("values not empty", this.values.isEmpty());
        OlapResMdxTidyUtils.assertEquals("values count", this.values.size(), other.values.size());
        OlapResMdxTidyUtils.assertEquals("values", this.values, other.values);
        OlapResMdxTidyUtils.assertEquals("valuesN", this.valuesN, other.valuesN);
        if (this.formattedValues != null || other.formattedValues != null) {
            OlapResMdxTidyUtils.assertNotNull("formatted-values", this.formattedValues);
            OlapResMdxTidyUtils.assertNotNull("formatted-values", other.formattedValues);
            OlapResMdxTidyUtils.assertFalse("formatted-values not empty", this.formattedValues.isEmpty());
            OlapResMdxTidyUtils.assertEquals("formatted-values count", this.formattedValues.size(), other.formattedValues.size());
            OlapResMdxTidyUtils.assertEquals("formatted-values", this.formattedValues, other.formattedValues);
        }
        if (this.backColors != null || other.backColors != null) {
            OlapResMdxTidyUtils.assertNotNull("back-colors", this.backColors);
            OlapResMdxTidyUtils.assertNotNull("back-colors", other.backColors);
            OlapResMdxTidyUtils.assertFalse("back-colors not empty", this.backColors.isEmpty());
            OlapResMdxTidyUtils.assertEquals("back-colors count", this.backColors.size(), other.backColors.size());
            OlapResMdxTidyUtils.assertEquals("back-colors", this.backColors, other.backColors);
        }
        if (this.foreColors != null || other.foreColors != null) {
            OlapResMdxTidyUtils.assertNotNull("fore-colors", this.foreColors);
            OlapResMdxTidyUtils.assertNotNull("fore-colors", other.foreColors);
            OlapResMdxTidyUtils.assertFalse("fore-colors not empty", this.foreColors.isEmpty());
            OlapResMdxTidyUtils.assertEquals("fore-colors count", this.foreColors.size(), other.foreColors.size());
            OlapResMdxTidyUtils.assertEquals("fore-colors", this.foreColors, other.foreColors);
        }
        OlapResMdxTidyUtils.assertEquals("fs", this.fs, other.fs);
        OlapResMdxTidyUtils.assertEquals("color", this.color, other.color);
        OlapResMdxTidyUtils.assertEquals("colors", this.colors, other.colors);
        OlapResMdxTidyUtils.assertEquals("type", (Object)this.type, (Object)other.type);
        OlapResMdxTidyUtils.assertEquals("type-param", (Object)this.typeParam, (Object)other.typeParam);
        if (this.pages == null) {
            OlapResMdxTidyUtils.assertNull("pages", other.pages);
        } else {
            OlapResMdxTidyUtils.assertEquals("pages size", this.pages.length, other.pages.length);
            for (int pp = 0; pp < this.pages.length; ++pp) {
                OlapResMdxTidyMaterializedTableCellsPage page = this.pages[pp];
                page.assertEquals(other.pages[pp]);
            }
        }
    }

    public void assertCellsMembersEquals(OlapResMdxTidyMaterializedTableCellsColumn other, String kind) {
        if (kind.equals("all") || kind.equals("caption")) {
            OlapResMdxTidyUtils.assertEquals("cells caption", this.caption, other.caption);
        }
    }

    public void assertCellsEquals(String[][] expected, int column) {
        OlapResMdxTidyUtils.assertTrue("values not empty", expected.length > 0);
        OlapResMdxTidyUtils.assertEquals("values count", expected.length, this.values.size());
        for (int rr = 0; rr < expected.length; ++rr) {
            String expectedValue = expected[rr][column];
            Object value = this.getValue(rr);
            OlapResMdxTidyUtils.assertEquals("value:" + rr, expectedValue, value);
        }
    }

    public void assertCellsEquals(boolean[][] expected, int column) {
        OlapResMdxTidyUtils.assertTrue("values not empty", expected.length > 0);
        OlapResMdxTidyUtils.assertEquals("values count", expected.length, this.values.size());
        for (int rr = 0; rr < expected.length; ++rr) {
            boolean expectedValue = expected[rr][column];
            Object value = this.getValue(rr);
            OlapResMdxTidyUtils.assertEquals("value:" + rr, expectedValue, value);
        }
    }

    public void assertCellsEquals(double[][] expected, int column, double delta) {
        OlapResMdxTidyUtils.assertTrue("values not empty", expected.length > 0);
        OlapResMdxTidyUtils.assertEquals("values count", expected.length, this.values.size());
        for (int rr = 0; rr < expected.length; ++rr) {
            double expectedValue = expected[rr][column];
            Object value = this.getValue(rr);
            double cellValue = value != null ? (value instanceof Long ? Double.valueOf(((Long)value).longValue()) : (Double)value) : 0.0;
            OlapResMdxTidyUtils.assertEquals("value:" + rr, expectedValue, cellValue, delta);
        }
    }

    public void assertCellsEquals(Object[][] expected, int column) {
        OlapResMdxTidyUtils.assertTrue("values not empty", expected.length > 0);
        OlapResMdxTidyUtils.assertEquals("values count", expected.length, this.values.size());
        for (int rr = 0; rr < expected.length; ++rr) {
            Object expectedValue = expected[rr][column];
            Object value = this.getValue(rr);
            OlapResMdxTidyUtils.assertEquals("value:" + rr, expectedValue, value);
        }
    }

    public void assertCellsBackColorEquals(String[][] expected, int column) {
        OlapResMdxTidyUtils.assertTrue("values not empty", expected.length > 0);
        OlapResMdxTidyUtils.assertEquals("values count", expected.length, this.values.size());
        for (int rr = 0; rr < expected.length; ++rr) {
            String expectedValue = expected[rr][column];
            String value = this.backColors != null ? this.backColors.get(rr) : null;
            OlapResMdxTidyUtils.assertEquals("value:" + rr, expectedValue, value);
        }
    }

    public void assertCellsPageEquals(int pageNB, String name, String caption, Object[][] expected, int column) {
        OlapResMdxTidyUtils.assertTrue("values not empty", expected.length > 0);
        OlapResMdxTidyUtils.assertEquals("values count", expected.length, this.values.size());
        OlapResMdxTidyMaterializedTableCellsPage page = this.pages[pageNB];
        page.assertValueEquals(name, caption, expected, column);
    }

    public void assertCellOnError(OlapErrorCode expected) {
        String errorCode = this.getErrorCode(0);
        OlapResMdxTidyUtils.assertNotNull("error", errorCode);
        OlapResMdxTidyUtils.assertEquals("error-code", expected.getValue(), errorCode);
    }

    public void assertCellPageOnError(OlapErrorCode expected) {
        OlapResMdxTidyUtils.assertNull("error", this.getErrorCode(0));
        OlapResMdxTidyUtils.assertEquals("page count", 1, this.pages.length);
        OlapResMdxTidyMaterializedTableCellsPage page = this.pages[0];
        page.assertOnError(expected);
    }
}

