/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.builder.nonempty;

import crazydev.iccube.collection.IOlapIterator;
import crazydev.iccube.collection.olapiterator.OlapCombinationIteratorT;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTable;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilder;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderCellsColumn;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderCellsPage;
import crazydev.iccube.olap.entity.result.tidy.builder.nonempty.OlapResMdxTidyBuilderRowIndexHelper;
import crazydev.iccube.olap.entity.result.tidy.builder.nonempty.OlapResMdxTidyNonEmptyAxisTuples;
import crazydev.iccube.olap.entity.result.tidy.builder.nonempty.OlapResMdxTidyNonEmptyCellValue;
import crazydev.iccube.olap.entity.result.tidy.builder.nonempty.OlapResMdxTidyNonEmptyIndexer;
import crazydev.iccube.olap.entity.result.tidy.builder.nonempty.OlapResMdxTidyNonEmptyTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFRegularCellsExecutor;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellScalarValue;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;
import crazydev.iccube.olap.eval.result.OlapEvalResultSi;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class OlapResMdxTidyBuilderNonEmpty {
    private final OlapResMdxTidyTable table;
    private final List<OlapResMdxTidyNonEmptyAxisTuples> axes = new ArrayList<OlapResMdxTidyNonEmptyAxisTuples>();
    private final boolean allAxesWithNonEmpty;
    private final OlapResMdxTidyNonEmptyIndexer indexer = new OlapResMdxTidyNonEmptyIndexer();
    private final List<OlapResMdxTidyBuilderCellsColumn> cellsColumns;
    private final AtomicInteger addCellValueCount = new AtomicInteger();

    public OlapResMdxTidyBuilderNonEmpty(OlapResMdxTidyTable table) {
        this.table = table;
        this.cellsColumns = OlapResMdxTidyBuilder.createColumnsFromAxis0(table);
        boolean axis0asColumns = table.isAxis0asColumns();
        boolean hasPaging = table.isWithPaging();
        int axisCount = table.getAxisCount();
        int from = axis0asColumns ? 1 : 0;
        int to = hasPaging ? axisCount - 1 : axisCount;
        int hasNonEmptyCount = 0;
        for (int aa = from; aa < to; ++aa) {
            boolean hasNonEmpty = table.hasNonEmpty(aa);
            this.axes.add(new OlapResMdxTidyNonEmptyAxisTuples(aa, hasNonEmpty));
            if (!hasNonEmpty) continue;
            ++hasNonEmptyCount;
        }
        this.allAxesWithNonEmpty = hasNonEmptyCount == this.axes.size();
    }

    public void addCellValue(IOlapEvaluationExceptionContext context, int rowIndex, OlapTuple[] cellTuple, OlapEvalResultCellValue cellValue) {
        int count = this.addCellValueCount.incrementAndGet();
        if (count % 1000 == 0) {
            this.table.getContext().assertNotCancelling("tidy-builder:add-cell-value(" + this.addCellValueCount.get() + ")");
        }
        if (count > 0 && count % 100000 == 0) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] cells : " + count + " table non-empty rows : " + this.getRowCountNE()));
        }
        this.populateAxes(rowIndex, cellTuple, cellValue);
        if (!cellValue.isEmpty()) {
            this.populateCellsColumns(rowIndex, cellTuple, cellValue);
        }
    }

    private void populateAxes(int rowIndex, OlapTuple[] cellTuple, OlapEvalResultCellValue cellValue) {
        int[] Si = cellValue.getCellSi().getSi();
        boolean axis0asColumns = this.table.isAxis0asColumns();
        boolean hasPaging = this.table.isWithPaging();
        int axisCount = this.table.getAxisCount();
        int from = axis0asColumns ? 1 : 0;
        int to = hasPaging ? axisCount - 1 : axisCount;
        for (int aa = from; aa < to; ++aa) {
            OlapResMdxTidyNonEmptyAxisTuples axis = this.axes.get(aa - from);
            OlapTuple tuple = cellTuple[aa];
            int tupleIndex = Si[aa];
            axis.addTuple(rowIndex, tuple, tupleIndex, cellValue);
        }
    }

    private void populateCellsColumns(int rowIndex, OlapTuple[] cellTuple, OlapEvalResultCellValue cellValue) {
        int rowPos = this.indexer.getRowPos(rowIndex);
        int[] Si = cellValue.getCellSi().getSi();
        boolean axis0asColumns = this.table.isAxis0asColumns();
        if (!axis0asColumns) {
            return;
        }
        int si = Si[0];
        OlapResMdxTidyBuilderCellsColumn column = this.cellsColumns.get(si);
        column.addCell(this.table.isWithDebugger(), rowPos, cellTuple, cellValue);
    }

    public int getRowCountNE() {
        int count = 1;
        for (OlapResMdxTidyNonEmptyAxisTuples axis : this.axes) {
            count *= axis.getTupleCountNE();
        }
        return count;
    }

    public void onEvaluateCellValuesDone(boolean tidyMaxRowCountReached, int rowIndex) {
        int rowCount = rowIndex + 1;
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] evaluate cell-values [tidy] done [tidy-max-row-count-reached:" + tidyMaxRowCountReached + "][row-count:" + rowCount + "]"));
        for (OlapResMdxTidyBuilderCellsColumn column : this.cellsColumns) {
            column.onEvaluateCellValuesDone(rowCount, this.table);
        }
        for (OlapResMdxTidyBuilderCellsColumn column : this.cellsColumns) {
            column.assertConsistency(rowCount);
        }
        int rowCountNE = this.performNonEmptyProcessing(tidyMaxRowCountReached);
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] evaluate cell-values [tidy] completed [row-count:" + rowCountNE + "]"));
    }

    private int performNonEmptyProcessing(boolean tidyMaxRowCountReached) {
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] evaluate cell-values [tidy] NON EMPTY processing started [tidyMaxRowCountReached:" + tidyMaxRowCountReached + "]"));
        List<OlapResMdxTidyNonEmptyTuple> axis0 = this.performNonEmptyProcessingForAxis0();
        List<OlapResMdxTidyNonEmptyTuple> axisPaging = this.performNonEmptyProcessingForAxisPaging();
        List<OlapTuple> axis0_ = axis0.stream().map(OlapResMdxTidyNonEmptyTuple::getTuple).collect(Collectors.toList());
        List<OlapTuple> axisPaging_ = axisPaging != null ? axisPaging.stream().map(OlapResMdxTidyNonEmptyTuple::getTuple).collect(Collectors.toList()) : null;
        this.table.initForNE(axis0_, axisPaging_);
        OlapCombinationIteratorT<OlapResMdxTidyNonEmptyTuple> cells = this.createCellCombinationIterator(axis0, axisPaging);
        OlapResMdxTidyBuilderRowIndexHelper rowIndices = this.createCellRowIndices();
        if (OlapResMdxTidyBuilderNonEmpty.hasNoData(cells)) {
            boolean axis0asColumns = this.table.isAxis0asColumns();
            if (!axis0asColumns) {
                OlapResMdxTidyNonEmptyTuple tuple;
                OlapResMdxTidyNonEmptyAxisTuples axis = this.axes.get(0);
                IOlapIterator<OlapResMdxTidyNonEmptyTuple> tuples = axis.getSortedTuples();
                tuples.reset();
                OlapMdxStatementExecutionContext context = this.table.getContext();
                int rowIndex = -1;
                boolean truncated = false;
                while ((tuple = tuples.next()) != null) {
                    if (rowIndex + 1 >= this.table.getTidyMaxRowCount()) {
                        truncated = true;
                        break;
                    }
                    OlapTuple[] cellTuple = new OlapTuple[]{tuple.getTuple()};
                    OlapEvalResultCellValue cellValue = this.createNonEmptyCellValueSA(++rowIndex);
                    this.table.addCellValue((IOlapEvaluationExceptionContext)context, rowIndex, cellTuple, cellValue);
                }
                boolean tidyMaxRowCountReachedEx = tidyMaxRowCountReached || truncated;
                this.table.onEvaluateCellValuesDone(tidyMaxRowCountReachedEx, rowIndex);
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] evaluate cell-values [tidy] NON EMPTY (single-axis) processing completed [tidyMaxRowCountReached:" + tidyMaxRowCountReachedEx + "]"));
            } else {
                OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] evaluate cell-values [tidy] NON EMPTY processing completed wo/ data");
            }
        } else {
            OlapResMdxTidyNonEmptyTuple[] cellTupleNE;
            cells.reset();
            OlapMdxStatementExecutionContext context = this.table.getContext();
            int[] cellSi_ = new int[this.axes.size()];
            OlapTuple[] cellTuple = new OlapTuple[cells.axisCount()];
            while ((cellTupleNE = cells.next()) != null) {
                int ii;
                for (ii = 0; ii < cellSi_.length; ++ii) {
                    cellSi_[ii] = cellTupleNE[ii + 1].getSi();
                }
                for (ii = 0; ii < cellTupleNE.length; ++ii) {
                    cellTuple[ii] = cellTupleNE[ii].getTuple();
                }
                int rowIndex = cells.rowIndex();
                int[] cellSi = cells.Si();
                OlapEvalResultCellValue cellValue = this.createNonEmptyCellValue(rowIndices, cellTupleNE, cellSi_, cellSi);
                this.table.addCellValue((IOlapEvaluationExceptionContext)context, rowIndex, cellTuple, cellValue);
            }
            boolean tidyMaxRowCountReachedEx = tidyMaxRowCountReached || cells.isTidyMaxRowCountReached();
            this.table.onEvaluateCellValuesDone(tidyMaxRowCountReachedEx, cells.rowIndex());
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] evaluate cell-values [tidy] NON EMPTY processing completed [tidyMaxRowCountReached:" + tidyMaxRowCountReachedEx + "]"));
        }
        return this.table.getRowCount();
    }

    private OlapEvalResultCellValue createNonEmptyCellValueSA(int rowIndex) {
        OlapEvalResultCellScalarValue cellValue = new OlapEvalResultCellScalarValue(new OlapEvalResultSi(new int[]{rowIndex}), OlapEmptyEntity.INSTANCE);
        return cellValue;
    }

    private OlapEvalResultCellValue createNonEmptyCellValue(OlapResMdxTidyBuilderRowIndexHelper rowIndices, OlapResMdxTidyNonEmptyTuple[] cellTupleNE, int[] cellSi_, int[] cellSi) {
        int rowIndex = rowIndices.computeRowIndex(cellSi_);
        int rowPos = this.indexer.getRowPos(rowIndex);
        int cellSi0_ = cellTupleNE[0].getSi();
        OlapResMdxTidyBuilderCellsColumn cellsColumn = this.cellsColumns.get(cellSi0_);
        int pagingAxis = cellsColumn.getPagingAxis();
        int pageIndex = pagingAxis != -1 ? cellSi[pagingAxis] : 0;
        OlapResMdxTidyBuilderCellsPage page = cellsColumn.getPage(pageIndex);
        OlapResMdxTidyNonEmptyCellValue cellValue = new OlapResMdxTidyNonEmptyCellValue(new OlapEvalResultSi(cellSi), page, rowPos);
        return cellValue;
    }

    private List<OlapResMdxTidyNonEmptyTuple> performNonEmptyProcessingForAxis0() {
        boolean hasNonEmpty = this.table.hasNonEmpty(0);
        ArrayList<OlapResMdxTidyNonEmptyTuple> axis0 = new ArrayList<OlapResMdxTidyNonEmptyTuple>();
        int tupleIndex = 0;
        for (OlapResMdxTidyBuilderCellsColumn cellsColumn : this.cellsColumns) {
            if (!hasNonEmpty || cellsColumn.hasNonEmptyCells()) {
                axis0.add(new OlapResMdxTidyNonEmptyTuple(cellsColumn.getTuple(), tupleIndex));
            }
            ++tupleIndex;
        }
        return axis0;
    }

    @Nullable
    private List<OlapResMdxTidyNonEmptyTuple> performNonEmptyProcessingForAxisPaging() {
        if (!this.table.isWithPaging()) {
            return null;
        }
        if (this.cellsColumns.isEmpty()) {
            return null;
        }
        OlapResMdxTidyBuilderCellsColumn aColumn = this.cellsColumns.get(0);
        int pageCount = aColumn.getPageCount();
        if (pageCount == 0) {
            return null;
        }
        ArrayList<OlapResMdxTidyNonEmptyTuple> paging = new ArrayList<OlapResMdxTidyNonEmptyTuple>();
        for (int pp = 0; pp < pageCount; ++pp) {
            OlapResMdxTidyBuilderCellsPage page = aColumn.getPage(pp);
            paging.add(new OlapResMdxTidyNonEmptyTuple(page.getTuple(), pp));
        }
        return paging;
    }

    private OlapCombinationIteratorT<OlapResMdxTidyNonEmptyTuple> createCellCombinationIterator(List<OlapResMdxTidyNonEmptyTuple> axis0, List<OlapResMdxTidyNonEmptyTuple> axisPaging) {
        ArrayList iterators = new ArrayList();
        ArrayList<Integer> iteratorsPOS = new ArrayList<Integer>();
        int rowIteratorsCount = this.axes.size();
        for (int aa = 0; aa < this.axes.size(); ++aa) {
            OlapResMdxTidyNonEmptyAxisTuples axis = this.axes.get(aa);
            IOlapIterator<OlapResMdxTidyNonEmptyTuple> axisTuples = axis.getSortedTuples();
            iterators.add(axisTuples);
            iteratorsPOS.add(aa + 1);
        }
        iterators.add(OlapIteratorFactory.instance(axis0));
        iteratorsPOS.add(0);
        if (axisPaging != null) {
            iterators.add(OlapIteratorFactory.instance(axisPaging));
            iteratorsPOS.add(iterators.size() - 1);
        }
        return new OlapCombinationIteratorT<OlapResMdxTidyNonEmptyTuple>(OlapResMdxTidyNonEmptyTuple.class, this.table, iterators, iteratorsPOS, rowIteratorsCount);
    }

    private OlapResMdxTidyBuilderRowIndexHelper createCellRowIndices() {
        int[] Uk = new int[this.axes.size()];
        for (int idx = 0; idx < Uk.length; ++idx) {
            Uk[idx] = this.axes.get(idx).getAxisLength();
        }
        return new OlapResMdxTidyBuilderRowIndexHelper(Uk);
    }

    private static boolean hasNoData(OlapCombinationIteratorT<OlapResMdxTidyNonEmptyTuple> cells) {
        cells.reset();
        OlapResMdxTidyNonEmptyTuple[] cellTuple = cells.next();
        if (cellTuple == null) {
            return true;
        }
        int[] Si = cells.Si();
        return GFRegularCellsExecutor.isEmptyCombinations(Si);
    }
}

