/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.builder;

import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapNameIdentifiableEntity;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierNamePart;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapMemberUniqueNameType;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyManager;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperties;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.entity.result.OlapResAxisName;
import crazydev.iccube.olap.entity.result.OlapResIntrinsicScopedDimensionProperty;
import crazydev.iccube.olap.entity.result.OlapResScopedDimensionProperty;
import crazydev.iccube.olap.entity.result.OlapResUserDefinedScopedDimensionProperty;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTable;
import crazydev.iccube.olap.entity.result.tidy.TidyTableDimensionPropertyColumnMeta;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilder;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderColumn;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderMembersAxis;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxUniqueNames;
import crazydev.iccube.olap.entity.result.tidy.common.OlapResMdxTidyBuilderList;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableMemberType;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.mdx.set.OlapVisualTotalsManager;
import crazydev.iccube.olap.eval.select.OlapAxisInstr;
import crazydev.iccube.olap.eval.select.OlapTopLevelSelectInstr;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapTopLevelAxisEvaluationContext;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapDimensionPropertiesTidyPostProcessorArg;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapResMdxTidyBuilderMembersColumn
extends OlapResMdxTidyBuilderColumn {
    private final Object LOCK = new Object();
    private final OlapResMdxTidyBuilderMembersAxis membersAxis;
    private final OlapHierarchy hierarchy;
    private final int hierarchyIdx;
    private final Map<OlapMember, Integer> membersIndex = new HashMap<OlapMember, Integer>();
    private final OlapResMdxTidyBuilderList<Integer> tupleIndexToMemberIndex = new OlapResMdxTidyBuilderList();
    private final OlapResMdxTidyBuilderList<OlapMember> members = new OlapResMdxTidyBuilderList();
    private int tupleIndexToMemberIndexSize;
    private int membersSize;
    @Nullable
    private OlapLevel level;
    @Nullable
    private Integer allMemberIndex;
    private OlapResMdxTidyMaterializedTableMemberType type;
    private Map<String, TidyTableDimensionPropertyColumnMeta> dpMetas;
    private List<String> dpNames;
    private Map<String, OlapScalarEntityTidyType> dpTypes;
    private Map<String, ArrayList<Object>> dpValues;

    public OlapResMdxTidyBuilderMembersColumn(OlapResAxisName axis, OlapHierarchy hierarchy, int hierarchyIdx, OlapResMdxTidyBuilderMembersAxis membersAxis) {
        super(axis);
        this.hierarchy = hierarchy;
        this.hierarchyIdx = hierarchyIdx;
        this.membersAxis = membersAxis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void assertConsistency(int rowCount) {
        super.assertConsistency(rowCount);
        Object object = this.LOCK;
        synchronized (object) {
            this.membersAxis.assertConsistency(rowCount);
            int tupleIndexCount = this.tupleIndexToMemberIndexSize + 1;
            for (int ii = 0; ii < tupleIndexCount; ++ii) {
                if (this.tupleIndexToMemberIndex.getItem(ii) != null) continue;
                throw new RuntimeException("internal error: inconsistent members tupleIndexToMemberIndex [" + ii + "] null");
            }
        }
    }

    @Override
    String getAssertName() {
        return this.axis.getNumber() + "." + this.hierarchyIdx + "." + this.hierarchy.getNameX();
    }

    public OlapHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public int getHierarchyIdx() {
        return this.hierarchyIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapLevel getLevel() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.level;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Integer getAllMemberIndex() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.allMemberIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapMember getAllMember(int index) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapMember member = this.members.getItem(index);
            if (member == null) {
                throw new RuntimeException("internal error : unexpected missing all-member : " + index);
            }
            if (!member.isAll()) {
                throw new RuntimeException("internal error : unexpected non all-member : " + index + " " + member.getNameX());
            }
            return member;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapResMdxTidyMaterializedTableMemberType getType() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAxisLength() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.tupleIndexToMemberIndexSize + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getRowIndexToTupleIndex() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersAxis.getRowIndexToTupleIndexSize() + 1;
            ArrayList<Integer> content = new ArrayList<Integer>(this.rowCount());
            for (int ii = 0; ii < count; ++ii) {
                content.add(this.membersAxis.getTupleIndex(ii));
            }
            return content;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getTupleIndexToMemberIndex() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.tupleIndexToMemberIndexSize + 1;
            ArrayList<Integer> content = new ArrayList<Integer>(count);
            for (int ii = 0; ii < count; ++ii) {
                content.add(this.tupleIndexToMemberIndex.getItem(ii));
            }
            return content;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCaption(Locale locale, OlapNameContext context, @Nullable OlapVisualTotalsManager visualTotalManager, int pos) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapMember member = this.members.getItem(pos);
            String caption = member.getCaption(locale, context);
            if (visualTotalManager != null) {
                String vCaption = visualTotalManager.getCaption(member, caption);
                return vCaption;
            }
            return caption;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCaptions(Locale locale, OlapNameContext context, @Nullable OlapVisualTotalsManager visualTotalManager) {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<String> values = new ArrayList<String>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                String caption = member.getCaption(locale, context);
                if (visualTotalManager != null) {
                    String vCaption = visualTotalManager.getCaption(member, caption);
                    values.add(vCaption);
                    continue;
                }
                values.add(caption);
            }
            return values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getCaptionsN(Locale locale, OlapNameContext context, @Nullable OlapVisualTotalsManager visualTotalManager, boolean ignoreAllMember) {
        Object object = this.LOCK;
        synchronized (object) {
            boolean sameAsNames = true;
            int count = this.membersSize;
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                if (ignoreAllMember && member.isAll()) continue;
                String caption = member.getCaptionEx(locale, context);
                if (caption != null) {
                    sameAsNames = false;
                    break;
                }
                if (visualTotalManager == null || !visualTotalManager.hasCaption(member)) continue;
                sameAsNames = false;
                break;
            }
            if (sameAsNames) {
                return null;
            }
            return this.getCaptions(locale, context, visualTotalManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName(OlapNameContext context, int pos) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapMember member = this.members.getItem(pos);
            return member.getName(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getNames(OlapNameContext context) {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<String> values = new ArrayList<String>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                values.add(member.getName(context));
            }
            return values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUniqueName(OlapNameContext context, int pos) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapMember member = this.members.getItem(pos);
            return member.getUniqueName(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapResMdxUniqueNames<String> getUniqueNames(OlapNameContext context) {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<String> values = new ArrayList<String>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                values.add(member.getUniqueName(context));
            }
            return new OlapResMdxUniqueNames<String>(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapResMdxUniqueNames<?> getUniqueNamesN(OlapNameContext context, boolean ignoreAllMember) {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<Object> values = new ArrayList<Object>(count);
            block7: for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                OlapMemberUniqueNameType uniqueNameType = member.getUniqueNameType();
                switch (uniqueNameType) {
                    case LEVEL_KEY: 
                    case PARENT_KEY: {
                        if (this.isKeyValidForUniqueNameGenerator(member)) {
                            values.add(uniqueNameType.getTidyTableValue());
                            continue block7;
                        }
                        values.add(member.getUniqueName(context));
                        continue block7;
                    }
                    case LEVEL_NAME: 
                    case PARENT_NAME: {
                        values.add(uniqueNameType.getTidyTableValue());
                        continue block7;
                    }
                    default: {
                        values.add(member.getUniqueName(context));
                    }
                }
            }
            Object uniqueValue = null;
            for (int ii = 0; ii < values.size(); ++ii) {
                Object value = values.get(ii);
                if (ignoreAllMember && this.allMemberIndex != null && ii == this.allMemberIndex) continue;
                if (uniqueValue == null) {
                    uniqueValue = value;
                    continue;
                }
                if (uniqueValue.equals(value)) continue;
                uniqueValue = null;
                break;
            }
            if (uniqueValue != null) {
                values.clear();
                values.add(uniqueValue);
            }
            return new OlapResMdxUniqueNames(values);
        }
    }

    private boolean isKeyValidForUniqueNameGenerator(OlapMember member) {
        OlapMemberKey key = member.getKey();
        if (key == null || key.isNoValueKey() || !key.isSingleValue()) {
            return false;
        }
        OlapBuilderInputType[] types = key.getTypes();
        if (types == null || types.length != 1) {
            return false;
        }
        OlapBuilderInputType type = types[0];
        return switch (type) {
            case OlapBuilderInputType.STRING, OlapBuilderInputType.SHORT, OlapBuilderInputType.INTEGER, OlapBuilderInputType.LONG, OlapBuilderInputType.DATE, OlapBuilderInputType.DATETIME -> true;
            default -> false;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildrenCount(OlapCalculatedMemberManager calcMemberManager, OlapMemberFilter filter, int pos) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapMember member = this.members.getItem(pos);
            int childrenCount = member.getChildrenCountForDrilldown(calcMemberManager, filter);
            return childrenCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getChildrenCounts(OlapCalculatedMemberManager calcMemberManager, OlapMemberFilter filter) {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<Integer> values = new ArrayList<Integer>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                int childrenCount = member.getChildrenCountForDrilldown(calcMemberManager, filter);
                values.add(childrenCount);
            }
            return values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getChildrenCountsN(OlapCalculatedMemberManager calcMemberManager, OlapMemberFilter filter, boolean ignoreAllMember) {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<Integer> values = new ArrayList<Integer>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                int childrenCount = member.getChildrenCountForDrilldown(calcMemberManager, filter);
                values.add(childrenCount);
            }
            Integer uniqueValue = null;
            for (int ii = 0; ii < values.size(); ++ii) {
                if (ignoreAllMember && this.allMemberIndex != null && ii == this.allMemberIndex) continue;
                Integer value = (Integer)values.get(ii);
                if (uniqueValue == null) {
                    uniqueValue = value;
                    continue;
                }
                if (uniqueValue.equals(value)) continue;
                uniqueValue = null;
                break;
            }
            if (uniqueValue != null) {
                values.clear();
                values.add(uniqueValue);
            }
            return values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLevelCaption(Locale locale, OlapNameContext context, int pos) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapMember member = this.members.getItem(pos);
            OlapLevel level = member.getLevel();
            return level.getCaption(locale, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLevelCaptions(Locale locale, OlapNameContext context) {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<String> values = new ArrayList<String>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                OlapLevel level = member.getLevel();
                values.add(level.getCaption(locale, context));
            }
            return values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLevelNames(OlapNameContext context) {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<String> values = new ArrayList<String>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                OlapLevel level = member.getLevel();
                values.add(level.getName(context));
            }
            return values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLevelUniqueNames(OlapNameContext context) {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<String> values = new ArrayList<String>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                OlapLevel level = member.getLevel();
                values.add(level.getUniqueName(context));
            }
            return values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLevelDepth(int pos) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapMember member = this.members.getItem(pos);
            OlapLevel level = member.getLevel();
            return level.getDepth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getLevelDepths() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<Integer> values = new ArrayList<Integer>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                OlapLevel level = member.getLevel();
                values.add(level.getDepth());
            }
            return values;
        }
    }

    public int getLevelDepthsR__(int pos) {
        List<Integer> levelDepthsR = this.getLevelDepthsR();
        int levelDepthR = levelDepthsR.get(pos);
        return levelDepthR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getLevelDepthsR() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            HashSet<OlapMember> walked = new HashSet<OlapMember>();
            OlapMember[] sortedMembers = new OlapMember[count];
            int[] sortedMembersPos = new int[count];
            int m = 0;
            for (int ii = 0; ii < this.tupleIndexToMemberIndexSize + 1; ++ii) {
                Integer pos = this.tupleIndexToMemberIndex.getItem(ii);
                OlapMember member = this.members.getItem(pos);
                if (walked.contains(member)) continue;
                sortedMembers[m] = member;
                sortedMembersPos[m] = pos;
                walked.add(member);
                ++m;
            }
            int[] values = new int[count];
            Stack<OlapMember> parentStack = new Stack<OlapMember>();
            for (int ii = 0; ii < count; ++ii) {
                int value;
                OlapMember member = sortedMembers[ii];
                int pos = sortedMembersPos[ii];
                values[pos] = value = this.getLevelDepthR(parentStack, member);
            }
            return Arrays.stream(values).boxed().collect(Collectors.toList());
        }
    }

    @Nullable
    private static OlapScalarEntity<?> fixMemberProperty(@Nullable OlapScalarEntity value) {
        if (value == null || value.isMdxNull()) {
            return null;
        }
        return value;
    }

    @Nullable
    private static <T> List<T> fixAllNulls(List<T> values) {
        for (T value : values) {
            if (value == null) continue;
            return values;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getKey(int pos) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapMember member = this.members.getItem(pos);
            OlapMemberKey key = member.getKey();
            return key != null ? key.toTidyTableValue() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<Object> getKeys() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<Object> values = new ArrayList<Object>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                OlapMemberKey key = member.getKey();
                values.add(key != null ? key.toTidyTableValue() : null);
            }
            return OlapResMdxTidyBuilderMembersColumn.fixAllNulls(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapResMdxUniqueNames<String> getParentUniqueNames(OlapNameContext context) {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<String> values = new ArrayList<String>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                OlapMember parent = member.getParent();
                values.add(parent != null ? parent.getUniqueName(context) : null);
            }
            List valuesF = OlapResMdxTidyBuilderMembersColumn.fixAllNulls(values);
            if (valuesF == null) {
                return null;
            }
            return new OlapResMdxUniqueNames<String>(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getParentUniqueName(OlapNameContext context, int pos) {
        Object object = this.LOCK;
        synchronized (object) {
            if (pos < this.membersSize) {
                OlapMember member = this.members.getItem(pos);
                OlapMember parent = member.getParent();
                String string = parent != null ? parent.getUniqueName(context) : null;
                return string;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAll(int pos) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapMember member = this.members.getItem(pos);
            return member.isAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<Boolean> getAlls() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<Boolean> values = new ArrayList<Boolean>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                values.add(member.isAll() ? Boolean.valueOf(true) : null);
            }
            return OlapResMdxTidyBuilderMembersColumn.fixAllNulls(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getFormatString(int pos) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapMember member = this.members.getItem(pos);
            String formatString = OlapResMdxTidyBuilder.memberFormatString(member);
            return formatString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getFormatStrings() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<String> values = new ArrayList<String>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                String formatString = OlapResMdxTidyBuilder.memberFormatString(member);
                values.add(formatString);
            }
            return OlapResMdxTidyBuilderMembersColumn.fixAllNulls(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getFormatStringsN(boolean ignoreAllMember) {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<String> values = new ArrayList<String>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                String formatString = OlapResMdxTidyBuilder.memberFormatString(member);
                values.add(formatString);
            }
            String[] uniqueValue = null;
            for (int ii = 0; ii < values.size(); ++ii) {
                if (ignoreAllMember && this.allMemberIndex != null && ii == this.allMemberIndex) continue;
                String value = (String)values.get(ii);
                if (uniqueValue == null) {
                    uniqueValue = new String[]{value};
                    continue;
                }
                if (Objects.equals(uniqueValue[0], value)) continue;
                uniqueValue = null;
                break;
            }
            if (uniqueValue != null) {
                if (uniqueValue[0] != null) {
                    return Collections.singletonList(uniqueValue[0]);
                }
                return null;
            }
            return OlapResMdxTidyBuilderMembersColumn.fixAllNulls(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getColor(OlapMdxStatementExecutionContext context, int pos) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapMember member = this.members.getItem(pos);
            String color = OlapResMdxTidyBuilder.memberColor(context, member);
            return color;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getColors(OlapMdxStatementExecutionContext context) {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<String> values = new ArrayList<String>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                String color = OlapResMdxTidyBuilder.memberColor(context, member);
                values.add(color);
            }
            return OlapResMdxTidyBuilderMembersColumn.fixAllNulls(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getIso2s(int pos) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapMember member = this.members.getItem(pos);
            OlapScalarEntity<?> prop = OlapResMdxTidyBuilderMembersColumn.fixMemberProperty(member.getPropertyValue(null, "@Ic3iso2"));
            return prop != null ? prop.asString() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getIso2s() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<String> values = new ArrayList<String>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                OlapScalarEntity<?> prop = OlapResMdxTidyBuilderMembersColumn.fixMemberProperty(member.getPropertyValue(null, "@Ic3iso2"));
                values.add(prop != null ? prop.asString() : null);
            }
            return OlapResMdxTidyBuilderMembersColumn.fixAllNulls(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Number getLat(int pos) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapMember member = this.members.getItem(pos);
            OlapScalarEntity<?> prop = OlapResMdxTidyBuilderMembersColumn.fixMemberProperty(member.getPropertyValue(null, "@Ic3Lat"));
            return prop != null ? (Number)prop.toLatLongValue() : (Number)null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<Number> getLats() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<Number> values = new ArrayList<Number>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                OlapScalarEntity<?> prop = OlapResMdxTidyBuilderMembersColumn.fixMemberProperty(member.getPropertyValue(null, "@Ic3Lat"));
                values.add(prop != null ? (Number)prop.toLatLongValue() : (Number)null);
            }
            return OlapResMdxTidyBuilderMembersColumn.fixAllNulls(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Number getLong(int pos) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapMember member = this.members.getItem(pos);
            OlapScalarEntity<?> prop = OlapResMdxTidyBuilderMembersColumn.fixMemberProperty(member.getPropertyValue(null, "@Ic3Long"));
            return prop != null ? (Number)prop.toLatLongValue() : (Number)null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<Number> getLongs() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.membersSize;
            ArrayList<Number> values = new ArrayList<Number>(count);
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = this.members.getItem(ii);
                OlapScalarEntity<?> prop = OlapResMdxTidyBuilderMembersColumn.fixMemberProperty(member.getPropertyValue(null, "@Ic3Long"));
                values.add(prop != null ? (Number)prop.toLatLongValue() : (Number)null);
            }
            return OlapResMdxTidyBuilderMembersColumn.fixAllNulls(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Map<String, TidyTableDimensionPropertyColumnMeta> getDpMetas() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.dpMetas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getDpNames() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.dpNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Map<String, OlapScalarEntityTidyType> getDpTypes() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.dpTypes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Map<String, ArrayList<Object>> getDpValues() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.dpValues;
        }
    }

    private int getLevelDepthR(Stack<OlapMember> parentStack, OlapMember member) {
        while (!parentStack.isEmpty()) {
            if (parentStack.peek().isAncestor(member)) {
                parentStack.push(member);
                return parentStack.size() - 1;
            }
            parentStack.pop();
        }
        parentStack.push(member);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMemberCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.membersSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(int rowIndex, int tupleIndex, OlapMember member) {
        Object object = this.LOCK;
        synchronized (object) {
            int memberIndex = this.membersIndex.computeIfAbsent(member, key -> this.membersIndex.size());
            this.tupleIndexToMemberIndex.addItem(tupleIndex, memberIndex);
            this.tupleIndexToMemberIndexSize = Math.max(this.tupleIndexToMemberIndexSize, tupleIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onEvaluateCellValuesDoneEx(int rowCount, @Nullable OlapResMdxTidyTable table) {
        Object object = this.LOCK;
        synchronized (object) {
            HashSet<OlapLevel> levels = new HashSet<OlapLevel>();
            Integer allMemberIdx = null;
            boolean typeOK = true;
            OlapResMdxTidyMaterializedTableMemberType type = null;
            int cc = 0;
            for (Map.Entry<OlapMember, Integer> entry : this.membersIndex.entrySet()) {
                OlapMember member = entry.getKey();
                levels.add(member.getLevel());
                if (member.isAll()) {
                    allMemberIdx = entry.getValue();
                }
                if (typeOK) {
                    OlapMemberKey key = member.getKey();
                    if (key != null && key.isSingleValue()) {
                        Object value = key.asJavaNativeValue();
                        if (value instanceof LocalDate && (type == null || type == OlapResMdxTidyMaterializedTableMemberType.date)) {
                            type = OlapResMdxTidyMaterializedTableMemberType.date;
                        } else if (value instanceof LocalDateTime && (type == null || type == OlapResMdxTidyMaterializedTableMemberType.time)) {
                            type = OlapResMdxTidyMaterializedTableMemberType.time;
                        } else {
                            typeOK = false;
                            type = null;
                        }
                    } else {
                        typeOK = false;
                        type = null;
                    }
                }
                this.members.addItem(entry.getValue(), member);
                if (++cc % 1000 != 0 || table == null) continue;
                table.getContext().assertNotCancelling("materialized-tidy:on-cell-evaluation-done");
            }
            OlapLevel[] levelsEx = levels.toArray(new OlapLevel[levels.size()]);
            if (levelsEx.length == 1) {
                this.level = levelsEx[0];
            } else if (levelsEx.length == 2 && allMemberIdx != null) {
                this.level = levelsEx[!levelsEx[0].isAll() ? 0 : 1];
                this.allMemberIndex = allMemberIdx;
            }
            if (typeOK) {
                this.type = type;
            }
            this.membersSize = this.membersIndex.size();
            this.membersIndex.clear();
            if (table != null) {
                this.evaluateMemberProperties(table, levels);
            }
        }
    }

    private void evaluateMemberProperties(OlapResMdxTidyTable table, Set<OlapLevel> levels) {
        List<Object> requestedProperties;
        int axis = (int)this.axis.getNumber();
        OlapAxisInstr axisInstr = table.getAxisInstr(axis);
        OlapTopLevelAxisEvaluationContext axisEvalContext = new OlapTopLevelAxisEvaluationContext(table.getContext(), axisInstr);
        if (axisInstr.isAllMemberProperties()) {
            requestedProperties = new ArrayList();
            walkedProperties = new HashSet<OlapUserDefinedMemberProperty>();
            for (OlapLevel olapLevel : levels) {
                props = olapLevel.getMemberProperties(table.getSchemaPermissionsDimensionFilter());
                for (OlapUserDefinedMemberProperty prop : props) {
                    if (walkedProperties.contains(prop)) continue;
                    walkedProperties.add(prop);
                    if (OlapMemberPropertyManager.IC3_PROPERTY_NAMES_EX.contains(prop.getName())) continue;
                    requestedProperties.add(new OlapResUserDefinedScopedDimensionProperty(prop, (OlapNameIdentifiableEntity)olapLevel));
                }
            }
            requestedProperties.add(new OlapResIntrinsicScopedDimensionProperty(OlapUserDefinedMemberProperties.DESCRIPTION, null));
            requestedProperties.add(new OlapResIntrinsicScopedDimensionProperty(OlapUserDefinedMemberProperties.IS_CATEGORY, null));
            requestedProperties.add(new OlapResIntrinsicScopedDimensionProperty(OlapUserDefinedMemberProperties.IS_CALCULATED, null));
            requestedProperties.add(new OlapResIntrinsicScopedDimensionProperty(OlapUserDefinedMemberProperties.NON_EMPTY_BEHAVIOR, null));
            requestedProperties.add(new OlapResIntrinsicScopedDimensionProperty(OlapUserDefinedMemberProperties.IS_UNKNOWN_MEMBER, null));
            requestedProperties.add(new OlapResIntrinsicScopedDimensionProperty(OlapUserDefinedMemberProperties.IS_UNKNOWN_MEMBER_FOR_FACTS, null));
            requestedProperties.add(new OlapResIntrinsicScopedDimensionProperty(OlapUserDefinedMemberProperties.STRUCT_HOLLOW_OF, null));
            requestedProperties.add(new OlapResIntrinsicScopedDimensionProperty(OlapUserDefinedMemberProperties.HOLLOW_OF, null));
        } else {
            requestedProperties = OlapTopLevelSelectInstr.extractRequestedMemberProperties(axisEvalContext, axisInstr);
            walkedProperties = new HashSet();
            for (OlapResScopedDimensionProperty olapResScopedDimensionProperty : requestedProperties) {
                OlapNameIdentifiableEntity scope = olapResScopedDimensionProperty.getScope();
                if (scope != null && !scope.isScoping(this.hierarchy)) continue;
                walkedProperties.addAll(olapResScopedDimensionProperty.getUserDefinedProperties());
            }
            for (OlapLevel olapLevel : levels) {
                props = olapLevel.getMemberProperties(table.getSchemaPermissionsDimensionFilter());
                for (OlapUserDefinedMemberProperty prop : props) {
                    if (walkedProperties.contains(prop)) continue;
                    walkedProperties.add(prop);
                    if (!prop.isUserDefined() || !prop.isAutoExportedToReportingMF()) continue;
                    requestedProperties.add(new OlapResUserDefinedScopedDimensionProperty(prop, (OlapNameIdentifiableEntity)olapLevel));
                }
            }
        }
        if (requestedProperties.isEmpty()) {
            return;
        }
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] evaluate member properties [" + axis + "][" + this.hierarchy.getNameX() + "]"));
        HashSet<String> allDpNames = new HashSet<String>();
        HashMap<String, OlapScalarEntityTidyType> allDpTypes = new HashMap<String, OlapScalarEntityTidyType>();
        HashMap<String, ArrayList<Object>> hashMap = new HashMap<String, ArrayList<Object>>();
        OlapMemberPropertyEvalContext propEvalContext = table.getContext().getMemberPropertyEvalContext();
        int count = this.membersSize;
        for (OlapResScopedDimensionProperty olapResScopedDimensionProperty : requestedProperties) {
            int outOfScopeCount = 0;
            ArrayList<Object> dpValues = new ArrayList<Object>();
            OlapScalarEntityTidyType dpValuesType = (OlapScalarEntityTidyType)((Object)allDpTypes.get(olapResScopedDimensionProperty.getName()));
            for (int ii = 0; ii < count; ++ii) {
                OlapScalarEntityTidyType valueType;
                Object value;
                OlapMember member = this.members.getItem(ii);
                OlapScalarEntity pValue = olapResScopedDimensionProperty.eval(propEvalContext, member);
                if (pValue != null) {
                    value = pValue.toTidyTableValue();
                    valueType = pValue.toTidyTableValueType();
                } else {
                    ++outOfScopeCount;
                    value = null;
                    valueType = OlapScalarEntityTidyType.NULL;
                }
                dpValues.add(value);
                if (dpValuesType == null || dpValuesType == OlapScalarEntityTidyType.NULL) {
                    dpValuesType = valueType;
                } else if (dpValuesType != valueType && valueType != OlapScalarEntityTidyType.NULL) {
                    dpValuesType = OlapScalarEntityTidyType.MIXED;
                }
                if (ii % 1000 != 0) continue;
                table.getContext().assertNotCancelling("materialized-tidy:eval-member-properties");
            }
            if (outOfScopeCount >= count) continue;
            allDpNames.add(olapResScopedDimensionProperty.getName());
            hashMap.put(olapResScopedDimensionProperty.getName(), dpValues);
            allDpTypes.put(olapResScopedDimensionProperty.getName(), dpValuesType);
        }
        this.dpNames = new ArrayList<String>(allDpNames);
        this.dpTypes = allDpTypes;
        this.dpValues = hashMap;
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] evaluate member properties [" + axis + "][" + this.hierarchy.getNameX() + "] done"));
    }

    @Override
    public void postProcessForDimensionProperties(OlapResMdxTidyTable table, List<OlapDimensionPropertiesTidyPostProcessorArg> propertiesR) {
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] evaluate post-processor member properties [" + String.valueOf(this.axis) + "][" + this.hierarchy.getNameX() + "]"));
        HashMap<String, TidyTableDimensionPropertyColumnMeta> allDpMetas = new HashMap<String, TidyTableDimensionPropertyColumnMeta>();
        HashSet<String> allDpNames = new HashSet<String>();
        HashMap<String, OlapScalarEntityTidyType> allDpTypes = new HashMap<String, OlapScalarEntityTidyType>();
        HashMap allDpValues = new HashMap();
        for (OlapDimensionPropertiesTidyPostProcessorArg propertyR : propertiesR) {
            String propertyName = ((OlapEntityIdentifierNamePart)propertyR.id.getLastPart()).getName();
            OlapEntityIdentifier propertyScope = propertyR.id.prefix();
            OlapMemberPropertyEvalContext propEvalContext = table.getContext().getMemberPropertyEvalContext();
            OlapMemberFilter memberFilter = propEvalContext.getSchemaPermissionsFilter();
            ArrayList<Object> dpValues = new ArrayList<Object>();
            OlapScalarEntityTidyType dpValuesType = null;
            int memberCount = this.membersSize;
            for (int mm = 0; mm < memberCount; ++mm) {
                OlapScalarEntityTidyType valueType;
                Object value;
                OlapScalarEntity pValue;
                OlapMember member = this.members.getItem(mm);
                OlapScalarEntity olapScalarEntity = pValue = member != null ? member.getPropertyValue(memberFilter, propertyName) : null;
                if (pValue != null) {
                    value = pValue.toTidyTableValue();
                    valueType = pValue.toTidyTableValueType();
                } else {
                    value = null;
                    valueType = OlapScalarEntityTidyType.NULL;
                }
                dpValues.add(value);
                if (dpValuesType == null || dpValuesType == OlapScalarEntityTidyType.NULL) {
                    dpValuesType = valueType;
                } else if (dpValuesType != valueType && valueType != OlapScalarEntityTidyType.NULL) {
                    dpValuesType = OlapScalarEntityTidyType.MIXED;
                }
                if (mm % 1000 != 0) continue;
                table.getContext().assertNotCancelling("materialized-tidy:post-processor-eval-member-properties");
            }
            allDpMetas.put(propertyName, new TidyTableDimensionPropertyColumnMeta(propertyR.axis, propertyR.pos));
            allDpNames.add(propertyName);
            allDpValues.put(propertyName, dpValues);
            allDpTypes.put(propertyName, dpValuesType);
        }
        if (this.dpNames == null) {
            this.dpNames = new ArrayList<String>();
        }
        if (this.dpTypes == null) {
            this.dpTypes = new HashMap<String, OlapScalarEntityTidyType>();
        }
        if (this.dpValues == null) {
            this.dpValues = new HashMap<String, ArrayList<Object>>();
        }
        this.dpMetas = allDpMetas;
        this.dpNames.addAll(allDpNames);
        this.dpTypes.putAll(allDpTypes);
        this.dpValues.putAll(allDpValues);
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] evaluate post-processor member properties [" + String.valueOf(this.axis) + "][" + this.hierarchy.getNameX() + "] done"));
    }

    public String toString() {
        return this.hierarchy.getNameX();
    }
}

