/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.builder;

import crazydev.common.mdx.CdMdxColorUtils;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.entity.result.tidy.builder.nonempty.OlapResMdxTidyNonEmptyCellValue;
import crazydev.iccube.olap.entity.result.tidy.common.OlapResMdxTidyBuilderList;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableCellError;
import crazydev.iccube.olap.entity.scalar.OlapErrorEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class OlapResMdxTidyBuilderCellsPage {
    private final Object LOCK = new Object();
    private final int axis;
    private final OlapTuple tuple;
    private final int tupleIdx;
    private final int cellPropertyValueIndex;
    private final int cellPropertyFormattedValueExIndex;
    private final int cellPropertyFormatStringIndex;
    private final int cellPropertyBackColorIndex;
    private final int cellPropertyForeColorIndex;
    private final OlapResMdxTidyBuilderList<Object> values = new OlapResMdxTidyBuilderList();
    private final OlapResMdxTidyBuilderList<String> formattedValues = new OlapResMdxTidyBuilderList();
    private final OlapResMdxTidyBuilderList<OlapException> errors = new OlapResMdxTidyBuilderList();
    private final OlapResMdxTidyBuilderList<String> backColors = new OlapResMdxTidyBuilderList();
    private final OlapResMdxTidyBuilderList<String> foreColors = new OlapResMdxTidyBuilderList();
    private final AtomicInteger rowCount = new AtomicInteger(-1);
    private OlapScalarEntityTidyType type = OlapScalarEntityTidyType.NULL;
    private OlapScalarEntityTidyType subType;
    private boolean formatStringOK = true;
    @Nullable
    private String formatString;

    OlapResMdxTidyBuilderCellsPage(int axis, OlapTuple tuple, int tupleIdx, int cellPropertyValueIndex, int cellPropertyFormattedValueExIndex, int cellPropertyFormatStringIndex, int cellPropertyBackColorIndex, int cellPropertyForeColorIndex) {
        this.axis = axis;
        this.tuple = tuple;
        this.tupleIdx = tupleIdx;
        this.cellPropertyValueIndex = cellPropertyValueIndex;
        this.cellPropertyFormattedValueExIndex = cellPropertyFormattedValueExIndex;
        this.cellPropertyFormatStringIndex = cellPropertyFormatStringIndex;
        this.cellPropertyBackColorIndex = cellPropertyBackColorIndex;
        this.cellPropertyForeColorIndex = cellPropertyForeColorIndex;
    }

    void assertConsistency(int rowCount) {
        if (this.rowCount.get() != rowCount) {
            throw new RuntimeException("internal error: inconsistent page [" + this.getAssertName() + "] rowCount [" + String.valueOf(this.rowCount) + "][" + rowCount + "]");
        }
    }

    private String getAssertName() {
        return this.axis + "." + this.tupleIdx + "." + String.valueOf(this.tuple);
    }

    public OlapTuple getTuple() {
        return this.tuple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapScalarEntityTidyType getType() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapScalarEntityTidyType getSubType() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.subType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFormatStringOK() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.formatStringOK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getFormatString() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.formatString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(int rowIndex) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.values.getItem(rowIndex) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapException getError(int rowIndex) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.errors.getItem(rowIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getValue(int rowIndex) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.values.getItem(rowIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getFormattedValue(int rowIndex) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.formattedValues.getItem(rowIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getBackColor(int rowIndex) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.backColors.getItem(rowIndex);
        }
    }

    @Nullable
    public String getForeColor(int rowIndex) {
        return this.foreColors.getItem(rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.rowCount.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDoubleValue(int index, double nullValue) {
        Object object = this.LOCK;
        synchronized (object) {
            Object val = this.values.getItem(index);
            return val != null ? ((Number)val).doubleValue() : nullValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] toDoubleArray(double nullValue) {
        Object object = this.LOCK;
        synchronized (object) {
            int rowCount = this.rowCount.get();
            double[] values = new double[rowCount];
            for (int rr = 0; rr < rowCount; ++rr) {
                Object val = this.values.getItem(rr);
                values[rr] = val != null ? ((Number)val).doubleValue() : nullValue;
            }
            return values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Object> getValues() {
        Object object = this.LOCK;
        synchronized (object) {
            int rowCount = this.rowCount.get();
            ArrayList<Object> values = new ArrayList<Object>(rowCount);
            for (int rr = 0; rr < rowCount; ++rr) {
                values.add(this.values.getItem(rr));
            }
            return values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<OlapResMdxTidyMaterializedTableCellError> getErrors() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean allNulls = true;
            int rowCount = this.rowCount.get();
            for (int rr = 0; rr < rowCount; ++rr) {
                if (this.errors.getItem(rr) == null) continue;
                allNulls = false;
                break;
            }
            if (allNulls) {
                return null;
            }
            ArrayList<OlapResMdxTidyMaterializedTableCellError> errors = new ArrayList<OlapResMdxTidyMaterializedTableCellError>(rowCount);
            for (int rr = 0; rr < rowCount; ++rr) {
                OlapException error = this.errors.getItem(rr);
                if (error != null) {
                    errors.add(new OlapResMdxTidyMaterializedTableCellError(error));
                    continue;
                }
                errors.add(null);
            }
            return errors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getFormattedValues() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean allNulls = true;
            int rowCount = this.rowCount.get();
            for (int rr = 0; rr < rowCount; ++rr) {
                if (this.formattedValues.getItem(rr) == null) continue;
                allNulls = false;
                break;
            }
            if (allNulls) {
                return null;
            }
            ArrayList<String> formattedValues = new ArrayList<String>(rowCount);
            for (int rr = 0; rr < rowCount; ++rr) {
                formattedValues.add(this.formattedValues.getItem(rr));
            }
            return formattedValues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getBackColors() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean allNulls = true;
            int rowCount = this.rowCount.get();
            for (int rr = 0; rr < rowCount; ++rr) {
                if (this.backColors.getItem(rr) == null) continue;
                allNulls = false;
                break;
            }
            if (allNulls) {
                return null;
            }
            ArrayList<String> backColors = new ArrayList<String>(rowCount);
            for (int rr = 0; rr < rowCount; ++rr) {
                backColors.add(this.backColors.getItem(rr));
            }
            return backColors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getForeColors() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean allNulls = true;
            int rowCount = this.rowCount.get();
            for (int rr = 0; rr < rowCount; ++rr) {
                if (this.foreColors.getItem(rr) == null) continue;
                allNulls = false;
                break;
            }
            if (allNulls) {
                return null;
            }
            ArrayList<String> foreColors = new ArrayList<String>(rowCount);
            for (int rr = 0; rr < rowCount; ++rr) {
                foreColors.add(this.foreColors.getItem(rr));
            }
            return foreColors;
        }
    }

    void addCell(int rowIndex, OlapEvalResultCellValue cellValue) {
        OlapException error = cellValue.getError();
        if (error != null) {
            this.addCellOnError(rowIndex, error);
        } else {
            this.addCellProperties(rowIndex, cellValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCellOnError(int rowIndex, OlapException error) {
        Object object = this.LOCK;
        synchronized (object) {
            this.errors.addItem(rowIndex, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCellProperties(int rowIndex, OlapEvalResultCellValue cellValue) {
        if (cellValue instanceof OlapResMdxTidyNonEmptyCellValue) {
            this.addCellPropertiesNE(rowIndex, (OlapResMdxTidyNonEmptyCellValue)cellValue);
            return;
        }
        OlapScalarEntity[] properties = cellValue.getCellPropertyValues();
        if (properties == null) {
            return;
        }
        Object value = OlapResMdxTidyBuilderCellsPage.toValue(properties, this.cellPropertyValueIndex);
        String formattedValue = (String)OlapResMdxTidyBuilderCellsPage.toValue(properties, this.cellPropertyFormattedValueExIndex);
        String backColor = OlapResMdxTidyBuilderCellsPage.toHexColor(properties, this.cellPropertyBackColorIndex);
        String foreColor = OlapResMdxTidyBuilderCellsPage.toHexColor(properties, this.cellPropertyForeColorIndex);
        String formatString = (String)OlapResMdxTidyBuilderCellsPage.toValue(properties, this.cellPropertyFormatStringIndex);
        OlapScalarEntityTidyType type = OlapResMdxTidyBuilderCellsPage.toValueType(properties, this.cellPropertyValueIndex);
        Object object = this.LOCK;
        synchronized (object) {
            if (value != null) {
                this.values.addItem(rowIndex, value);
            }
            if (formattedValue != null) {
                this.formattedValues.addItem(rowIndex, formattedValue);
            }
            if (backColor != null) {
                this.backColors.addItem(rowIndex, backColor);
            }
            if (foreColor != null) {
                this.foreColors.addItem(rowIndex, foreColor);
            }
            if (formatString != null) {
                if (this.formatString == null) {
                    this.formatString = formatString;
                } else if (!this.formatString.equals(formatString)) {
                    this.formatStringOK = false;
                    this.formatString = null;
                }
            }
            this.type = OlapResMdxTidyBuilderCellsPage.inferType(this.type, type);
            if (this.type == OlapScalarEntityTidyType.LIST) {
                OlapScalarEntityTidyType subType = OlapResMdxTidyBuilderCellsPage.toValueSubType(properties, this.cellPropertyValueIndex);
                this.subType = OlapResMdxTidyBuilderCellsPage.inferType(this.subType, subType);
            } else {
                this.subType = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCellPropertiesNE(int rowIndex, OlapResMdxTidyNonEmptyCellValue cellValue) {
        Object value = cellValue.value();
        String formattedValue = cellValue.formattedValue();
        String backColor = cellValue.backColor();
        String foreColor = cellValue.foreColor();
        Object object = this.LOCK;
        synchronized (object) {
            if (rowIndex == 0) {
                this.formatStringOK = cellValue.formatStringOK();
                this.formatString = cellValue.formatString();
                this.type = cellValue.type();
                this.subType = cellValue.subType();
            }
            if (value != null) {
                this.values.addItem(rowIndex, value);
            }
            if (formattedValue != null) {
                this.formattedValues.addItem(rowIndex, formattedValue);
            }
            if (backColor != null) {
                this.backColors.addItem(rowIndex, backColor);
            }
            if (foreColor != null) {
                this.foreColors.addItem(rowIndex, foreColor);
            }
        }
    }

    public void onEvaluateCellValuesDone(int rowCount) {
        this.rowCount.set(rowCount);
    }

    private static OlapScalarEntityTidyType inferType(@Nullable OlapScalarEntityTidyType type, @Nullable OlapScalarEntityTidyType vType) {
        if (vType == null || vType == OlapScalarEntityTidyType.NULL) {
            return type;
        }
        if (vType == OlapScalarEntityTidyType.UNKNOWN || vType == OlapScalarEntityTidyType.MIXED) {
            return vType;
        }
        if (type == null || type == OlapScalarEntityTidyType.NULL) {
            return vType;
        }
        if (type != vType) {
            return OlapScalarEntityTidyType.MIXED;
        }
        return type;
    }

    @Nullable
    private static OlapScalarEntityTidyType toValueType(OlapScalarEntity[] properties, int propIndex) {
        OlapScalarEntity value = propIndex != -1 ? properties[propIndex] : null;
        return value != null ? value.toTidyTableValueType() : null;
    }

    @Nullable
    private static OlapScalarEntityTidyType toValueSubType(OlapScalarEntity[] properties, int propIndex) {
        OlapScalarEntity value = propIndex != -1 ? properties[propIndex] : null;
        return value != null ? value.toTidyTableValueSubType() : null;
    }

    @Nullable
    private static <T> T toValue(OlapScalarEntity[] properties, int propIndex) {
        OlapScalarEntity value = propIndex != -1 ? properties[propIndex] : null;
        return (T)(value != null ? value.toTidyTableValueEx() : null);
    }

    @Nullable
    private static String toHexColor(OlapScalarEntity[] properties, int propIndex) {
        OlapScalarEntity value;
        OlapScalarEntity olapScalarEntity = value = propIndex != -1 ? properties[propIndex] : null;
        if (value == null) {
            return null;
        }
        if (value instanceof OlapErrorEntity) {
            return null;
        }
        Object tdValue = value.toTidyTableValue();
        if (tdValue == null) {
            return null;
        }
        if (tdValue instanceof Number || tdValue instanceof String) {
            try {
                Number num = tdValue instanceof String ? (Number)Integer.parseInt((String)tdValue) : (Number)((Number)tdValue);
                String hex = CdMdxColorUtils.hexValue((int)num.intValue());
                return hex;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        return this.tuple.toString();
    }
}

