/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy.builder;

import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapSubSelectCube;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMeasureVectorMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.entity.properties.cell.OlapIntrinsicCellProperties;
import crazydev.iccube.olap.entity.result.OlapResAxisName;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTable;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderAxisTuple;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderCellsColumn;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderCellsPage;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderColumn;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderMembersAxis;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderMembersColumn;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.facts.cells.processor.OlapCellMeasureVectorsPositions;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;
import crazydev.iccube.olap.eval.result.OlapEvalResultSi;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapDimensionPropertiesTidyPostProcessorArg;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class OlapResMdxTidyBuilder {
    private final OlapResMdxTidyTable table;
    private final Map<Integer, OlapResMdxTidyBuilderMembersAxis> membersAxesByAxis = new HashMap<Integer, OlapResMdxTidyBuilderMembersAxis>();
    private final List<OlapResMdxTidyBuilderColumn> columns;
    private final Map<Integer, List<OlapResMdxTidyBuilderColumn>> columnsByAxis = new HashMap<Integer, List<OlapResMdxTidyBuilderColumn>>();
    private final Map<Integer, List<OlapResMdxTidyBuilderMembersColumn>> membersColumnsByAxis = new HashMap<Integer, List<OlapResMdxTidyBuilderMembersColumn>>();
    private final List<OlapResMdxTidyBuilderCellsColumn> cellsColumns = new ArrayList<OlapResMdxTidyBuilderCellsColumn>();
    private final int cellsPagesCount;
    private final int cellsColumnsStart;
    private final AtomicInteger cellCount = new AtomicInteger();
    private final AtomicInteger rowCount = new AtomicInteger();
    private final AtomicBoolean tidyMaxRowCountReached = new AtomicBoolean();
    private final AtomicBoolean initialSelectionRequested = new AtomicBoolean();
    private final List<OlapMember> initialSelection = new ArrayList<OlapMember>();
    private final AtomicInteger addCellValueCount = new AtomicInteger();

    public OlapResMdxTidyBuilder(OlapResMdxTidyTable table, OlapTuple[] cellTuple, OlapEvalResultCellValue cellValue) {
        this.table = table;
        this.columns = this.createColumns(cellValue.getCellSi(), cellTuple);
        int cellsColumnsStart = -1;
        for (int cc = 0; cc < this.columns.size(); ++cc) {
            OlapResMdxTidyBuilderColumn column = this.columns.get(cc);
            int axis = (int)column.axis.getNumber();
            this.columnsByAxis.computeIfAbsent(axis, k -> new ArrayList()).add(column);
            if (column instanceof OlapResMdxTidyBuilderMembersColumn) {
                this.membersColumnsByAxis.computeIfAbsent(axis, k -> new ArrayList()).add((OlapResMdxTidyBuilderMembersColumn)column);
            }
            if (!(column instanceof OlapResMdxTidyBuilderCellsColumn)) continue;
            this.cellsColumns.add((OlapResMdxTidyBuilderCellsColumn)column);
            if (cellsColumnsStart != -1) continue;
            cellsColumnsStart = cc;
        }
        this.cellsColumnsStart = cellsColumnsStart;
        int cellsPagesCount = 1;
        if (!this.cellsColumns.isEmpty()) {
            OlapResMdxTidyBuilderCellsColumn aColumn = this.cellsColumns.get(0);
            cellsPagesCount = aColumn.getPageCount();
        }
        this.cellsPagesCount = cellsPagesCount;
    }

    private List<OlapResMdxTidyBuilderColumn> createColumns(OlapEvalResultSi cellSi, OlapTuple[] cellTuple) {
        List<OlapResMdxTidyBuilderColumn> columnsFromAxisN = this.createColumnsFromAxisN(cellSi, cellTuple);
        List<OlapResMdxTidyBuilderCellsColumn> columnsFromAxis0 = OlapResMdxTidyBuilder.createColumnsFromAxis0(this.table);
        ArrayList<OlapResMdxTidyBuilderColumn> columns = new ArrayList<OlapResMdxTidyBuilderColumn>();
        columns.addAll(columnsFromAxisN);
        columns.addAll(columnsFromAxis0);
        return columns;
    }

    public String logAxesTupleCount() {
        StringBuilder sb = new StringBuilder("");
        int axisCount = this.table.getAxisCount();
        for (int axis = 0; axis < axisCount; ++axis) {
            if (axis > 0) {
                sb.append("x");
            }
            sb.append(this.logAxisTupleCount(axis));
        }
        return sb.toString();
    }

    private String logAxisTupleCount(int axis) {
        try {
            if (axis == 0 && this.table.isAxis0asColumns()) {
                return String.valueOf(this.cellsColumns.size());
            }
            if (axis == this.table.getAxisCount() - 1 && this.table.isWithPaging()) {
                if (this.cellsColumns.size() > 1) {
                    return String.valueOf(this.cellsColumns.get(0).getPageCount());
                }
                return "?";
            }
            OlapResMdxTidyBuilderMembersColumn members = this.getMemberColumn(axis, 0);
            return String.valueOf(members.getAxisLength());
        }
        catch (RuntimeException ignored) {
            OlapLoggers.MDX_EVALUATION.warn((Object)("[mdx] logAxisTupleCount(" + axis + ") error"), (Throwable)ignored);
            return "?";
        }
    }

    @Nullable
    public OlapException getCellError() {
        for (OlapResMdxTidyBuilderCellsColumn cellsColumn : this.cellsColumns) {
            OlapException error = cellsColumn.getError(this.rowCount.get());
            if (error == null) continue;
            return error;
        }
        return null;
    }

    public int getCellCount() {
        return this.cellCount.get();
    }

    public int getRowCount() {
        return this.rowCount.get();
    }

    public boolean isTidyMaxRowCountReached() {
        return this.tidyMaxRowCountReached.get();
    }

    public List<OlapResMdxTidyBuilderColumn> getColumns() {
        return this.columns;
    }

    public List<OlapResMdxTidyBuilderColumn> getColumns(int axis) {
        List<OlapResMdxTidyBuilderColumn> columns = this.columnsByAxis.get(axis);
        if (columns != null) {
            return columns;
        }
        return Collections.emptyList();
    }

    public OlapResMdxTidyBuilderMembersColumn getMemberColumn(int axis, int hierarchyIndex) {
        List<OlapResMdxTidyBuilderMembersColumn> columns = this.membersColumnsByAxis.get(axis);
        if (columns != null) {
            OlapResMdxTidyBuilderMembersColumn column = columns.get(hierarchyIndex);
            if (column.getHierarchyIdx() == hierarchyIndex) {
                return column;
            }
            throw new RuntimeException("internal error: inconsistent getMemberColumns [" + axis + "][" + hierarchyIndex + "] " + column.getHierarchyIdx() + ":" + column.getHierarchy().getNameX());
        }
        throw new RuntimeException("internal error: inconsistent getMemberColumns [" + axis + "][" + hierarchyIndex + "] null");
    }

    public List<OlapResMdxTidyBuilderCellsColumn> getCellsColumns() {
        return this.cellsColumns;
    }

    @Nullable
    public List<OlapMember> getInitialSelection() {
        if (this.initialSelectionRequested.get()) {
            return this.initialSelection;
        }
        return null;
    }

    public static List<OlapResMdxTidyBuilderCellsColumn> createColumnsFromAxis0(OlapResMdxTidyTable table) {
        if (!table.isAxis0asColumns()) {
            return Collections.emptyList();
        }
        OlapCellMeasureVectorsPositions measureVectorPositions = table.getContext().getMeasureVectorsPositions();
        int axisCount = table.getAxisCount();
        boolean hasPaging = table.isWithPaging();
        int pagingAxis = hasPaging ? axisCount - 1 : -1;
        ArrayList<OlapResMdxTidyBuilderCellsColumn> columns = new ArrayList<OlapResMdxTidyBuilderCellsColumn>();
        OlapResAxisName axis0name = table.getAxisName(0);
        List<OlapTuple> axis0 = table.getAxis0();
        OlapResMdxTidyBuilder.forEachAxisTuple(measureVectorPositions, axis0, (tuple, tupleIndex) -> columns.add(new OlapResMdxTidyBuilderCellsColumn(axis0name, tuple, tupleIndex, pagingAxis, OlapResMdxTidyBuilder.createPagingColumns(table, measureVectorPositions, pagingAxis, tuple, tupleIndex), OlapResMdxTidyBuilder.cellsFS(tuple), OlapResMdxTidyBuilder.cellsColor(table.getContext(), tuple), OlapResMdxTidyBuilder.cellsColors(table.getContext(), tuple), table.cellPropertyValueIndex(), table.cellPropertyFormattedValueExIndex(), table.cellPropertyFormatStringIndex(), table.cellPropertyBackColorIndex(), table.cellPropertyForeColorIndex())));
        return columns;
    }

    private static List<OlapResMdxTidyBuilderCellsPage> createPagingColumns(OlapResMdxTidyTable table, OlapCellMeasureVectorsPositions measureVectorPositions, int pagingAxis, OlapTuple cellTuple, int cellTupleIndex) {
        ArrayList<OlapResMdxTidyBuilderCellsPage> pages = new ArrayList<OlapResMdxTidyBuilderCellsPage>();
        if (pagingAxis == -1) {
            pages.add(new OlapResMdxTidyBuilderCellsPage(0, cellTuple, cellTupleIndex, table.cellPropertyValueIndex(), table.cellPropertyFormattedValueExIndex(), table.cellPropertyFormatStringIndex(), table.cellPropertyBackColorIndex(), table.cellPropertyForeColorIndex()));
        } else {
            List<OlapTuple> paging = table.getAxisPaging();
            OlapResMdxTidyBuilder.forEachAxisTuple(measureVectorPositions, paging, (tuple, tupleIndex) -> pages.add(new OlapResMdxTidyBuilderCellsPage(pagingAxis, tuple, tupleIndex, table.cellPropertyValueIndex(), table.cellPropertyFormattedValueExIndex(), table.cellPropertyFormatStringIndex(), table.cellPropertyBackColorIndex(), table.cellPropertyForeColorIndex())));
        }
        return pages;
    }

    private static String cellsFS(OlapTuple tuple) {
        int memberCount = tuple.getMemberCount();
        for (int hh = 0; hh < memberCount; ++hh) {
            OlapMember member = tuple.getMember(hh);
            String fs = OlapResMdxTidyBuilder.memberFormatString(member);
            if (fs == null) continue;
            return fs;
        }
        return null;
    }

    @Nullable
    public static String memberFormatString(OlapMember member) {
        String val;
        OlapCellPropertyValue fs = member.getCellPropertyValue(OlapIntrinsicCellProperties.FORMAT_STRING);
        if (fs != null && (val = fs.asStringValue()) != null) {
            return val;
        }
        return null;
    }

    @Nullable
    private static String cellsColor(OlapMdxStatementExecutionContext context, OlapTuple tuple) {
        int memberCount = tuple.getMemberCount();
        for (int hh = 0; hh < memberCount; ++hh) {
            OlapMember member = tuple.getMember(hh);
            String color = OlapResMdxTidyBuilder.memberColor(context, member);
            if (color == null) continue;
            return color;
        }
        return null;
    }

    @Nullable
    private static String[] cellsColors(OlapMdxStatementExecutionContext context, OlapTuple tuple) {
        int memberCount = tuple.getMemberCount();
        String[] colors = null;
        for (int hh = 0; hh < memberCount; ++hh) {
            OlapMember member = tuple.getMember(hh);
            String color = OlapResMdxTidyBuilder.memberColor(context, member);
            if (color == null) continue;
            if (colors == null) {
                colors = new String[memberCount];
            }
            colors[hh] = color;
        }
        return colors;
    }

    @Nullable
    public static String memberColor(OlapMdxStatementExecutionContext context, OlapMember member) {
        OlapScalarEntity color = member.getPropertyValue(context.getSchemaPermissionsDimensionFilter(), "@Ic3Color");
        if (color != null && !color.isMdxNull()) {
            return color.asString();
        }
        String colorS = context.getColor(member);
        if (colorS != null) {
            return colorS;
        }
        return null;
    }

    private List<OlapResMdxTidyBuilderColumn> createColumnsFromAxisN(OlapEvalResultSi cellSi, OlapTuple[] cellTuple) {
        ArrayList<OlapResMdxTidyBuilderColumn> columns = new ArrayList<OlapResMdxTidyBuilderColumn>();
        boolean axis0asColumns = this.table.isAxis0asColumns();
        boolean hasPaging = this.table.isWithPaging();
        int axisCount = this.table.getAxisCount();
        int from = axis0asColumns ? 1 : 0;
        int to = hasPaging ? axisCount - 1 : axisCount;
        for (int aa = from; aa < to; ++aa) {
            OlapResMdxTidyBuilderMembersAxis membersAxis = this.membersAxesByAxis.computeIfAbsent(aa, k -> new OlapResMdxTidyBuilderMembersAxis());
            OlapTuple aTuple = cellTuple[aa];
            int memberCount = aTuple.getMemberCount();
            for (int hh = 0; hh < memberCount; ++hh) {
                OlapMember member = aTuple.getMember(hh);
                OlapHierarchy hierarchy = member.getHierarchy();
                OlapResAxisName axisName = this.table.getAxisName(aa);
                columns.add(new OlapResMdxTidyBuilderMembersColumn(axisName, hierarchy, hh, membersAxis));
            }
        }
        return columns;
    }

    public void addCellValue(IOlapEvaluationExceptionContext context, int rowIndex, OlapTuple[] cellTuple, OlapEvalResultCellValue cellValue) {
        if (this.addCellValueCount.incrementAndGet() % 1000 == 0) {
            this.table.getContext().assertNotCancelling("tidy-builder:add-cell-value(" + this.addCellValueCount.get() + ")");
        }
        this.populateMembersColumns(rowIndex, cellTuple, cellValue);
        if (this.cellsColumns.size() > 0) {
            int count = this.cellCount.incrementAndGet();
            if (count > 0 && count % 100000 == 0) {
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] cells : " + count));
            }
            this.populateCellsColumns(rowIndex, cellTuple, cellValue);
        }
    }

    private void populateMembersColumns(int rowIndex, OlapTuple[] cellTuple, OlapEvalResultCellValue cellValue) {
        int[] Si = cellValue.getCellSi().getSi();
        boolean axis0asColumns = this.table.isAxis0asColumns();
        if (axis0asColumns && Si[0] != 0) {
            return;
        }
        boolean hasPaging = this.table.isWithPaging();
        if (hasPaging && Si[Si.length - 1] != 0) {
            return;
        }
        int axisCount = this.table.getAxisCount();
        int from = axis0asColumns ? 1 : 0;
        int to = hasPaging ? axisCount - 1 : axisCount;
        int cc = 0;
        for (int aa = from; aa < to; ++aa) {
            OlapTuple tuple = cellTuple[aa];
            int tupleIndex = Si[aa];
            int memberCount = tuple.getMemberCount();
            OlapResMdxTidyBuilderMembersAxis membersAxis = this.membersAxesByAxis.get(aa);
            membersAxis.addTuple(rowIndex, tupleIndex);
            for (int hh = 0; hh < memberCount; ++hh) {
                OlapMember member = tuple.getMember(hh);
                OlapResMdxTidyBuilderColumn column = this.columns.get(cc++);
                OlapResMdxTidyBuilderMembersColumn membersColumn = (OlapResMdxTidyBuilderMembersColumn)column;
                membersColumn.addMember(rowIndex, tupleIndex, member);
            }
        }
    }

    private void populateCellsColumns(int rowIndex, OlapTuple[] cellTuple, OlapEvalResultCellValue cellValue) {
        boolean axis0asColumns = this.table.isAxis0asColumns();
        if (!axis0asColumns) {
            return;
        }
        int[] Si = cellValue.getCellSi().getSi();
        int si = Si[0];
        OlapResMdxTidyBuilderColumn column = this.columns.get(this.cellsColumnsStart + si);
        OlapResMdxTidyBuilderCellsColumn cColumn = (OlapResMdxTidyBuilderCellsColumn)column;
        cColumn.addCell(this.table.isWithDebugger(), rowIndex, cellTuple, cellValue);
    }

    public static void forEachAxisTuple(OlapCellMeasureVectorsPositions measureVectorPositions, List<OlapTuple> axis, OlapResMdxTidyBuilderAxisTuple consumer) {
        int tt;
        int tuplesCount = axis.size();
        boolean hasMeasureVector = false;
        int measureCount = 0;
        for (tt = 0; tt < tuplesCount; ++tt) {
            OlapTuple tuple = axis.get(tt);
            if (tuple.getMemberCount() == 1 && tuple.getMember(0) instanceof OlapMeasureVectorMember) {
                measureCount += tuple.getMember(0).getMeasureVectorSize();
                hasMeasureVector = true;
                continue;
            }
            ++measureCount;
        }
        if (!hasMeasureVector) {
            for (tt = 0; tt < tuplesCount; ++tt) {
                consumer.tuple(axis.get(tt), tt);
            }
        } else {
            int tt2;
            OlapTuple[] fixedAxis = new OlapTuple[measureCount];
            for (tt2 = 0; tt2 < tuplesCount; ++tt2) {
                OlapTuple tuple = axis.get(tt2);
                OlapMember member = tuple.getMember(0);
                if (member instanceof OlapMeasureVectorMember) {
                    List<OlapMeasureMember> measures = ((OlapMeasureVectorMember)member).getMeasures();
                    for (OlapMeasureMember measure : measures) {
                        fixedAxis[measureVectorPositions.getInitialPosition((OlapMember)measure)] = measure;
                    }
                    continue;
                }
                fixedAxis[measureVectorPositions.getInitialPosition((OlapMember)member)] = member;
            }
            for (tt2 = 0; tt2 < fixedAxis.length; ++tt2) {
                consumer.tuple(fixedAxis[tt2], tt2);
            }
        }
    }

    public void onEvaluateCellValuesDone(boolean tidyMaxRowCountReached, int rowIndex) {
        int expectedCellCount;
        this.rowCount.set(rowIndex + 1);
        this.tidyMaxRowCountReached.set(tidyMaxRowCountReached);
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] evaluate cell-values [tidy] done [tidy-max-row-count-reached:" + tidyMaxRowCountReached + "][row-count:" + this.rowCount.get() + "]"));
        for (OlapResMdxTidyBuilderColumn column : this.columns) {
            column.onEvaluateCellValuesDone(this.rowCount.get(), this.table);
        }
        for (OlapResMdxTidyBuilderColumn column : this.columns) {
            column.assertConsistency(this.rowCount.get());
        }
        int thisCellCount = this.getCellCount();
        if (thisCellCount != (expectedCellCount = this.cellsColumns.size() * this.cellsPagesCount * this.getRowCount())) {
            throw new RuntimeException("internal error: inconsistent cells count [" + thisCellCount + "] vs. [" + expectedCellCount + "]");
        }
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] evaluate cell-values [tidy] completed [row-count:" + this.rowCount.get() + "]"));
    }

    public void evaluatedInitialSelection(@Nullable String[] initialSelection) {
        try {
            if (initialSelection == null || initialSelection.length == 0) {
                return;
            }
            OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] evaluate initial-selection");
            this.initialSelectionRequested.set(true);
            OlapResMdxTidyBuilderMembersColumn column = this.table.getBuilderMembersColumn(0, 0);
            OlapHierarchy hierarchy = column.getHierarchy();
            ArrayList<OlapMember> iMembers = new ArrayList<OlapMember>();
            HashSet<OlapMember> members = new HashSet<OlapMember>();
            OlapMdxStatementExecutionContext context = this.table.getContext();
            OlapNameContext nameContext = context.getNameContext();
            IOlapDimensionsPermission permissions = context.getDimensionsPermissions();
            OlapSubSelectCube subSelect = context.getSubSelectCube();
            for (String selection : initialSelection) {
                OlapEntityIdentifier id = new OlapEntityIdentifier(selection);
                OlapNonScalarEntity entity = hierarchy.lookupEntityByMdxIdentifier(nameContext, permissions, id);
                if (entity.isFilteredOut() || !(entity instanceof OlapMember)) continue;
                OlapMember member = (OlapMember)entity;
                if (subSelect != null && !subSelect.isAcceptingMember(member) || !members.add(member)) continue;
                iMembers.add(member);
            }
            this.initialSelection.addAll(iMembers);
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] evaluate initial-selection done [" + members.size() + "]"));
        }
        catch (RuntimeException ignored) {
            OlapLoggers.MDX_EVALUATION.warn((Object)"[mdx] initial-selection error", (Throwable)ignored);
        }
    }

    public void postProcessForDimensionProperties(List<OlapDimensionPropertiesTidyPostProcessorArg> propertiesR) {
        for (OlapResMdxTidyBuilderColumn column : this.columns) {
            if (!(column instanceof OlapResMdxTidyBuilderMembersColumn)) continue;
            OlapResMdxTidyBuilderMembersColumn members = (OlapResMdxTidyBuilderMembersColumn)column;
            OlapHierarchy hierarchy = members.getHierarchy();
            int axis = (int)members.getAxis().getNumber();
            ArrayList<OlapDimensionPropertiesTidyPostProcessorArg> propsR = new ArrayList<OlapDimensionPropertiesTidyPostProcessorArg>();
            for (OlapDimensionPropertiesTidyPostProcessorArg propR : propertiesR) {
                if (!hierarchy.equals(propR.hierarchy) || propR.axis != null && propR.axis != axis) continue;
                propsR.add(propR);
            }
            if (propsR.isEmpty()) continue;
            members.postProcessForDimensionProperties(this.table, propsR);
        }
    }
}

