/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class TidyTableColumnNaN {
    private Set<Integer> NaN;
    private Set<Integer> InfinityP;
    private Set<Integer> InfinityN;

    @Nullable
    public static TidyTableColumnNaN createNaN(ArrayList<Object> values) {
        TidyTableColumnNaN nan = null;
        for (int ii = 0; ii < values.size(); ++ii) {
            Object value = values.get(ii);
            if (!(value instanceof Double)) continue;
            Double dd = (Double)value;
            if (Double.isNaN(dd)) {
                values.set(ii, null);
                nan = TidyTableColumnNaN.setNaN(nan, ii);
                continue;
            }
            if (!Double.isInfinite(dd)) continue;
            if (dd < 0.0) {
                values.set(ii, null);
                nan = TidyTableColumnNaN.setInfinityN(nan, ii);
                continue;
            }
            values.set(ii, null);
            nan = TidyTableColumnNaN.setInfinityP(nan, ii);
        }
        if (nan != null) {
            nan.freeze();
        }
        return nan;
    }

    public static TidyTableColumnNaN setNaN(@Nullable TidyTableColumnNaN nan, int pos) {
        if (nan == null) {
            nan = new TidyTableColumnNaN();
        }
        nan.setNaN(pos);
        return nan;
    }

    public static TidyTableColumnNaN setInfinityP(@Nullable TidyTableColumnNaN nan, int pos) {
        if (nan == null) {
            nan = new TidyTableColumnNaN();
        }
        nan.setInfinityP(pos);
        return nan;
    }

    public static TidyTableColumnNaN setInfinityN(@Nullable TidyTableColumnNaN nan, int pos) {
        if (nan == null) {
            nan = new TidyTableColumnNaN();
        }
        nan.setInfinityN(pos);
        return nan;
    }

    private void setNaN(int pos) {
        if (this.NaN == null) {
            this.NaN = new HashSet<Integer>();
        }
        this.NaN.add(pos);
    }

    private void setInfinityP(int pos) {
        if (this.InfinityP == null) {
            this.InfinityP = new HashSet<Integer>();
        }
        this.InfinityP.add(pos);
    }

    private void setInfinityN(int pos) {
        if (this.InfinityN == null) {
            this.InfinityN = new HashSet<Integer>();
        }
        this.InfinityN.add(pos);
    }

    @Nullable
    public Double get(int pos) {
        if (this.NaN != null && this.NaN.contains(pos)) {
            return Double.NaN;
        }
        if (this.InfinityP != null && this.InfinityP.contains(pos)) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.InfinityN != null && this.InfinityN.contains(pos)) {
            return Double.NEGATIVE_INFINITY;
        }
        return null;
    }

    public void freeze() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TidyTableColumnNaN that = (TidyTableColumnNaN)o;
        return Objects.equals(this.NaN, that.NaN) && Objects.equals(this.InfinityP, that.InfinityP) && Objects.equals(this.InfinityN, that.InfinityN);
    }
}

