/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.tidy;

import crazydev.iccube.olap.entity.result.tidy.IOlapResTidyTableColumn;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import java.util.ArrayList;

public class OlapResFlatTidyTableColumn<T>
extends IOlapResTidyTableColumn<T> {
    private final ArrayList<T> values;

    public OlapResFlatTidyTableColumn(OlapScalarEntityTidyType type, String name, String caption) {
        this(type, name, caption, new ArrayList());
    }

    public OlapResFlatTidyTableColumn(OlapScalarEntityTidyType type, String name, String caption, ArrayList<T> values) {
        super(type, name, caption);
        this.values = values;
    }

    @Override
    public int getRowCount() {
        return this.values.size();
    }

    public ArrayList<T> getValues() {
        return this.values;
    }

    @Override
    public double getDoubleValue(int index, double nullValue) {
        if (this.getType() == OlapScalarEntityTidyType.NUMERIC) {
            T val = this.values.get(index);
            return val == null ? nullValue : ((Number)val).doubleValue();
        }
        return super.getDoubleValue(index, nullValue);
    }

    @Override
    public double[] toDoubleArray(double nullValue) {
        if (this.getType() == OlapScalarEntityTidyType.NUMERIC) {
            return this.values.stream().mapToDouble(o -> o == null ? nullValue : ((Number)o).doubleValue()).toArray();
        }
        return super.toDoubleArray(nullValue);
    }

    public void add(T value) {
        this.values.add(value);
    }

    public void add(int count, T value) {
        for (int i = 0; i < count; ++i) {
            this.values.add(value);
        }
    }
}

