/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.slicer;

import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.slicer.OlapAxisSlicerTupleFilter;
import crazydev.iccube.olap.entity.result.slicer.OlapResSlicer;
import crazydev.iccube.olap.entity.result.slicer.OlapSlicerExistsFilterFactory;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.filter.dimension.IOlapSimpleExistsFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapSimpleEmptyExistsFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleSlicerFilter;
import crazydev.iccube.olap.eval.select.OlapAxisInstr;
import crazydev.iccube.olap.eval.select.OlapSlicerInstr;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OlapSlicerFilter
extends OlapTupleSlicerFilter {
    protected final OlapResSlicer slicer;
    protected final OlapTupleDimensionality slicerTupleDimensionality;
    private final OlapTupleDimensionalityCache statementCache;
    private final Map<OlapTupleDimensionality, IOlapSimpleExistsFilter> filters = new ConcurrentHashMap<OlapTupleDimensionality, IOlapSimpleExistsFilter>();
    private final Map<OlapHierarchy, List<OlapMember>> cachedDefinedMember = new ConcurrentHashMap<OlapHierarchy, List<OlapMember>>();
    private final OlapBitSet slicerDimDimensionality = new OlapBitSet();

    public OlapSlicerFilter(OlapTupleDimensionalityCache statementCache, OlapResSlicer slicer) {
        this.statementCache = statementCache;
        this.slicer = slicer;
        this.slicerTupleDimensionality = slicer.getAnyTuple().getTupleDimensionality();
        slicer.getAnyTuple().setDimensionBitSet(this.slicerDimDimensionality);
    }

    @Override
    public String getName() {
        return "slicer-dimension";
    }

    @Override
    public boolean isFilteringHierarchy(OlapHierarchy hierarchy) {
        return this.slicerTupleDimensionality.isIn(hierarchy);
    }

    @Override
    public boolean isAccepting(OlapMember member) {
        IOlapSimpleExistsFilter filter = this.getOrCreate(member);
        return filter.isAccepting(member);
    }

    @Override
    public boolean isAccepting(IOlapTuple tuple) {
        IOlapSimpleExistsFilter filter = this.getOrCreate(tuple);
        return filter.isAccepting(tuple);
    }

    private IOlapSimpleExistsFilter getOrCreate(IOlapTuple tuple) {
        IOlapSimpleExistsFilter filter = this.filters.get(tuple.getTupleDimensionality());
        if (filter != null) {
            return filter;
        }
        return this.create(tuple);
    }

    private synchronized IOlapSimpleExistsFilter create(IOlapTuple tuple) {
        IOlapSimpleExistsFilter filter = this.filters.get(tuple.getTupleDimensionality());
        if (filter == null) {
            OlapBitSet tupleDim = new OlapBitSet();
            tuple.setDimensionBitSet(tupleDim);
            if (!tupleDim.intersects(this.slicerDimDimensionality)) {
                filter = OlapSimpleEmptyExistsFilter.INSTANCE;
            } else {
                tupleDim.and(this.slicerDimDimensionality);
                filter = OlapSlicerExistsFilterFactory.createSlicer(this.statementCache, tuple, tupleDim, this);
            }
            this.filters.put(tuple.getTupleDimensionality(), filter);
        }
        return filter;
    }

    public OlapTupleFilter asAxisFilter(OlapAxisInstr axisInstr) {
        return new OlapAxisSlicerTupleFilter(axisInstr, this);
    }

    @Override
    public boolean hasHierarchy(OlapHierarchy hierarchy) {
        return this.slicerTupleDimensionality.isIn(hierarchy);
    }

    @Override
    public OlapSlicerInstr getSlicerInstr() {
        return this.slicer.getSlicerInstr();
    }

    public List<OlapMember> getDefinedMembers(OlapHierarchy hierarchy) {
        return this.cachedDefinedMember.computeIfAbsent(hierarchy, olapHierarchy -> {
            ArrayList list = new ArrayList();
            this.slicer.forEachMember(member -> {
                if (member.getHierarchy() == hierarchy) {
                    list.add(member);
                }
            }, o -> true);
            return list;
        });
    }
}

