/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.slicer;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.slicer.OlapResSlicer;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrExecutionContext;
import crazydev.iccube.olap.eval.select.OlapSlicerInstr;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class OlapResSetSlicer
extends OlapResSlicer {
    public OlapResSetSlicer(OlapEvaluationContext context, OlapSlicerInstr slicerInstr, List<OlapTuple> tupleList, boolean membersCrossjoin) {
        super(context, slicerInstr, tupleList, membersCrossjoin);
    }

    @Override
    @Nullable
    public OlapMember getMember(OlapInstrExecutionContext context, OlapHierarchy hierarchy) {
        OlapMember member = null;
        if (this.firstTuple.hasMember(hierarchy)) {
            for (OlapTuple tuple : this.getTupleList()) {
                OlapMember xmember = tuple.getMember(hierarchy);
                if (member == null) {
                    member = xmember;
                    continue;
                }
                if (member.equals(xmember)) continue;
                OlapNameContext nameContext = context.getNameContext();
                throw new OlapEvaluationException(context, OlapErrorCode.SLICER_SET_CURRENT_MEMBER, new Serializable[]{hierarchy.getUniqueName(nameContext)});
            }
        }
        return member;
    }

    @Override
    @Nullable
    public OlapMeasureMember getMeasure(IOlapEvaluationExceptionContext context) {
        OlapMember measure = null;
        for (OlapTuple tuple : this.getTupleList()) {
            OlapMember tupleMeasure = null;
            for (int ii = 0; ii < tuple.getMemberCount(); ++ii) {
                OlapMember member = tuple.getMember(ii);
                if (!(member instanceof OlapMeasureMember)) continue;
                tupleMeasure = (OlapMeasureMember)member;
                break;
            }
            if (tupleMeasure == null) continue;
            if (measure == null) {
                measure = tupleMeasure;
                continue;
            }
            if (measure.equals(tupleMeasure)) continue;
            OlapHierarchy hierarchy = measure.getHierarchy();
            OlapNameContext nameContext = context.getNameContext();
            throw new OlapEvaluationException(context, OlapErrorCode.SLICER_SET_CURRENT_MEMBER, new Serializable[]{hierarchy.getUniqueName(nameContext)});
        }
        return measure;
    }

    @Override
    public void assertConsistency(OlapInstrExecutionContext context) {
        this.assertMeasuresAndCalcMembersConsistency(context);
    }

    @Override
    public void forEachMember(Consumer<OlapMember> consumer, Predicate<OlapMember> filter) {
        for (int i = 0; i < this.getTupleList().size(); ++i) {
            OlapTuple tuple = this.getTupleList().get(i);
            tuple.forEach(consumer, filter);
        }
    }

    private void assertMeasuresAndCalcMembersConsistency(OlapInstrExecutionContext context) {
        OlapMember prevMeasure = null;
        for (OlapTuple tuple : this.getTupleList()) {
            if (tuple.hasCalcMember()) {
                throw new OlapEvaluationException(context, OlapErrorCode.SLICER_AGGREGATION_CALC_MEMBERS, new Serializable[0]);
            }
            OlapMember member = tuple.getMeasureMember();
            if (member == null) continue;
            if (prevMeasure != null) {
                if (prevMeasure.equals(member)) continue;
                throw new OlapEvaluationException(context, OlapErrorCode.SLICER_AGGREGATION_MEASURES, new Serializable[0]);
            }
            prevMeasure = member;
        }
    }
}

